//.............................................................................
//   Program Name: KJFSORT.PRG       Copyright: ACE Inc. Software Development                            
//   Date Created: 02/16/93           Language: Clipper 5.0                                         
//   Time Created: 14:59:02             Author: Kevin J. Farley                           
//   Purpose: to return an array of all possible arrangements of an array
//.............................................................................

#include "class(y).ch"             
#include "box.ch"

#xtranslate CENTER(<row>, <msg> [ , <color> ] ) => ;
            DevPos( <row>, int((maxcol() + 1 - len( <msg> )) / 2)) ; ;
            DevOut( <msg> [, <color>] )

#xcommand DEFAULT <param> TO <value> => ;
         <param> := IF(<param> == NIL, <value>, <param>)

#define TEST

#ifdef TEST
Function Test
   local screen := savescreen()
   local oTest1, oTest2, oTest3, oTest4

   @ 8, 8, 19, maxcol() - 8 BOX B_DOUBLE + " "color "GR+/B"
   center( 10, "Array Container Demonstration", "W+/B")
   @11, 9, 11, maxcol() - 9 BOX B_SINGLE color "GR+/B"
   @13,10 say "Permutations of 5 element array in progress . . . " color "W+/B"
   oTest1 := KJFSort( conArray():new():init( { 1, 2, 3, 4, 5 } ), 14)
   @13,10 say "Permutations of 5 element array results: " + str( factorial(5), 5 ) + " Elements." color "W+/B"
   @14,10 say "Permutations of 6 element array in progress . . . " color "W+/B"
   oTest2 := KJFSort( conArray():new():init( { 1, 2, 3, 4, 5, 6 } ), 15 )
   @14,10 say "Permutations of 6 element array results: " + str( factorial(6), 5 ) + " Elements." color "W+/B"
   @15,10 say "Permutations of 7 element array in progress . . . " color "W+/B"
   oTest3 := KJFSort( conArray():new():init( { 1, 2, 3, 4, 5, 6, 7 } ), 16 )
   @15,10 say "Permutations of 7 element array results: " + str( factorial(7), 5 ) + " Elements." color "W+/B"
   @16,10 say "Permutations of 8 element array in progress . . . " color "W+/B"
   oTest4 := KJFSort( conArray():new():init( { 1, 2, 3, 4, 5, 6, 7, 8 } ), 17 )
   @16,10 say "Permutations of 8 element array results: " + str( factorial(8), 5 ) + " Elements." color "W+/B"
   @17,10 say "Container Demo Complete!" color "W+/B"
   inkey(5)
   restscreen(,,,,screen)
return nil
#endif

Function KJFSort( oArray, nRow )
   local nLen     := oArray:nItems
   local nFactor  := Factorial( nLen ) 
   local nFactor1 := nFactor / nLen
   local oHolder  := conArray():new()
   local oTemp    := oArray:clone():truncate()
   local aTemp2, aTemp3, i

   default nRow to maxrow()

   oArray:goBottom()
   for i := 1 to nFactor
      oHolder:addIt( { oArray:current() } )
      if 0 == int( i % nFactor1 )
         oArray:decrement()
      endif
#ifdef TEST
      @ nRow,10 say "Sizing:" + str( i, 6,0) color "W+/B"
#endif
   next                                 

   // Recursion happens here
   oTemp := if( nLen > 2, KJFSort( oTemp, nRow ), oTemp:setContents( { oTemp:aItems }, 1 ))

   oHolder:goTop() 
   oTemp:goTop() 
   for i := 1 to nFactor
      aTemp3 := oHolder:current()[1]
      aTemp2 := SubIt( oTemp:current(), aTemp3, atail( oHolder:firstOne() ) )
      aadd( aTemp2, aTemp3 )
      oHolder:setItem( aclone( aTemp2 ) )
      oHolder:increment()
      if oTemp:atBottom()
         oTemp:goTop()
      else
         oTemp:increment()
      endif
#ifdef TEST
      @ nRow,40 say "Sorting:" + str( i, 6,0) color "W+/B"
#endif       
   next                                              
return oHolder 


/* Purpose: return N! from supplied N */
static function factorial( nNum )
   local nFactor := nNum
   while nNum > 1 
      nFactor := nFactor * -- nNum 
   enddo
return nFactor


/* Purpose: substitute a value in an array with another value */
static function subit( aArray, uFind, uReplace )
   local nPlace := ascan( aArray, uFind )
   local aWork := aclone( aArray )       
   if nPlace > 0 
      aWork[nPlace] := uReplace 
   endif
return aWork








