//.............................................................................
//   Program Name: ITARRAY.PRG       Copyright: ACE Inc. Software Development                            
//   Date Created: 03/03/93           Language: Clipper 5.0                                         
//   Time Created: 21:12:13             Author: Kevin J. Farley                           
//   Purpose: Array Iterator Class in Container Class Lib
//   Notes: This Class implements a 2 dim approach with each dim containing
//          up to _DIM_SIZE elements
//.............................................................................

#include "class(y).ch"

#define _DIM_SIZE  4000

create class iterArray inherit Iterator

   protected:

      message nItems to SENDER

   export:

      var aOffSet RO                             // Physical Offset

      method init                                // Initialize Iterator
      method increment                           // Move pointer forward
      method decrement                           // Move pointer backward
      method goTop                               // Move pointer to Top
      method goBot                               // Move pointer to Bottom
      method atTop                               // Is pointer at Top
      method atBottom                            // Is pointer at Bottom
      method seekFirst                           // Locate first match
      method seekNext                            // Locate next match
      method getOffSet                           // Return OffSet

endclass


method init()
   ::aOffSet := { 1, 0 }
return self


method increment( nNum )
   local i := 0
   if valtype( nNum ) # "N"
      nNum := 1
   endif
   while i++ < nNum
      if ::nItems > _DIM_SIZE * (::aOffSet[1] - 1) + ::aOffSet[2]
         if ::aOffSet[2] < _DIM_SIZE 
            ::aOffSet[2] ++
         else
            ::aOffSet[1] ++
            ::aOffSet[2] := 1
         endif
      endif
   enddo
return self


method decrement( nNum )
   local i := 0
   if valtype( nNum ) # "N"
      nNum := 1
   endif
   while i ++ < nNum
      if ::aOffSet[2] > 1 
         ::aOffSet[2] --
      elseif ::aOffSet[1] > 1
         ::aOffSet[1] --
         ::aOffSet[2] := _DIM_SIZE
      endif
   enddo
return self


method goTop
   ::aOffSet := { 1, 1 }
return self


method goBot
   ::aOffSet[1] := 1 + int( ::nItems / _DIM_SIZE  )
   ::aOffSet[2] := int( ::nItems % _DIM_SIZE )
return self


method atTop
return ::aOffSet[1] == 1 .and. ::aOffSet[2] == 1


method atBottom
return ::aOffSet[1] == 1 + int( ::nItems / _DIM_SIZE ) .and. ;
       ::aOffSet[2] == ::nItems % _DIM_SIZE 


method seekFirst( uKey )
   local i, j, uReturn
   for i := 1 to 1 + int( ::nItems / _DIM_SIZE )
      if 0 # ( j := ascan( ::aItems[i], uKey ) )
         ::aOffSet := { i, j }
         uReturn := ::aItems[ ::aItems[1], ::aItems[2] ]
         exit
      endif
   next               
return uReturn


method seekNext( uKey )
   local i, j, uReturn
   for i := ::aItems[1] to 1 + int( ::nItems / _DIM_SIZE )
      if 0 # ( j := ascan( ::aItems[i], uKey, ;
                           if( i == 1, ::aItems[2], 1 ) ) )
         ::aOffSet := { i, j }
         uReturn := ::aItems[ ::aItems[1], ::aItems[2] ]
         exit
      endif
   next               
return uReturn


method getOffSet()
return ::aOffSet


