//.............................................................................
//   Program Name: CONBASE.PRG       Copyright: ACE Inc. Software Development                            
//   Date Created: 03/01/93           Language: Clipper 5.0                                         
//   Time Created: 18:31:19             Author: Kevin J. Farley                           
//   Purpose: Base Class for Container Class Lib
//.............................................................................

#include "class(y).ch"

create class Container

   protected:

      var oIterator                              // Iterator Object

   export:

      var aItems   RO                            // Contents
      var nItems   RO                            // # of Items 

      message addIt        is deferred           // Add object
      message deleteIt     is deferred           // Delete object 
      message getItem      is deferred           // Get an object 
      message setItem      is deferred           // Replace an object 
      message setSize      is deferred           // Establish the size 
      message firstOne     is deferred           // Return first object 
      message current      is deferred           // Return current object
      message nextOne      is deferred           // Return next object
      message previous     is deferred           // Return previous object
      message lastOne      is deferred           // Return last object

      message increment    to oIterator          // Set pointer ahead 
      message decrement    to oIterator          // Set pointer behind
      message goTop        to oIterator          // Set pointer at top
      message goBot        to oIterator          // Set pointer at bottom
      message goBottom     is goBot to oIterator
      message atTop        to oIterator          // Is pointer at head
      message atBottom     to oIterator          // Is pointer at tail
      message seekFirst    to oIterator          // Set pointer to Key
      message seekNext     to oIterator

      method firstThat                           // Return first object
                                                 // that meets a condition

      method nextThat                            // Return next object 
                                                 // that meets a condition

      method lastThat                            // Return last object
                                                 // that meets a condition

      method forEach                             // Send a message or evaluate
                                                 // an expression for all 
                                                 // objects in container

      method forSome                             // Send a message or evaluate
                                                 // an expression for all 
                                                 // objects meeting condition

      method flush                               // Empty out the container
      method isEmpty                             // Is the container empty

endclass


method firstThat( uExpr )
   local lMessage := valtype( uExpr ) == "O"
   local uItem
   ::goTop()
   while !::atBottom()
      uItem := ::current() 
      if lMessage
         if uItem:perform( uExpr )
            return ( uItem )
         endif
      elseif uExpr:eval( uItem )
         return ( uItem )
      endif
      ::increment()
   enddo
return NIL


method nextThat( uExpr )
   local lMessage := valtype( uExpr ) == "O"
   local uItem
   while !::atBottom()
      uItem := ::current() 
      if lMessage
         if uItem:perform( uExpr )
            exit
         endif
      elseif uExpr:eval( uItem )
         exit
      endif
      ::increment()
      uItem := NIL
   enddo
return ( uItem )


method lastThat( uExpr )
   local lMessage := valtype( uExpr ) == "O"
   local uItem
   ::goBot()
   while !::atTop()
      uItem := ::current() 
      if lMessage
         if uItem:perform( uExpr )
            exit
         endif
      elseif uExpr:eval( uItem )
         exit
      endif
      ::decrement()
      uItem := NIL
   enddo
return ( uItem )


method forEach( uPerform, uParam )
   local lMessage := valtype( uPerform ) == "O"
   ::goTop()
   while !::atBottom()
      if lMessage
         ::current():perform( uPerform, uParam )
      else
         uPerform:eval( ::current(), uParam )
      endif
      ::increment()
   enddo
return self


method forSome( uExpr, uPerform, uParam )
   local lMessage := valtype( uPerform ) == "O"
   local uItem
   ::goTop()
   while !empty( uItem := ::nextThat( uExpr ) )
      if lMessage
         uItem:perform( uPerform, uParam )
      else
         uPerform:eval( uItem, uParam )
      endif
      ::increment()
   enddo
return self


method flush()                 
   ::goTop()
   while !::atBottom()
      ::delete()
   enddo
   ::init()
return self


method isEmpty()
return ::nItems == 0



