//.............................................................................
//   Program Name: CONARRAY.PRG      Copyright: ACE Inc. Software Development                            
//   Date Created: 03/03/93           Language: Clipper 5.0                                         
//   Time Created: 21:56:58             Author: Kevin J. Farley                           
//   Purpose: Array Container Class in Container Class Lib
//   Notes: This Class implements a 2 dim approach with each dim containing
//          up to _DIM_SIZE elements
//.............................................................................

#include "class(y).ch"

#define _DIM_SIZE  4000

create class conArray inherit Container

   protected:

      message getOffSet to oIterator            // Physical Offset

   export:

      method init                               // Initialize Container 
      method addIt                              // Add object
      method deleteIt                           // Delete object 
      method getItem                            // Get an object 
      method setItem                            // Replace an object 
      method setSize                            // Establish the size 
      method firstOne                           // Return first object 
      method current                            // Return current object
      method nextOne                            // Return next object
      method previous                           // Return previous object
      method lastOne                            // Return last object
      method truncate                           // Delete last element
      method clone                              // For Cloning the Container

      // Candidates for undocumented methods
      method setContents                        // reset contents (for cloning)

endclass

method init( aItems )
   local i, iLen
   ::aItems := { {} }
   ::nItems := 0
   ::oIterator := iterArray():new()
   if valtype( aItems ) == "A"
      iLen := len( aItems )
      for i := 1 to iLen
         ::addIt( aItems[i] )
      next                
   endif
return self


method addIt( uItem )              
   local i := if( ::nItems == 0, 1, 1 + int( ::nItems / _DIM_SIZE ) )
   if ::nItems == 0 .or. ::nItems % _DIM_SIZE > 0
      aadd( ::aItems[i], uItem )
   else
      aadd( ::aItems, { uItem } )
   endif
   ::nItems ++
   ::oIterator:increment()
return self


method deleteIt()       
   local i := ::getOffSet[1]
   local j := ::getOffSet[2]
   if ::nItems > 0
      adel( ::aItems[ i, j ] )
      if empty( ::aItems[i] ) .and. i > 1
         asize( ::aItems, i - 1 )
      elseif i > 0
         asize( ::aItems[i], j - 1 )
      endif
      ::oIterator:decrement()
      ::nItems --
   endif
return self


method getItem()
return ::aItems[::getOffSet[1], ::getOffSet[2]]


method setItem( uItem )
   ::aItems[::getOffSet[1], ::getOffSet[2]] := uItem
return self


method setSize( nSize )
   local i
   if valtype( nSize ) ==  "N"
      if nSize > ::nItems
         for i := ::nItems + 1 to nSize
            ::addIt()
         next
      elseif nSize < ::nItems
         ::goBottom()
         for i := ::nItems to nSize step - 1
            ::deleteIt()
         next
      endif
      ::nItems := nSize
      ::oIterator:goTop()
   endif
return self


method firstOne()
return ::aItems[1,1]


method current()
return ::aItems[ ::getOffSet[1], ::getOffSet[2] ] 


method nextOne()
   local uItem
   if !::oIterator:atBottom()
      ::oIterator:increment()
      uItem := ::current()
   endif
return uItem   


method previous()
   local uItem
   if !::oIterator:atTop()
      ::oIterator:decrement()
      uItem := ::current()
   endif
return uItem   


method lastOne()             
return if( ::nItems > 0, ::aItems[ 1 + int( ::nItems / _DIM_SIZE ) ][ ::nItems % _DIM_SIZE ], NIL )


method truncate()
   ::goBot()
   ::deleteIt()
return self
         

method clone()
   local oNew := conArray():new()
   oNew:setContents( aclone( ::aItems ), ::nItems )
return oNew


method setContents( aArray, nSize )
   ::aItems := aArray
   ::nItems := nSize
   ::goTop()
return self



