//----------------------------------------------------------------------------
//           Name: NPMemoEdit()
//        Purpose: Replacement to Clipper's MemoEdit()
//
//         Author: Wilson H. Yuen
//   Date created: 03-23-93
//   Time created: 09:33:31am
//      Copyright: Wilosn H. Yuen
//
//         Syntax: NPMemoEdit( cMemo,;
//                             nTop, nLeft, nBottom, nRight,;
//                             lEditMemo,   cUserFunction,;
//                             nLineLength, nTabSize,;
//                             nTxtBuffRow, nTxtBuffColumn,;
//                             nWindowRow,  nWindowColumn ) --> Buffer
//
//       Argument: cMemo          - text to edit
//                 nTop           - top window coordinate
//                 nLeft          - left window coordinate
//                 nBottom        - bottom window coordinate
//                 nRight         - right window coordinate
//                 lEditMemo      - TRUE - allow user to make changes
//                 cUserFunction  - user definded function
//                 nLineLength    - line length
//                 nTabSize       - tab size
//                 nTxtBuffRow    - cursor position within the text
//                 nTxtBuffColumn - cursor position within the text
//                 nWindowRow     - cursor position within the window
//                 nWindowColumn  - cursor position within the window
//
//   Return Value: Edit buffer
//
//    Description: This version of MemoEdit() can easily be intergrated
//                 into your current application with little or no changes.
//                 All parameter except cMemo is optional.  The parameters
//                 cUserFunction, nTxtBuffRow, TxtBuffColumn, nWindowRow,
//                 and nWindowColumn is curretly not being used.
//
//        Example: cText := space(10)
//                 NPMemoEdit(cText)
//
//----------------------------------------------------------------------------
#include "FUNCky.ch"
#include "Inkey.ch"
#include "Note.ch"
#define pMEMO_BUFFER          4000  //-- 1 to 65000, 2000=1 full page

//-- Used by settitle()
#define pTOP_CENTER              1
#define pTOP_LEFT                2
#define pTOP_LEFT_BOTTOM_LEFT    0
#define pBOTTOM_CENTER          -1
#define pBOTTOM_LEFT            -2

FUNCTION NPMemoEdit( cMemo,;
                   nTop , nLeft, nBottom, nRight,;
                   lEditMemo   , cUserFunction  ,;
                   nLineLength , nTabSize       ,;
                   nTxtBuffRow , nTxtBuffColumn ,;
                   nWindowRow  , nWindowColumn  )

    local oNotePad                            //-- notepad object
    local cRetVal                             //-- return value                                       //-- the memo text
    local nMaxRow       := MaxRow()           //-- maximnu row
    local nMaxCol       := MaxCol()           //-- maximum column


    //-- Default settings
    cMemo         := If( cMemo       == NIL , ""             , cMemo       )
    nTop          := If( nTop        == NIL , 0              , nTop        )
    nLeft         := If( nLeft       == NIL , 0              , nLeft       )
    nBottom       := If( nBottom     == NIL , nMaxRow        , nBottom     )
    nRight        := If( nRight      == NIL , nMaxCol        , nRight      )
    lEditMemo     := If( lEditMemo   == NIL , .T.            , lEditMemo   )
    nLineLength   := If( nLineLength == NIL , nRight - nLeft , nLineLength )
    nTabSize      := If( nTabSize    == NIL , 4              , nTabSize    )
    OK2Edit(lEditMemo)


    //-------------------------------------------------------------
    //  Strip soft carriage return/line feeds in character strings
    //-------------------------------------------------------------
    cMemo := chrswap(chrswap( cMemo,"",""), chr(10), "")

    //-------------------------------------------------------------
    //  Create a NotePad object.
    //-------------------------------------------------------------
    oNotePad := NotePadNew( nTop, nLeft, nBottom, nRight, pSTD, pMEMO_BUFFER, nLineLength, DEFAULT, nTabSize )

    If oNotePad == NIL
       ErrMsg("Insufficient amount of contiguous block of memory to edit memo")
    Else


        //----------------------------------------------------
        // display hard carriage return character as chr(32)
        // display end of buffer character as chr(32)
        //----------------------------------------------------
        oNotePad:EofChar:= 32
        oNotePad:EolChar:= 32

        cls(23, chr(177))                                               //-- clear screen
        settitle( "<< Demo of my MemoEdit() >>", pTOP_CENTER, pHOT3 )   //-- set a title to be used by the box() function
        box( nTop-1, nLeft-2, nBottom+1, nRight+2, "", pHOT1 )          //-- draw box
        oNotePad:Store( NP_VERBATIM, cMemo )                            //-- store text into a NotePad object for editing
        oNotePad:Cargo := cUserFunction                                 //-- special functions

        If NPInterFace()
           NPEdit(oNotePad)                                             //-- edit it, NotePad interface
        else
           WP5Edit(oNotePad)                                            //-- edit it, WordPerfect interface
        Endif

    Endif                                                               // oNotePad == NIL


return( oNotePad:buffer )
* eof NPMemoEdit()
*
*
