/*
    Demo program for dbReport

      by: Raymond J. Kuyvenhoven
    date: 14 May 1993
*/

#include "Box.ch"

*
*--------------------------------------------------
FUNCTION Demo ()
*--------------------------------------------------
*
LOCAL nChoice
LOCAL cOutputFile
LOCAL lDone := .f.
LOCAL cColor
LOCAL cMsg

CLS
cColor := SETCOLOR ("W+/RB")
cMsg := dbReportVersion ()
@ 2, Center (cMsg) SAY cMsg COLOR ("W+/N")
cMsg := "Demo Program"
@ 3, Center (cMsg) SAY cMsg COLOR ("W+/N")
SETCOLOR ("W+/N")
@ 07, 0 CLEAR
WHILE !lDone
  SETCOLOR ("W+/RB")
  SET MESSAGE TO 23 CENTER
  @ 08, 35 , 15, 46 BOX B_DOUBLE_SINGLE + SPACE(1) COLOR ("GR+/RB")
  @ 09, 36 PROMPT " Report 1 " MESSAGE {||HelpMsg ("List of people by lastname")}
  @ 10, 36 PROMPT " Report 2 " MESSAGE {||HelpMsg ("Employee salaries by company & lastname")}
  @ 11, 36 PROMPT " Report 3 " MESSAGE {||HelpMsg ("Invoices")}
  @ 12, 36 PROMPT " Report 4 " MESSAGE {||HelpMsg ("List of people grouped by country, province/state")}
  @ 13, 36 PROMPT " Report 5 " MESSAGE {||HelpMsg ("Report 3 to file: dbReport.DAT")}
  @ 14, 36 PROMPT " Quit     " MESSAGE {||HelpMsg ("Quit " + dbReportVersion ())}
  MENU TO nChoice
  //
  DO CASE
    CASE nChoice == 1
       cOutputFile := NIL  // "Test1.OUT"
       Report ("Person", "Person1", "Test1.FMT", cOutputFile)
    CASE nChoice == 2
       cOutputFile := NIL  // "Test2.OUT"
       Report ("Person", "Person2", "Test2.FMT", cOutputFile)
    CASE nChoice == 3
       cOutputFile := NIL  // "Test3.OUT"
       InvReport (cOutputFile)
    CASE nChoice == 4
       cOutputFile := NIL  // "Test4.OUT"
       Report ("Person", "Person4", "Test4.FMT", cOutputFile)
    CASE nChoice == 5
       cOutputFile := "dbReport.DAT"
       Report ("Person", "Person4", "Test4.FMT", cOutputFile)
    CASE (nChoice == 6) .OR. (nChoice == 0)
       lDone := .t.
  ENDCASE
END
FinalMessage ()
SETCOLOR (cColor)
@ MAXROW()-1, 0 SAY ""
RETURN NIL

*
*--------------------------------------------------
STATIC FUNCTION InvReport (cOutputFile)
*--------------------------------------------------
*
LOCAL aDataDict

aDataDict := InvoiceDD ()
dbUSEAREA (,,"Invoice")
SELECT ("Invoice")
dbSETINDEX ("Invoice")
dbUSEAREA (.t.,,"Person")
dbSETINDEX ("Person3")
dbReport ("Test3.FMT", { |lFirstCall| GetInvoice (lFirstCall)}, aDataDict, cOutputFile)
dbCLOSEALL ()
RETURN NIL

*
*--------------------------------------------------
STATIC FUNCTION Report (cDbfFile, cIndexFile, cFormatFile, cOutputFile)
*--------------------------------------------------
*
LOCAL aDataDict

aDataDict := CreateDataDictionary ()
dbUSEAREA (,,cDbfFile)
dbSETINDEX (cIndexFile)
dbReport (cFormatFile, { |lFirstCall| GetRecord (lFirstCall)}, aDataDict, cOutputFile)
dbCLOSEAREA ()
RETURN NIL

*
*--------------------------------------------------
STATIC FUNCTION GetRecord (lFirstCall)
*--------------------------------------------------
*
LOCAL aRecord

SELECT ("PERSON")
IF lFirstCall
  dbGOTOP ()
  IF !EOF ()
    aRecord := LoadArray ()
  ELSE
    aRecord := NIL
  END
ELSE
  dbSKIP ()
  IF !EOF ()
    aRecord := LoadArray ()
  ELSE
    aRecord := NIL
  END
END
RETURN aRecord


*
*--------------------------------------------------
STATIC FUNCTION LoadArray ()
*--------------------------------------------------
*
LOCAL nIdx
LOCAL aBuffer := {}
LOCAL cTemp

FOR nIdx := 1 TO FCOUNT()
  AADD (aBuffer, FIELDGET(nIdx))
NEXT
cTemp := ALLTRIM (FIELDGET(2)) + ", " + ALLTRIM (FIELDGET (1))
AADD (aBuffer, cTemp)
RETURN aBuffer

*
*--------------------------------------------------
STATIC FUNCTION CreateDataDictionary ()
*--------------------------------------------------
*
LOCAL aArray := {}

AADD (aArray, "FirstName")
AADD (aArray, "LastName")
AADD (aArray, "Street")
AADD (aArray, "City")
AADD (aArray, "Province")
AADD (aArray, "Country")
AADD (aArray, "PostalCode")
AADD (aArray, "Company")
AADD (aArray, "HiredDate")
AADD (aArray, "Married")
AADD (aArray, "Age")
AADD (aArray, "Salary")
AADD (aArray, "PersonNum")
AADD (aArray, "Combined")
RETURN aArray

*
*--------------------------------------------------
STATIC FUNCTION GetInvoice (lFirstCall)
*--------------------------------------------------
*
LOCAL aRecord

SELECT ("Invoice")
IF lFirstCall
  dbGOTOP ()
  IF !EOF ()
    SELECT ("Person")
    dbSEEK (Invoice->PersonNum, .f.)
    aRecord := LoadInvoice ()
  ELSE
    aRecord := NIL
  END
ELSE
  dbSKIP ()
  IF !EOF ()
    SELECT ("Person")
    dbSEEK (Invoice->PersonNum, .f.)
    aRecord := LoadInvoice ()
  ELSE
    aRecord := NIL
  END
END
RETURN aRecord


*
*--------------------------------------------------
STATIC FUNCTION LoadInvoice ()
*--------------------------------------------------
*
LOCAL nIdx
LOCAL aBuffer := {}
LOCAL cTemp

cTemp := ALLTRIM (Person->Last) + ", " + ALLTRIM (Person->First)

AADD (aBuffer, cTemp)
AADD (aBuffer, Person->Street)
AADD (aBuffer, Person->City)
AADD (aBuffer, Person->State)
AADD (aBuffer, Person->Country)
AADD (aBuffer, Person->Zip)
AADD (aBuffer, Invoice->Descript)
AADD (aBuffer, Invoice->Quantity)
AADD (aBuffer, Invoice->Price)
RETURN aBuffer


*
*--------------------------------------------------
STATIC FUNCTION InvoiceDD ()
*--------------------------------------------------
*
LOCAL aArray := {}

AADD (aArray, "Name")
AADD (aArray, "Street")
AADD (aArray, "City")
AADD (aArray, "Province")
AADD (aArray, "Country")
AADD (aArray, "PostalCode")
AADD (aArray, "Description")
AADD (aArray, "Quantity")
AADD (aArray, "Price")
RETURN aArray

*
*--------------------------------------------------
STATIC FUNCTION HelpMsg (cMsg)
*--------------------------------------------------
*
LOCAL cSaveClr
LOCAL nRow

nRow := MAXROW() - 1
cSaveClr := SETCOLOR ("N/BG")
@ nRow, 0 CLEAR TO nRow, MAXCOL()
@ nRow, Center (cMsg) SAY cMsg
SETCOLOR (cSaveClr)
RETURN ""

*
*--------------------------------------------------
STATIC FUNCTION Center (cMsg)
*--------------------------------------------------
*
LOCAL nLineLength
nLineLength := MAXCOL()+1
RETURN ((nLineLength -  LEN(cMsg)) / 2 )

*
*--------------------------------------------------
STATIC FUNCTION FinalMessage ()
*--------------------------------------------------
*
LOCAL cMessage

SETCOLOR ("W+/N")
CLS
cMessage := dbReportVersion ()
@ 02, Center (cMessage) SAY cMessage COLOR "RB+/N"
cMessage := "Copyright (c) 1993" 
@ ROW()+2, Center (cMessage) SAY cMessage COLOR "W/N"
cMessage := "Raymond J. Kuyvenhoven"
@ ROW()+1, Center (cMessage) SAY cMessage
cMessage := "MAILING ADDRESS"
@ ROW()+3, Center (cMessage) SAY cMessage COLOR "GR+/N"
cMessage := "-----------------"
@ ROW()+1, Center (cMessage) SAY cMessage COLOR "GR+/N"
cMessage := "131 Britten Close" 
@ ROW()+1, Center (cMessage) SAY cMessage COLOR "BG+/N"
cMessage := "Hamilton, Ontario"
@ ROW()+1, Center (cMessage) SAY cMessage COLOR "BG+/N"
cMessage := "L9C 4K1"
@ ROW()+1, Center (cMessage) SAY cMessage COLOR "BG+/N"
cMessage := "EMAIL"
@ ROW()+3, Center (cMessage) SAY cMessage COLOR "GR+/N"
cMessage := "-------"
@ ROW()+1, Center (cMessage) SAY cMessage COLOR "GR+/N"
cMessage := "Internet: rn.3333@rose.com"
@ ROW()+1, Center (cMessage) SAY cMessage COLOR "G+/N"
cMessage := "RoseNet: Ray Kuyvenhoven@CRS"
@ ROW()+1, Center (cMessage) SAY cMessage COLOR "G+/N"
cMessage := "$35.00 for registered version"
@ ROW()+3, Center (cMessage) SAY cMessage COLOR "R+/N"
RETURN NIL


//  If you are using Clipper 5.01a uncomment the following procedure
//  to eliminate the link warning you will recieve when linking with
//  Clipper 5.2 compiled code.

/*
//
//--------------------------------------------------------------
   PROCEDURE Clipper520 ()
//--------------------------------------------------------------
//
RETURN
*/
