/*********************************************************************

	EX4.PRG - CUA-Clip Library examples.

	This file contains sample code illustrating a basic STDBrowse.

	For a more elaborate example of STDBrowse, and an example of
	using STDBrowse with arrays, see the functions _BrowseFile()
	and GetFile() in Misc.PRG.

	Author: Dave Rooney
	Date  : Feb. 22, 1993

*********************************************************************/

#include "Demo.CH"

//
// Example 4 - Basic STDBrowse.
//

FUNCTION Browse_Examples

LOCAL aFields,    ; // Fields array for the browse
		cColor,     ; // Colour string for the browse
		cTitle,     ; // Title text
		i             // Loop counter

//
// Ensure Printer.DBF/.NTX are there.  If not, make 'em!
//
IF !( FILE( "Printer.DBF" ) .AND. FILE( "Printer.NTX" ))
	_BuildPrinter()
ENDIF

//
// Open the printer file.
//
IF DBNetUse( .T., "DBFNTX", "Printer" )
	DBSETINDEX( "Printer" )
ELSE
	RETURN NIL
ENDIF

//
// Load the fields array from Printer...
//
aFields := ARRAY( FCOUNT(), 2 )

FOR i := 1 TO FCOUNT()
	aFields[ i, 1 ] := FIELDNAME( i )
	aFields[ i, 2 ] := FIELDBLOCK( FIELDNAME( i ))
NEXT

cColor := "B/BG,GR+/BG,W+/BG,W+/R"
cTitle := " Printer Lookup File "

Message( "Press <ESC> to return..." )

//
// Simple as that!
//
STDBrowse( 5, 3, MAXROW() - 5, MAXCOL() - 3, aFields, cTitle,, cColor, .F. )

//
// Close the printer file...
//
DBNetClose( "Printer" )

Message("")

RETURN NIL
//
// That's all folks!
//
