/*****************************************************************************
  CA-Clipper Decode - File Decoder, ala uudecode.exe
  By Kirby L. Wallace, Wallace Information Systems Engineering

   FUNCTION: CAEncode(cFileIn, cFileOut)

 PARAMETERS: cInFile : (from command line) Name of DOS File to
                       decode.

DESCRIPTION: CAEncode() creates an encoded file for decoding by CADecode()
             It is used primarily to transport files of any type across
             networks that may not necessarily support High/Low order
             ASCII characters.

             CAEncode() encodes the file to ensure that all characters in
             the original file are mapped into the "printable" character
             set.

             See .DOC file for details

******************************************************************************/

#include "fileio.ch"
#define  MAXCHARS 1024
#define  LF       CHR(13)+CHR(10)
#define  TRUE     .T.
#define  FALSE    .F.

FUNCTION CAEncode(cFileIn, cFileOut)
LOCAL    nIHandle, nOHandle
LOCAL    i, j, k
LOCAL    cBytesIn   := space(3)
LOCAL    nBytes
LOCAL    cBits      := ''
LOCAL    cBytesOut  := ''
LOCAL    lHelp  := FALSE

? 'CAEncode() - File Encoder - Kirby L. Wallace - March 1993'
? 'Version 2.0'
?
? 'Void where prohibited by law - Batteries not included - Freeware! - Yow!'
?
? cFileIn, '-->', cFileOut
?

BEGIN SEQUENCE

if cFileIn = NIL .or. cFileOut = NIL
    lHelp = TRUE
else

    if cFileIn $ '?' .or. cFileIn = '/h'
        lHelp = TRUE
    endif

endif

if lHelp

    ?
    ? 'Usage: CAENCODE InputFile.ext OutputFile.ext'
    ?
    ? 'Where InputFile.ext = Name of file to be encoded and '
    ? '      OutPutFile.ext = name of encoded file to create'
    ?

    BREAK

endif

*--------------------------------------------------------------------------

i := j := k := 0

if file(cFileIn)

    if ( nIHandle := fopen(cFileIn) ) != -1

        // input file is open

        if ( nOHandle := fcreate(cFileOut) ) != -1
            // output file is created
            fwrite(nOHandle,'+++CAFile: '+cFileIn+LF+'+++CABegin+++'+LF)
        else

            ? LF+'Output File Create Error'+LF

            BREAK

        endif

        while TRUE

            /////////////////////////////////////////////////
            // change j to change the right hand margin.   //
            // each increment or decrement changes the     //
            // margin by +/-4 columns. 17 = 68 cols        //
            /////////////////////////////////////////////////

            ?? '.' // an incredibly cutting-edge-of-technology, high-tech progress indicator

            for j = 1 to 17

                cBytesOut := cBits := ''
                cBytesIn = space(3)

                if ( nBytes := fread(nIHandle,@cBytesIn,3) ) = 3

                    // convert three input bytes to a bitmap
                    cBits = Make_cBits(cBytesIn)        

                    // convert bitmap to four bytes
                    cBytesOut = Make_cBytesOut(cBits)   

                    // write four bytes to disk
                    fwrite(nOHandle,cBytesOut)          

                else


                    // end of file

                    // how many bytes left over?

                    // write remaining bytes - decoder will look for either
                    // 2 or three odd digits after  % 4 and decode same way

                    if nBytes  = 1

                        cBits = '0000'+_int2b(asc(substr(cBytesIn,1,1)))

                        cBytesOut = chr(48+_b2int(substr(cBits,1,6)))+ ;
                                    chr(48+_b2int(substr(cBits,7,6)))

                        fwrite(nOHandle,cBytesOut)

                    else

                        if nBytes = 2

                            cBits = '00'+_int2b(asc(substr(cBytesIn,1,1)))+;
                                         _int2b(asc(substr(cBytesIn,2,1)))

                            cBytesOut = chr(48+_b2int(substr(cBits,1,6)))+ ;
                                        chr(48+_b2int(substr(cBits,7,6)))+ ;
                                        chr(48+_b2int(substr(cBits,13,6)))

                            altd()

                            fwrite(nOHandle,cBytesOut)

                        endif

                    endif

                    fwrite(nOHandle,LF+'+++CAEnd+++')

                    BREAK

                endif

            next

            fwrite(nOHandle,LF)

        end

    else
        ? LF+'Input File Open Error'+LF

    endif

else

    ? LF+'Input File not Found'+LF

endif

END SEQUENCE

fclose(nIHandle); fclose(nOHandle)


RETURN(NIL)

*************************************************************************

FUNCTION Make_cBits(cBytesIn)

LOCAL cBits := ''
LOCAL i

// this method is slightly faster than a for loop with
// a var counter for 1,2,3

cBits += _int2b(asc(substr(cBytesIn,1,1)))
cBits += _int2b(asc(substr(cBytesIn,2,1)))
cBits += _int2b(asc(substr(cBytesIn,3,1)))


RETURN(cBits)

*************************************************************************

