/**************************************************************************
  CA-Clipper Encode - File Encoder, ala uuencode.exe
  By Kirby L. Wallace, Wallace Information Systems Engineering

   FUNCTION: CADecode(cFileName)

 PARAMETERS: cFileName : (from command line) Name of DOS File to
                         convert to encoded file.

DESCRIPTION: CADecode() decodes a file created by CAEncode(), restoring
             it to it's original state.

             Note that it is not necessary to specify the output
             file name.  It is stored in the encoded file.

             See .DOC file for details


***************************************************************************/

#include "fileio.ch"

#define  MAXCHARS 1024
#define  LF       CHR(13)+CHR(10)
#define  TRUE     .T.
#define  FALSE    .F.

/*************************************************************************/
FUNCTION CADecode(cInFile)
LOCAL    cOutFile  := ''
LOCAL    i, j, k
LOCAL    cBytesIn  := space(8)
LOCAL    cBytesOut := ''
LOCAL    cThisLine
LOCAL    nIHandle, nOHandle
LOCAL    cBits
LOCAL    lHelp := FALSE

? 'CADecode() - File Decoder - Kirby L. Wallace - March 1993'
? 'Version 2.0'
?
? 'Take only as directed - Beware of dogs! - Freeware! - Yow!'
?
? cInFile


BEGIN SEQUENCE


if cInFile = NIL
    lHelp = TRUE
else

    if cInFile $ '?' .or. cInFile = '/h'
        lHelp = TRUE
    endif

endif

if lHelp

    ?
    ? 'Usage: CADECODE filename.ext'
    ?
    ? 'Where filename.ext = name of file created by CAENCODE.EXE'
    ?

    BREAK

endif


if file(cInFile)

    if ( nIHandle := fopen(cInFile) ) != -1

        cThisLine = ReadLine(nIHandle)

        if substr(cThisLine,1,10) != '+++CAFile:'
            ? LF+'Input File not a valid CAEncode File'+LF
            BREAK
        else
            cOutFile = substr(trim(cThisLine), 12)

            if ( nOHandle := fcreate(cOutFile) ) = -1
                ? LF+'Output File Create Error'+LF
                BREAK
            else
                // if there are no error messages, this will append to the
                // first line with the input file name (infile --> outfile)
                ?? ' -->', cOutFile
            endif

        endif

        while TRUE

            cThisLine = ReadLine(nIHandle)

            if substr(cThisLine,1,13) = '+++CABegin+++'
                exit
            endif

        end

        while TRUE

            cThisLine = ReadLine(nIHandle)

            if substr(cThisLine,1,11) = '+++CAEnd+++'

                fclose(nIHandle, nOHandle)

                EXIT

            endif

            ?? '.' // an incredibly cutting-edge-of-technology, high-tech progress indicator

            for i = 1 to len(cThisLine) STEP 4

                cBytesOut = ''
                cBytesIn = substr(cThisLine,i,4)
                cBits = ''

                if len(cBytesIn) != 4

                    if len(cBytesIn) = 2

                        // convert two byte value remainder

                        cbits = _int2b(asc(substr(cBytesIn,1,1))-48,2) + ;
                                _int2b(asc(substr(cBytesIn,2,1))-48,6)

                        cBytesOut = chr(_b2int(cBits))

                        fwrite(nOHandle,cBytesOut)

                        EXIT

                    else

                        // convert three byte remainder

                        if len(cBytesIn) = 3

                            cBits = _int2b(asc(substr(cBytesIn,1,1))-48,6)+;
                                    _int2b(asc(substr(cBytesIn,2,1))-48,6)+;
                                    _int2b(asc(substr(cBytesIn,3,1))-48,6)

                            cBits = substr(cBits,3)

                            cBytesOut = chr(_b2int(substr(cBits,1,8)))+;
                                        chr(_b2int(substr(cBits,9,8)))

                            fwrite(nOHandle,cBytesOut)

                            EXIT

                        endif

                    endif
                else

                    for j = 1 to len(cBytesIn)
                        cBits += _int2b(asc(substr(cBytesIn,j,1))-48,6)
                    next

                    for j = 1 to len(cBits) STEP 8
                        cBytesOut += chr(_b2int(substr(cBits,j,8)))
                    next

                    fwrite(nOHandle,cBytesOut)

                endif

            next

        end
    else
        ? LF+'Input File Open Error'+LF
        BREAK
    endif
else

    ? LF+'Input File Not Found'+LF

endif

END SEQUENCE


RETURN(NIL)


/*************************************************************************/
FUNCTION ReadLine(nHandle,nLength)
LOCAL    cRet_Val := ''
LOCAL    cCharBuffer
LOCAL    nPointer
LOCAL    nChars_Read
LOCAL    nLineFeedAt

cCharBuffer = space(iif(nLength = NIL,MAXCHARS,nLength))
nLength     = iif(nLength = NIL,MAXCHARS,nLength)

BEGIN SEQUENCE

    // note current position
    nPointer = fseek(nHandle,0,FS_RELATIVE)

    (nChars_Read := fread(nHandle,@cCharBuffer,nLength))

    if ( nLineFeedAt := at(LF,cCharBuffer) ) > 0

        // got a line with Line Feed, ELSE return all of what we read

        cRet_Val = substr(cCharBuffer,1,nLineFeedAt-1)

        // reset pointer to next line
        fseek(nHandle,nPointer,FS_SET)
        fseek(nHandle,nPointer+nLineFeedAt+1,FS_SET) // 2 = crlf pair

    else

        cRet_Val = substr(cCharBuffer,1,nLength)

    endif

END SEQUENCE

RETURN(trim(cRet_Val))

