//.............................................................................
//
//   Program Name: ATEDIT.PRG        Copyright: Asta Engineering, Inc.
//   Date Created: 04/30/92           Language: Clipper 5.0
//   Time Created: 12:16:39             Author: John C. Burkhard
//
//.............................................................................
// Revision: 1.01 Last Revised: 05/21/93 at 15:07:26
// Description: Stand-alone version
//
// Removed all references to the window library to make it a stand-alone
// UDC.
//.............................................................................

//
// Known anomalies:
//
// Checking LastKey() will return innacurate results.  To exit from
// MemoEdit() we must stuff a K_CTRL_END into the keyboard, since MemoEdit()
// seems to ignore any return values during idle states.  For this reason,
// if you use the @..EDIT command in your program, don't count on LastKey()
// accurately reporting the last key press!
//
// At some point in the future, CA will have to address this behavior or
// someone will have to release a replacement MemoEdit() which is more like
// TBrowse().  MemoEdit() is a hold over from the 'bad' old days and should
// have been disposed of a long time ago.
//
// Better yet would be a get system which uses something a little more 
// sophisticated than LastKey() and Updated() to return the exit state.
//


#include "inkey.ch"
#include "getexit.ch"
#include "memoedit.ch"

#define TAB_SIZE 5

#define ExitState( x ) sExitState := x ;
   ; keyboard chr( K_CTRL_END ) ;
   ; lSoftExit := .T.


static sExitState := nil                         // for passing the exit state back to our get object
static sMaxLines := 0                            // for telling our memoedit() UDF how many lines in window
static sScrollable := .T.                        // for telling our memoedit() UDF if window is scrollable


/*
** __editdisp( ) - display the contents of the edit window for an @...edit
*/

function __editdisp( cBuf, nTop, nLeft, nBottom, nRight, lScrollable, cColor )
   local nWidth
   local nLines
   local nI
   local cOldCol
   local cLine
   local GetList := { }

   nWidth := nRight - nLeft + 1
   nLines := nBottom - nTop + 1
   if ( empty( cColor ) )
      for nI := 1 to nLines
         cLine := memoline( cBuf, nWidth, nI, TAB_SIZE, .T. )
         @ nTop + nI - 1, nLeft get cLine
      next
   else
      for nI := 1 to nLines
         cLine := memoline( cBuf, nWidth, nI, TAB_SIZE, .T. )
         @ nTop + nI - 1, nLeft get cLine color cColor
      next
   endif

return nil



/*
** __editread( ) - reader function for @...edit command
*/

function __editread( oGet, nTop, nLeft, nBottom, nRight, lScrollable )
   local nWidth
   local nLines
   local nCurLin
   local cOldCol
   local cBuffer

   if ( oGet:preblock != nil .and. !eval( oGet:preblock ) )
      oGet:exitstate := GE_WHEN
   else
      sScrollable := iif( lScrollable == nil, .T., lScrollable )
      cOldCol := SetColor( oGet:colorSpec )
      nWidth := nRight - nLeft + 1
      nLines := nBottom - nTop + 1
      sMaxLines := nLines
      cbuffer := eval( oGet:block )
      cBuffer := memoedit( cBuffer, nTop, nLeft, nBottom, nRight, ;
         .T.,;                                   // edit mode
         "__editmemo",;                          // reader function
         nWidth, ;
         TAB_SIZE, ;
         0, 0, 0, 0 )
      if ( sExitState != GE_ESCAPE )
         if ( sExitState == GE_DOWN .or. ( sExitState == GE_WRITE .and. !lScrollable ) )
            __editdisp( cBuffer, nTop, nLeft, nBottom, nRight )
         endif
         eval( oGet:block, cBuffer )
      endif

      oGet:exitstate := sExitState
      setcolor( cOldCol )
   endif

return nil



/*
** __editmemo( ) - memoedit() user function
*/

function __editmemo( nMode, nLine, nColumn )
   local nRetVal
   local nKey
   static nLastLine
   static lSoftExit

   nKey := LastKey()

   do case
      case !sScrollable
         do case
            case nMode == ME_INIT
               nLastLine := 1
               lSoftExit := .F.
               nRetVal := 0
               keyboard chr(0)
            case nMode == ME_UNKEY .or. nMode == ME_UNKEYX
               nRetVal := ME_DEFAULT
               do case
                  case nKey == K_ESC
                     sExitState := GE_ESCAPE
                     nRetVal := K_ESC
                  case nKey == K_CTRL_END .and. !lSoftExit
                     sExitState := GE_WRITE
                     nRetVal := K_CTRL_END
                  case nKey == K_CTRL_END .and. lSoftExit
                     nRetVal := K_CTRL_END
               endcase

            case nMode == ME_IDLE

               //
               // ExitState() stuffs the keyboard with a K_CTRL_END
               // to force MemoEdit() to exit.  Values returned from
               // idle states seem to be ignored by MemoEdit().  For
               // this reason, if you use the @..EDIT command in your
               // program, you can't rely on LastKey() to accurately
               // report the last key pressed!
               //

               do case
                  case nKey == K_PGDN
                     ExitState( GE_WRITE )

                  case nKey == K_PGUP
                     ExitState( GE_WRITE )

                  case nKey == K_DOWN .and. nLastLine >= sMaxLines
                     ExitState( GE_DOWN )

                  case nKey == K_UP .and. nLastLine == 1
                     ExitState( GE_UP )

                  case nKey == K_ENTER .and. nLastLine >= sMaxLines
                     ExitState( GE_DOWN )

                  case nLine > sMaxLines
                     ExitState( GE_DOWN )

                  case nKey == K_CTRL_END
                     ExitState( GE_WRITE )
               endcase

               nLastLine := nLine

         endcase

      case sScrollable
         do case
            case nMode == ME_INIT
               nLastLine := 1
               lSoftExit := .F.
               nRetVal := 0
               keyboard chr(0)

            case nMode == ME_UNKEY .or. nMode == ME_UNKEYX
               nRetVal := ME_DEFAULT
               do case
                  case nKey == K_ESC
                     sExitState := GE_ESCAPE
                     nRetVal := K_ESC
                  case nKey == K_CTRL_END .and. lSoftExit
                     sExitState := GE_WRITE
                     nRetVal := K_CTRL_END
                  case nKey == K_CTRL_W
                     sExitState := GE_WRITE
                     nRetVal := K_CTRL_END
                  case nKey == K_CTRL_Q
                     sExitState := GE_ESCAPE
                     nRetVal := K_ESC
               endcase

            case nMode == ME_IDLE
               // do nothing...

         endcase
   endcase

return nRetVal
