PROGRAM ExtractDescs;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/07/14.  First public release.  DDA
v1.01  : 1993/07/19.  Fixed EOF (End of File) bug for multi-line descs.  DDA
v1.02  : 1993/09/16.  Fixed EOF (End of File) bug for multi-line descs.  DDA
                            (Another one, more elusive this time.)

------------------------------------------------------------------------------}

USES Dos;
VAR
   TextToScanFor,
   FilesToScan,
   FileSeeking     : String;

procedure showhelp ( errornum : byte );
const
     progdata = 'XDESC- Free DOS utility: PCBoard filelist multi-line description extractor.';
     progdat2 = 'V1.02: September 16, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';

     usage = 'Usage: XDESC [/v] <filename.ext to scan for> [file(s) to scan]';
var
    message : string [80];
begin
    writeln ;
    writeln ( progdata );
    writeln ( progdat2 );
    writeln ;
    writeln ( usage );
    writeln ;

    case errornum of
      1 : message := 'insufficient parameters.';
      2 : message := 'the /q parameter is no longer needed.  See XDESC.DOC for details.';
    end;
    writeln ( 'ERROR: (#',errornum,') - ', message );
    halt ( errornum );
end;

FUNCTION ConvertToUpper(w : String) : String;
VAR
   cp  : Integer;        {The position of the character to change.}
BEGIN
     FOR cp := 1 TO Length(w) DO
         w[cp] := UpCase(w[cp]);
     ConvertToUpper := w;
END;

PROCEDURE GetCmdLnParms(VAR Verb : Boolean; VAR ScanText, Files : String);
BEGIN
     IF (ParamStr(1) = '/q') THEN
        showhelp (2);
     IF (ParamStr(1) = '/v') THEN BEGIN
        Verb := True;
        ScanText := ParamStr(2);
        Files := ParamStr(3);
     END
     ELSE BEGIN
        Verb := False;
        ScanText := ParamStr(1);
        Files := ParamStr(2);
     END;

     IF (ScanText = '') THEN      {Quit with help if no arguments.}
         showhelp (1);

     IF (Files = '') THEN        {  If Files is undefined, }
         Files := '*.*';         {     scan all files.     }
END;

FUNCTION IsFile ( filespec : string ) : boolean;
VAR   IFDirInfo : SearchRec;
BEGIN
     FindFirst(filespec, Archive, IFDirInfo);
     IsFile := (DosError = 0);
END;

PROCEDURE ScanAFile (VAR found, vbose : boolean; seeking, newname : string );
VAR
     testline        : String ;
     scanfile        : text ;
     done            : boolean ;
BEGIN
     seeking := copy(seeking,1,12);
     Assign(scanfile,newname);
     Reset(scanfile);

     WHILE ((NOT Eof(scanfile)) AND (NOT found)) DO
     BEGIN
           ReadLn(scanfile,testline);

           IF (Pos(seeking,testline) = 1) THEN
           BEGIN
             found := True ;
             IF vbose THEN
                WriteLn ('Found in file: ',newname);
             WriteLn (testline);
             done := false ;
             WHILE (
                   ( NOT ( Eof ( scanfile ))) AND
                   ( NOT done )
                   )
                DO BEGIN
                   ReadLn  (scanfile,testline);
                   IF ( testline[1] = ' ' ) THEN
                      WriteLn (testline)
                   ELSE
                      done := true ;
                END;
           END;
     END;
     Close(scanfile);
END;

PROCEDURE ScanTheFiles (VAR chatty : boolean;
                        VAR textseeking, textfiles : string;
                            listf : boolean );
VAR  DirInfo : SearchRec;
     found   : boolean;
BEGIN
     TextToScanFor := ConvertToUpper(TextToScanFor);
     found := False;
     IF chatty THEN
        WriteLn ('Scanning for:  ',textseeking);

     FindFirst( textfiles, Archive, DirInfo);
     IF listf THEN
     IF DirInfo.Name = TextToScanFor THEN
        FindNext(DirInfo);
     WHILE (DosError = 0) AND (NOT found) DO
     BEGIN
          IF chatty THEN
             WriteLn ('Scanning file:  ',DirInfo.Name);
          ScanAFile(found,chatty,textseeking,DirInfo.Name);

          FindNext(DirInfo);
          IF listf THEN
          IF DirInfo.Name = TextToScanFor THEN
             FindNext(DirInfo);
     END;
     IF (NOT found) THEN
        WriteLn('- Not found: ',textseeking);
END;

VAR
   IsList,
   Verbose             : Boolean;
   List_File           : Text;

BEGIN
     GetCmdLnParms(Verbose, TextToScanFor, FilesToScan);

     IsList := IsFile(TextToScanFor);
     IF IsList THEN           {If first arg is a file, scan its contents.}
     BEGIN
          Assign(List_File,TextToScanFor);
          Reset(List_File);
          WHILE NOT Eof(List_File) DO
          BEGIN
               ReadLn(List_File,FileSeeking);
               FileSeeking := ConvertToUpper(FileSeeking);
               ScanTheFiles(Verbose,FileSeeking,FilesToScan,IsList);
          END;
          Close(List_File);
     END
     ELSE BEGIN
          FileSeeking := TextToScanFor;  {Scan for the text on command line.}
          FileSeeking := ConvertToUpper(FileSeeking);
          ScanTheFiles(Verbose,FileSeeking,FilesToScan,IsList);
     END;
END.
