/****************************************************************
*  FMSCHK version 1.10 - check RBBS FMS directory structure     *
*  compiled with Borland C++ v2.0 using Small memory model      *
*  Copyright (c) 1991-1993 by Bob Hampton                       *
*  S3-Tech BBS (703) 451-9509                                   *
*  all rights reserved                                          *
****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <ctype.h>

#define FALSE 0
#define TRUE !FALSE
#define MAXLINE 161		/* maximum length of FMS file line */

void fail (int linenumber, char *message, char *buffer);

int main (int argc, char **argv)
{
	char fmsname[MAXPATH],		/* FMS file to scan              */
	     buffer[MAXLINE],		/* buffer for file reading       */
	     *buffptr,                  /* work pointer for buffer       */
	     fnamebuff[14],             /* buffer for filename/ext parse */
	     fname[14],			/* file name                     */
	     fext[4],			/* file extension                */
	     *fsizeptr,                 /* pointer to file size          */
	     fsize[8],			/* file size                     */
	     fdate[9];			/* file date                     */
	FILE *fmsfile;			/* pointer to FMS file           */
	int linelength,                 /* length of FMS line            */
	    linenumber = 0,             /* line number in FMS file       */
	    length_err,                 /* flag for error in line length */
	    name_err,                   /*  "    "    "   " filename/ext */
	    size_err,                   /*  "    "    "   "  filesize    */
	    date_err,                   /*  "    "    "   "  file date   */
	    extra_err,                  /*  "    "  extraneous character */
	    retval = 0,                 /* return value: 0 = success     */
	    i = 0;   			/* work variable for indexing    */

	switch (argc)
	{
		case 2:
			strcpy (fmsname, *(argv + 1));
			break;
		default:
			fprintf (stderr, "\nInvalid command line\n\n");
			fprintf (stderr, "Usage: FMSCHK <FMS filename>\n");
			exit(1);
	}

	puts ("FMSCHK version 1.10                  (c) 1990-93 by Bob Hampton\n");

	/**************
	*  open file  *
	**************/
	if ((fmsfile = fopen (fmsname, "r")) == NULL)
	{
		printf ("Unable to open FMS file: %s\n", fmsname);
		exit (1);
	}

	/*********************************************
	*  read first line of file, set linelength,  *
	*  and seek to beginning of file             *
	*********************************************/
	fgets (buffer, MAXLINE, fmsfile);
	linelength = strlen (buffer);
	fseek (fmsfile, 0L, SEEK_SET);

	/*******************************
	*  for each line in FMS file,  *
	*******************************/
	while (fgets (buffer, MAXLINE, fmsfile) != NULL)
	{
		/******************************
		*  set error flags FALSE and  *
		*  increment line number      *
		******************************/
		length_err = FALSE;
		name_err = FALSE;
		size_err = FALSE;
		date_err = FALSE;
		extra_err = FALSE;
		linenumber++;

		/*******************************
		*  check for linelength error  *
		*******************************/
		if (strlen(buffer) != linelength)
			length_err = TRUE;

		/*********************************
		*  if line contains a filename,  *
		*********************************/
		if (strchr("\\ *", *buffer) == NULL)	/* if filename present:   */
		{
			/*****************************************
			*  set pointer and check for extraneous  *
			*  characters in specified places        *
			*****************************************/
			buffptr = buffer;
			if (buffer[21] != ' ' || buffer[22] != ' ' || buffer[31] != ' ')
				extra_err = TRUE;

			/*********************************************
			*  get name/ext into work buffer, and check  *
			*  for name/ext error, or extra characters   *
			*********************************************/
			strncpy (fnamebuff, buffer, 13);
			fnamebuff[13] = '\0';
			strcpy (fname, strtok (fnamebuff, " ."));
			strcpy (fext, strtok (NULL, " ."));
			if (strlen(fname) > 8)
				if (strlen (fname) > 9 || *fname != '=')
					name_err = TRUE;
			if (strlen(fext) > 3)
				name_err = TRUE;
			if (strtok (NULL, " "))
				extra_err = TRUE;

			/********************************************
			*  get filesize into buffer, strip leading  *
			*  spaces, and check for filesize error     *
			********************************************/
			buffptr += 14;
			strncpy (fsize, buffptr, 7);
			fsize[7] = '\0';
			fsizeptr = fsize;
			for (i = 0; *fsizeptr == ' ' && i < 6; fsizeptr++, i++);
			while (*fsizeptr)
				if (isdigit (*fsizeptr++) == 0)
					size_err = TRUE;

			/**********************************
			*  get file date into buffer and  *
			*  check for format error         *
			**********************************/
			buffptr += 9;
			for (i = 0; i < 9; i += 3)
			{
				if ((isdigit (buffptr[i]) && isdigit (buffptr[i+1])) == 0)
					date_err = TRUE;
				if (i < 4 && buffptr[i+2] != '-')
					date_err = TRUE;
			}
		}

		/******************************************
		*  check error flags and print any error  *
		*  messages for this FMS line             *
		******************************************/
		if (length_err || name_err || size_err || date_err || extra_err)
		{
			retval = -1;
			printf ("ERROR in line #%d of %s:\n", linenumber, fmsname);
			if (length_err)
				puts ("    error in line length");
			if (name_err)
				puts ("    error in filename format");
			if (size_err)
				puts ("    error in filesize format");
			if (date_err)
				puts ("    error in date format");
			if (extra_err)
				puts ("    extraneous characters in line");
			puts (buffer);
		}
	}
	if (retval == 0)
		printf ("file %s checks okay.\n", strupr(fmsname));
	exit (retval);
 }



