/*
 * "@(#)native.c	1.3 1.3 SMI"
 *
 * Copyright 1998-1999 Sun Microsystems, Inc.,
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 *
 *
 * For more on the Java Native Interface surf to :
 * http://www.javasoft.com/docs/books/tutorial/native1.1/index.html
 *
 */
#include <stdlib.h>
#include <jni.h>
#include <stdio.h>
#include <sys/param.h>
#include <sys/systeminfo.h>

#include "Native_Example.h"

/*
 *  native method to retrieve Hostname property
 *
 */
JNIEXPORT jstring JNICALL Java_Native_1Example_getHostname(JNIEnv *env,
jobject obj) {
    char buf[257];

	if (GetSystemProperty(SI_HOSTNAME, buf, 257)) {
	    return (*env)->NewStringUTF(env, buf);
	}
	return ((*env)->NewStringUTF(env, "unknown"));
}

/*
 *  native method to retrieve SerialNumber property
 *
 */
JNIEXPORT jstring JNICALL Java_Native_1Example_getSerialnumber
(JNIEnv *env, jobject obj) {
	char buf[257];

	if (GetSystemProperty(SI_HW_SERIAL, buf, 257)) {
	    return ((*env)->NewStringUTF(env, buf));
	}
	return ((*env)->NewStringUTF(env, "unknown"));
}

/*
 *  native method to retrieve OSRelease property
 *
 */
JNIEXPORT jstring JNICALL Java_Native_1Example_getRelease
				(JNIEnv *env, jobject obj) {
	char buf[257];

	if (GetSystemProperty(SI_RELEASE, buf, 257)) {
	    return ((*env)->NewStringUTF(env, buf));
	}
	return ((*env)->NewStringUTF(env, "unknown"));
}

/*
 *  native method to retrieve MachineType property
 *
 */
JNIEXPORT jstring JNICALL Java_Native_1Example_getMachine
(JNIEnv *env, jobject obj) {
	char buf[257];

	if (GetSystemProperty(SI_MACHINE, buf, 257)) {
	    return (*env)->NewStringUTF(env, buf);
	}
	return ((*env)->NewStringUTF(env, "unknown"));
}

/*
 *  native method to retrieve MachineArchitecture property
 *
 */
JNIEXPORT jstring JNICALL Java_Native_1Example_getArchitecture
(JNIEnv *env, jobject obj) {
	char buf[257];

	if (GetSystemProperty(SI_ARCHITECTURE, buf, 257)) {
	    return ((*env)->NewStringUTF(env, buf));
	}
	return ((*env)->NewStringUTF(env, "unknown"));
}

/*
 *  native method to retrieve Manufacturer property
 *
 */
JNIEXPORT jstring JNICALL Java_Native_1Example_getManufacturer
					(JNIEnv *env, jobject obj) {
	char buf[257];

	if (GetSystemProperty(SI_HW_PROVIDER, buf, 257)) {
	    return ((*env)->NewStringUTF(env, buf));
	}
	return ((*env)->NewStringUTF(env, "unknown"));
}

/*
 *  native method to print Hello World
 *
 */
JNIEXPORT jobject JNICALL Java_Native_1Example_HelloWorld
					(JNIEnv *env, jobject obj) {
	printf("\nHello World\n");
	return ((*env)->NewStringUTF(env, "hello world"));
}

/*
 *   GetSystemProperty calls the sysinfo lib to get the desired property
 *
 */
int GetSystemProperty(int property, char *buffer, int bufferSize) {
	long count;

	count = sysinfo(property, buffer, bufferSize);
	if (count > bufferSize) {
	    buffer[0] = NULL;
	    return (0);
	}
	return (count);
}
