
import java.rmi.*;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.security.UserPrincipal;
import com.sun.wbem.security.PasswordCredential;
import java.util.Enumeration;

/**
 * This example program takes command-line arguments and deletes all
 * instances of the specified class and its subclasses. The user must 
 * specify the username and password of the administrative account
 * for the CIM Object Manager repository.
 * 
 */
public class DeleteInstances {
    public static void main(String args[]) throws CIMException {
    
    	 // Initialize an instance of the CIM Client class
	CIMClient cc = null;
	
	// Requires 4 command-line arguments.
	// If not all entered, prints command string.
	
	if (args.length != 4) {
	    System.out.println
	        ("Usage: DeleteInstance host className username password"); 
	    System.exit(1);
	}
	try {
	
	    /**
	     * Creates a name space object (cns), which stores the host name
	     * (args[0]) from the command line.
	     */ 
	     
	    CIMNameSpace cns = new CIMNameSpace(args[0]);
    
	    /**
	     * Creates the user principal and password credential for
	     * authenticating the user to the CIMOM.
	     */
	    UserPrincipal up = new UserPrincipal(args[2]);
	    PasswordCredential pc = new PasswordCredential(args[3]);

	    /** 
	     * Connects to the CIM Object Manager, and passes it the
	     * name space object (cns) and the user principal and
	     * password credential.
	     */

	    cc = new CIMClient(cns, up, pc);

	    /**
	     * Construct an object containing the CIM object path
	     * of the class to delete (args[1]) from the command line.
	     */
            
	    CIMObjectPath cop = new CIMObjectPath(args[1]);
	    
	    /**
	     * Do a deep enumeration (true) of the class,
	     * which will print all the subclasses of the class.
	     */
	     
	    Enumeration e = cc.enumInstances(cop, true);
	    
	    /**
	     * Iterate through the instances in the enumeration.
	     * Construct an object to store the object path of each
	     * enumerated instance, print the instance, and then 
	     * delete it.
	     */
	     
	    while (e.hasMoreElements()) {
		CIMObjectPath op = (CIMObjectPath)e.nextElement();
		System.out.println(op);
		cc.deleteInstance(op);
	    }
	}
	catch (Exception e) {
	    System.out.println("Exception: "+e);
	}
	if (cc != null) {
	    cc.close();
	}
    }
}
