/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.BeanGenerator;
import com.sun.wbem.compiler.mib2mof.Def;
import com.sun.wbem.compiler.mib2mof.EntryCimGenerator;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.MibNode;
import com.sun.wbem.compiler.mib2mof.MofGenerator;
import com.sun.wbem.compiler.mib2mof.ResourceManager;
import com.sun.wbem.compiler.mib2mof.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class TableCimGenerator
extends BeanGenerator
implements Serializable {
    private String entryName = "";
    private String realName = "";
    private MibNode entryNode;
    private MofGenerator beanGen;

    public TableCimGenerator(ResourceManager resourceManager, String string, String string2, String string3, MibNode mibNode, ASTMib aSTMib) throws IOException {
        super(resourceManager, string, string2, string3, mibNode, aSTMib);
        this.varName = this.node.getSymbolName();
        this.realName = this.node.getRealSymbolName();
        this.oid = this.node.getOid();
        this.symboleName = String.valueOf(string2) + Def.TABLEPREFIX + this.varName;
        this.processEntry();
        this.updateEntryWithExternalIndex();
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String getSymbolName() {
        return this.varName;
    }

    public String getTableClassName() {
        return String.valueOf(this.symboleName) + " ";
    }

    private void processEntry() throws IOException {
        Hashtable hashtable = this.node.getChildren();
        if (hashtable.size() != 1) {
            Trace.error(MessageHandler.getMessage("generate.error.table.entry", this.realName));
            throw new IOException();
        }
        Enumeration enumeration = hashtable.elements();
        this.entryNode = (MibNode)enumeration.nextElement();
        this.beanGen = new EntryCimGenerator(this.manager, this.packageName, this.prefix, this.targetDir, this.entryNode, this.mib);
        Enumeration enumeration2 = this.entryNode.getChildren().elements();
        while (enumeration2.hasMoreElements()) {
            MibNode mibNode = (MibNode)enumeration2.nextElement();
            this.beanGen.handleNode(mibNode);
        }
        this.entryName = this.beanGen.getSnmpClassName();
    }

    protected void updateEntryWithExternalIndex() throws IOException {
        Enumeration enumeration = this.node.getExternalIndex().elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode = (MibNode)enumeration.nextElement();
            this.beanGen.handleNode(mibNode);
        }
        this.beanGen.endOfGroup();
    }

    protected void writeClassDeclaration() throws IOException {
    }
}

