/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.Def;
import com.sun.wbem.compiler.mib2mof.Generator;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.MetaBeanGenerator;
import com.sun.wbem.compiler.mib2mof.MibNode;
import com.sun.wbem.compiler.mib2mof.ResourceManager;
import java.io.IOException;
import java.io.Serializable;

public class MibGenerator
extends Generator
implements Serializable {
    protected String module = "";
    protected String translatedMibName = "";
    protected String fileName = "";
    protected StringBuffer init_impl = new StringBuffer();
    protected StringBuffer initprereg_impl = new StringBuffer();
    protected StringBuffer var_def = new StringBuffer();
    private String domainSeparator = ".";

    public MibGenerator(ResourceManager resourceManager, String string, String string2, String string3, ASTMib aSTMib) throws IOException {
        super(resourceManager, string, string2, string3);
        this.mib = aSTMib;
        this.module = aSTMib.getModuleName();
        this.translatedMibName = this.translateMibName();
        this.fileName = String.valueOf(string2) + this.translatedMibName;
        this.out = this.openFile(String.valueOf(this.fileName) + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.writeConstructor();
        this.buildInitHeader();
        this.buildInitPreRegHeader();
    }

    protected void buildInitHeader() throws IOException {
        this.init_impl.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.init") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_INIT + "() " + Def.THROWS + Def.EXCP_ILLEGAL + Def.LBRACE + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.oneCall") + "\n" + Def.TAB2 + "//\n" + Def.TAB2 + "if (isInitialized == true)" + Def.LBRACE + Def.TAB3 + Def.RETURN + Def.SEMICOLON + Def.TAB2 + Def.RBRACE + "\n");
    }

    protected void buildInitPreRegHeader() throws IOException {
        this.initprereg_impl.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.preRegister") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + "ObjectName preRegister(MBeanServer server, ObjectName name) " + Def.THROWS + "Exception" + Def.LBRACE + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.oneCall") + "\n" + Def.TAB2 + "//\n" + Def.TAB2 + "if (isInitialized == true)" + Def.LBRACE + Def.TAB3 + Def.THROW_NEW + "InstanceAlreadyExistsException()" + Def.SEMICOLON + Def.TAB2 + Def.RBRACE + "\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.cmf") + "\n" + Def.TAB2 + "//\n" + Def.TAB2 + "this.server = server" + Def.SEMICOLON + "\n");
    }

    protected void closeCode() {
        try {
            this.write(Def.RBRACE);
        }
        catch (IOException iOException) {}
    }

    protected void closeInit() throws IOException {
        this.init_impl.append(String.valueOf(Def.TAB2) + "isInitialized = true" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeInitPreReg() throws IOException {
        this.initprereg_impl.append(String.valueOf(Def.TAB2) + "isInitialized = true" + Def.SEMICOLON + Def.TAB2 + Def.RETURN + "name" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    public void endMib() throws IOException {
        this.closeInit();
        this.closeInitPreReg();
        this.write(this.init_impl.toString());
        this.write(this.initprereg_impl.toString());
        this.writeVariableDefinition();
        this.write(Def.RBRACE);
    }

    public void registerNode(MibNode mibNode, String string) throws IOException {
        String string2 = mibNode.getSymbolName();
        if (string2 == null) {
            string2 = this.getClassName(mibNode.getComputedOid());
        }
        String string3 = mibNode.getComputedOid();
        String string4 = MetaBeanGenerator.buildMetaName(this.prefix, string2);
        String string5 = String.valueOf(this.prefix) + string2;
        this.init_impl.append(String.valueOf(Def.TAB2) + "// " + MessageHandler.getMessage("generate.mib.comment.init.group", string2) + "\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.init.support") + "\n" + Def.TAB2 + "//\n" + Def.TAB2 + Def.N_LBRACE + Def.TAB3 + string4 + " meta = new " + string4 + "((" + Def.SNMP_MIB + ")this)" + Def.SEMICOLON + Def.TAB3 + "meta." + Def.SET_MOI + "(new " + string5 + "((" + Def.SNMP_MIB + ")this))" + Def.SEMICOLON + Def.TAB3 + "root.registerNode(\"" + string3 + "\", (" + Def.SNMP_NODE + ")meta)" + Def.SEMICOLON + Def.TAB2 + Def.RBRACE + "\n");
        String string6 = this.packageName.length() != 0 ? "." : "";
        string = string == null ? "" : String.valueOf(this.domainSeparator) + string;
        this.initprereg_impl.append(String.valueOf(Def.TAB2) + "// " + MessageHandler.getMessage("generate.mib.comment.init.group", string2) + "\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.init.support") + "\n" + Def.TAB2 + "//\n" + Def.TAB2 + Def.N_LBRACE + Def.TAB3 + string4 + " meta = new " + string4 + "((" + Def.SNMP_MIB + ")this)" + Def.SEMICOLON + Def.TAB3 + string5 + " instance = new " + string5 + "((" + Def.SNMP_MIB + ")this, server)" + Def.SEMICOLON + Def.TAB3 + "meta." + Def.SET_MOI + "(instance)" + Def.SEMICOLON + Def.TAB3 + "root.registerNode(\"" + string3 + "\", (" + Def.SNMP_NODE + ")meta)" + Def.SEMICOLON + Def.TAB3 + "server.registerMBean(instance, new ObjectName(mibName + \"" + string + ":name=" + this.packageName + string6 + string5 + "\"))" + Def.SEMICOLON + Def.TAB2 + Def.RBRACE + "\n");
    }

    public String setDomainSeparator(String string) {
        if (string != null) {
            this.domainSeparator = string;
        }
        return this.domainSeparator;
    }

    private String translateMibName() throws IOException {
        String string = this.module.trim();
        string = string.replace('-', '_');
        string = string.replace('.', '_');
        string = string.replace(',', '_');
        string = string.replace(',', '_');
        string = string.replace(' ', '_');
        return string;
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mib.comment.header", this.module) + "\n" + " * " + MessageHandler.getMessage("generate.mib.comment.modif") + "\n" + " */\n");
        this.write(String.valueOf(Def.PUBLIC) + Def.CLASS + this.fileName + Def.EXTEND + Def.SNMP_MIB + Def.IMPLEMENT + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeConstructor() throws IOException {
        this.write(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.const") + "\n" + Def.TAB + " */\n");
        this.write(String.valueOf(Def.TAB) + Def.PUBLIC + this.fileName + "()" + Def.LBRACE + Def.TAB2 + "mibName = \"" + this.translatedMibName + "\"" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_MBEAN_SERVER + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_OBJECT_NAME + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_INSTANCE_ALREADY_EXISTS_EXCEPTION + Def.SEMICOLON);
        this.write("\n// jdmk imports\n//\n");
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_MIB + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_MIB_NODE + Def.SEMICOLON);
        this.write("\n");
    }

    protected void writeVariableDefinition() throws IOException {
        this.write(String.valueOf(Def.TAB) + Def.PRIVATE + Def.BOOLEAN + "isInitialized = false" + Def.SEMICOLON + "\n");
    }
}

