/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTNamedType;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.Node;
import com.sun.wbem.compiler.mib2mof.Parser;
import com.sun.wbem.compiler.mib2mof.SimpleNode;
import com.sun.wbem.compiler.mib2mof.SyntaxMapper;
import com.sun.wbem.compiler.mib2mof.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ASTBitStringValue
extends SimpleNode {
    protected String value;
    protected int type;
    static byte[] byteTab = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};

    ASTBitStringValue(int n) {
        super(n);
    }

    ASTBitStringValue(Parser parser, int n) {
        super(parser, n);
    }

    String BinToByte(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length() / 8;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" new Byte(\"");
            stringBuffer.append((byte)Integer.parseInt(string.substring(8 * n2, 8 * n2 + 8), 2));
            stringBuffer.append("\")");
            if (n2 < n - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    String CharToByte(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" new Byte(\"");
            stringBuffer.append(byArray[n2]);
            stringBuffer.append("\")");
            if (n2 < n - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    String HexToByte(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length() / 2;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" new Byte(\"");
            stringBuffer.append((byte)Integer.parseInt(string.substring(2 * n2, 2 * n2 + 2), 16));
            stringBuffer.append("\")");
            if (n2 < n - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    String HexToCharForIpAddress(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length() / 2;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append((long)Integer.parseInt(string.substring(2 * n2, 2 * n2 + 2), 16));
            if (n2 < n - 1) {
                stringBuffer.append(".");
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    String calculateDefValBITS(Hashtable hashtable, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            n3 = Math.max(n3, new Integer((String)enumeration.nextElement()));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                nArray[n2] = new Integer((String)hashtable.get(string2));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            ++n2;
        }
        int n4 = n3 / 8 + 1;
        byte[] byArray = new byte[n4];
        n2 = 0;
        while (n2 < n4) {
            byArray[n2] = 0;
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[n2];
            byArray[n / 8] = (byte)(byArray[n / 8] | byteTab[7 - n % 8]);
            ++n2;
        }
        n2 = 0;
        while (n2 < n4) {
            stringBuffer.append(" new Byte(\"");
            stringBuffer.append(byArray[n2]);
            stringBuffer.append("\")");
            if (n2 < n4 - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDefValInitializer(String string, ASTNamedType aSTNamedType, String string2) {
        String string3 = new String();
        int n = 0;
        int n2 = SyntaxMapper.getIntSnmpSyntax(aSTNamedType.getSnmpSyntax());
        switch (this.type) {
            case 93: {
                if (this.value.length() < 3) return string3;
                n = this.value.lastIndexOf("b");
                if (n == -1 && (n = this.value.lastIndexOf("B")) == -1) return string3;
                switch (n2) {
                    case 4: {
                        string3 = this.value.substring(0, n);
                        string3 = string3.replace('\'', ' ').trim();
                        return " = new Integer(" + String.valueOf((long)Integer.parseInt(string3, 2)) + ")";
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 7: {
                        string3 = this.value.substring(0, n);
                        string3 = string3.replace('\'', ' ').trim();
                        return " = new Long(" + String.valueOf(Long.parseLong(string3, 2)) + "L)";
                    }
                    case 9: {
                        string3 = this.value.substring(0, n);
                        string3 = string3.replace('\'', ' ').trim();
                        return " = SnmpString.BinToChar(\"" + string3 + "\")";
                    }
                    case 10: {
                        string3 = this.value.substring(0, n);
                        string3 = string3.replace('\'', ' ').trim();
                        return " = {" + this.BinToByte(string3) + "}";
                    }
                    default: {
                        return string3;
                    }
                }
            }
            case 94: {
                if (this.value.length() < 3) return string3;
                n = this.value.lastIndexOf("h");
                if (n == -1 && (n = this.value.lastIndexOf("H")) == -1) return string3;
                switch (n2) {
                    case 4: {
                        string3 = this.value.substring(0, n);
                        string3 = string3.replace('\'', ' ').trim();
                        return " = new Integer(" + String.valueOf((long)Integer.parseInt(string3, 16)) + ")";
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 7: {
                        string3 = this.value.substring(0, n);
                        string3 = string3.replace('\'', ' ').trim();
                        return " = new Long(" + String.valueOf(Long.parseLong(string3, 16)) + "L)";
                    }
                    case 9: {
                        string3 = this.value.substring(0, n);
                        string3 = string3.replace('\'', ' ').trim();
                        return " = SnmpString.HexToChar(\"" + string3 + "\")";
                    }
                    case 6: {
                        string3 = this.value.substring(0, n);
                        string3 = string3.replace('\'', ' ').trim();
                        return " = new String(\"" + this.HexToCharForIpAddress(string3) + "\")";
                    }
                    case 8: 
                    case 10: {
                        string3 = this.value.substring(0, n);
                        string3 = string3.replace('\'', ' ').trim();
                        return " = {" + this.HexToByte(string3) + "}";
                    }
                    default: {
                        return string3;
                    }
                }
            }
            case 95: {
                if (this.value.length() < 2) return string3;
                switch (n2) {
                    case 9: {
                        return " = new String(" + String.valueOf(this.value) + ")";
                    }
                    case 10: {
                        string3 = String.valueOf(this.value);
                        string3 = string3.replace('\"', ' ').trim();
                        return " = {" + this.CharToByte(string3) + "}";
                    }
                    default: {
                        return string3;
                    }
                }
            }
            default: {
                switch (n2) {
                    case 10: {
                        if (!aSTNamedType.isEnumeratedBITSType()) return string3;
                        Hashtable hashtable = aSTNamedType.getEnumeratedBITSDef().getEnum();
                        String string4 = this.calculateDefValBITS(hashtable, this.value);
                        if (string4 != null) {
                            return " = {" + string4 + "}";
                        }
                        Trace.warning(MessageHandler.getMessage("compile.w.defval", this.value, string2));
                        return string3;
                    }
                    default: {
                        Trace.warning(MessageHandler.getMessage("compile.w.defval", this.value, string2));
                        return string3;
                    }
                }
            }
        }
    }

    public static Node jjtCreate(int n) {
        return new ASTBitStringValue(n);
    }

    public static Node jjtCreate(Parser parser, int n) {
        return new ASTBitStringValue(parser, n);
    }
}

