/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.dhtadm;

import com.sun.dhcpmgr.bridge.NoTableException;
import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.common.Format;
import com.sun.dhcpmgr.cli.dhtadm.DhtAdmFunction;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.data.Option;

public class DisplayTable
extends DhtAdmFunction {
    static final int[] supportedOptions = new int[]{114, 117, 112};

    public DisplayTable() {
        this.validOptions = supportedOptions;
    }

    public int execute() throws IllegalArgumentException {
        int n = 0;
        Macro[] macroArray = null;
        Option[] optionArray = null;
        try {
            macroArray = DhcpCliFunction.getDhcptabMgr().getMacros(this.getDhcpDatastore());
            optionArray = DhcpCliFunction.getDhcptabMgr().getOptions(this.getDhcpDatastore());
        }
        catch (NoTableException noTableException) {
            this.printErrMessage(DhcpCliFunction.getMessage(noTableException));
            n = 2;
        }
        catch (Throwable throwable) {
            this.printErrMessage(DhcpCliFunction.getMessage(throwable));
            n = 3;
        }
        if (n == 0) {
            Format.print(System.out, "%-20s\t", this.getString("Name"));
            Format.print(System.out, "%-8s\t", this.getString("Type"));
            Format.print(System.out, "%s\n", this.getString("Value"));
            Format.print(System.out, "%s\n", "==================================================");
            int n2 = 0;
            while (macroArray != null && n2 < macroArray.length) {
                Macro macro = macroArray[n2];
                Format.print(System.out, "%-20s\t", macro.getKey());
                Format.print(System.out, "%-8s\t", this.getString("Macro"));
                Format.print(System.out, "%s\n", macro.getValue());
                ++n2;
            }
            int n3 = 0;
            while (optionArray != null && n3 < optionArray.length) {
                Option option = optionArray[n3];
                Format.print(System.out, "%-20s\t", option.getKey());
                Format.print(System.out, "%-8s\t", this.getString("Symbol"));
                Format.print(System.out, "%s\n", option.getValue());
                ++n3;
            }
        }
        return n;
    }
}

