/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.dhtadm;

import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.common.DhcpCliOptions;
import com.sun.dhcpmgr.cli.common.DhcpCliPrint;
import com.sun.dhcpmgr.cli.common.DhcpCliProgram;
import com.sun.dhcpmgr.cli.common.GetOpt;
import com.sun.dhcpmgr.cli.dhtadm.AddEntry;
import com.sun.dhcpmgr.cli.dhtadm.CreateTable;
import com.sun.dhcpmgr.cli.dhtadm.DeleteEntry;
import com.sun.dhcpmgr.cli.dhtadm.DhtAdmBatch;
import com.sun.dhcpmgr.cli.dhtadm.DhtAdmFunction;
import com.sun.dhcpmgr.cli.dhtadm.DisplayTable;
import com.sun.dhcpmgr.cli.dhtadm.ModifyEntry;
import com.sun.dhcpmgr.cli.dhtadm.RemoveTable;
import com.sun.dhcpmgr.cli.dhtadm.ResourceStrings;
import java.text.MessageFormat;

public class DhtAdm
extends DhcpCliProgram {
    public static final String SIGNATURE = "dhtadm: ";
    private static String optString = "ACDIMPRvr:p:u:s:m:n:e:d:B;";
    private static final int ADD_ENTRY = 65;
    private static final int MODIFY_ENTRY = 77;
    private static final int DELETE_ENTRY = 68;
    private static final int CREATE_TABLE = 67;
    private static final int REMOVE_TABLE = 82;
    private static final int DISPLAY_TABLE = 80;
    private static final int BATCH_EXECUTION = 66;
    public static final int MACRONAME = 109;
    public static final int SYMBOLNAME = 115;
    public static final int NEWNAME = 110;
    public static final int DEFINITION = 100;
    public static final int EDITSYMBOL = 101;
    public static final int RESOURCE = 114;
    public static final int RESOURCE_CONFIG = 117;
    public static final int PATH = 112;
    public static final int VERBOSE = 118;
    private DhtAdmFunction function = null;
    private DhcpCliOptions options = null;
    private String[] args = null;

    public DhtAdm(String[] stringArray) {
        this.reset(stringArray);
        this.options = new DhcpCliOptions();
        this.args = stringArray;
    }

    public int execute() {
        int n = 0;
        GetOpt getOpt = new GetOpt(this.args, optString);
        try {
            int n2;
            while ((n2 = getOpt.getNextOption()) != -1) {
                this.processArg(n2, getOpt.getOptionArg());
            }
            int n3 = getOpt.getNextOptionIndex();
            if (this.args.length != n3) {
                Object[] objectArray = new Object[]{this.args[n3]};
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_arg"));
                throw new IllegalArgumentException(messageFormat.format(objectArray));
            }
            if (this.function == null) {
                String string = this.getString("no_function_error");
                throw new IllegalArgumentException(string);
            }
            if (!this.function.isVersionValid(false)) {
                return 4;
            }
            this.function.setDhcpDatastore(this.options.valueOf(114), this.options.valueOf(112), this.options.valueOf(117));
            this.function.setOptions(this.options);
            this.function.setStandardOptions();
            n = this.function.execute();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuffer stringBuffer = new StringBuffer(SIGNATURE);
            stringBuffer.append(DhcpCliFunction.getMessage(illegalArgumentException));
            DhcpCliPrint.printErrMessage(stringBuffer.toString());
            DhcpCliPrint.printErrMessage("");
            this.usage();
            n = 4;
        }
        catch (Throwable throwable) {
            StringBuffer stringBuffer = new StringBuffer(SIGNATURE);
            stringBuffer.append(DhcpCliFunction.getMessage(throwable));
            DhcpCliPrint.printErrMessage(stringBuffer.toString());
            n = 4;
        }
        return n;
    }

    public String getManPage() {
        return "dhtadm(1M)";
    }

    public String getString(String string) {
        return ResourceStrings.getString(string);
    }

    public static void main(String[] stringArray) {
        DhtAdm dhtAdm = new DhtAdm(stringArray);
        int n = 4;
        if (dhtAdm.isValidUser()) {
            n = dhtAdm.execute();
        }
        System.exit(n);
    }

    public void processArg(int n, String string) throws IllegalArgumentException {
        switch (n) {
            case 65: {
                this.function = new AddEntry();
                break;
            }
            case 77: {
                this.function = new ModifyEntry();
                break;
            }
            case 68: {
                this.function = new DeleteEntry();
                break;
            }
            case 67: {
                this.function = new CreateTable();
                break;
            }
            case 82: {
                this.function = new RemoveTable();
                break;
            }
            case 80: {
                this.function = new DisplayTable();
                break;
            }
            case 66: {
                this.function = new DhtAdmBatch(string);
                break;
            }
            default: {
                this.options.setOption(n, string);
            }
        }
    }

    public void reset(String[] stringArray) {
        this.function = null;
        this.options = new DhcpCliOptions();
        this.args = stringArray;
    }

    public void usage() {
        DhcpCliPrint.printErrMessage(this.getString("usage"));
    }
}

