/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.dhcpconfig;

import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.dhcpconfig.DhcpCfgFunction;
import com.sun.dhcpmgr.cli.dhcpconfig.IPAddressList;
import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.data.ValidationException;
import java.util.Vector;

public class ConfigureNetwork
extends DhcpCfgFunction {
    static final int[] supportedOptions = new int[]{109, 98, 116, 121, 97};
    String address;

    public ConfigureNetwork(String string) {
        this.validOptions = supportedOptions;
        this.address = string;
    }

    public int execute() {
        Object[] objectArray;
        String string;
        String string2;
        Network network;
        if (!this.isServerConfigured()) {
            return -1;
        }
        if (!this.isVersionValid(false)) {
            return -1;
        }
        try {
            network = DhcpCliFunction.getNetMgr().getNetwork(this.address);
        }
        catch (Throwable throwable) {
            Object[] objectArray2 = new Object[]{this.address};
            this.printErrMessage(this.getString("cfgnet_invalid_network_error"), objectArray2);
            return -1;
        }
        IPAddress iPAddress = null;
        String string3 = this.options.valueOf(109);
        if (string3 != null) {
            try {
                iPAddress = new IPAddress(string3);
                network.setMask(iPAddress);
            }
            catch (ValidationException validationException) {
                Object[] objectArray3 = new Object[]{this.address};
                this.printErrMessage(this.getString("cfgnet_invalid_ip_error"), objectArray3);
                return -1;
            }
        }
        boolean bl = this.options.isSet(98) ^ true;
        IPAddressList iPAddressList = null;
        if (this.options.isSet(116)) {
            try {
                string2 = this.options.valueOf(116);
                iPAddressList = new IPAddressList(string2);
            }
            catch (ValidationException validationException) {
                this.printErrMessage(DhcpCliFunction.getMessage(validationException));
                return -1;
            }
        }
        if ((string2 = this.options.valueOf(121)) == null != ((string = this.options.valueOf(97)) == null)) {
            String string4 = this.getString("cfgnet_nis_error");
            throw new IllegalArgumentException(string4);
        }
        IPAddressList iPAddressList2 = null;
        try {
            if (string2 == null) {
                string2 = DhcpCliFunction.getSvcMgr().getStringOption("NISdmain", "");
            }
            iPAddressList2 = string != null ? new IPAddressList(string) : new IPAddressList(DhcpCliFunction.getSvcMgr().getIPOption("NISservs", ""));
        }
        catch (ValidationException validationException) {
            Object[] objectArray4 = new Object[]{DhcpCliFunction.getMessage(validationException)};
            this.printErrMessage(this.getString("cfgnet_nis_server_error"), objectArray4);
            return -1;
        }
        catch (Throwable throwable) {}
        try {
            IPAddress[] iPAddressArray = null;
            if (iPAddressList != null) {
                iPAddressArray = iPAddressList.toIPAddressArray();
            }
            DhcpCliFunction.getDhcptabMgr().createNetworkMacro(network, iPAddressArray, bl, string2, (Vector)iPAddressList2, null, null);
            objectArray = new Object[]{network.toString()};
            this.printMessage(this.getString("cfgnet_network_macro_progress"), objectArray);
        }
        catch (Throwable throwable) {
            Object[] objectArray5 = new Object[]{DhcpCliFunction.getMessage(throwable)};
            this.printErrMessage(this.getString("cfgnet_network_macro_error"), objectArray5);
            return -1;
        }
        try {
            DhcpCliFunction.getNetMgr().createNetwork(network.toString());
            this.printMessage(this.getString("cfgnet_network_table_progress"));
        }
        catch (Throwable throwable) {
            objectArray = new Object[]{DhcpCliFunction.getMessage(throwable)};
            this.printErrMessage(this.getString("cfgnet_network_table_error"), objectArray);
            return -1;
        }
        return 0;
    }
}

