/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.osservermgr.cli;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CommandLineOption;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.osservermgr.client.ApplicationContext;
import com.sun.admin.osservermgr.client.ServiceWrapper;
import com.sun.admin.osservermgr.common.DisklessClientData;
import com.sun.admin.osservermgr.common.OsServerMgrCliArgParsingException;
import com.sun.admin.osservermgr.common.OsServerMgrCliHelpException;
import com.sun.admin.osservermgr.common.OsServerMgrException;
import com.sun.admin.osservermgr.common.OsServiceData;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viper.util.SecureReader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class OsServerMgrCli
implements Tool,
IClientResource {
    public static final int DC_ADD_TASK = 0;
    public static final int DC_DELETE_TASK = 1;
    public static final int DC_MODIFY_TASK = 2;
    public static final int DC_VIEW_TASK = 3;
    public static final int OSS_ADD_TASK = 4;
    public static final int OSS_DELETE_TASK = 5;
    public static final int OSS_VIEW_TASK = 6;
    public static final int PATCH_TASK = 7;
    public static final String TYPE_OF_UPDATE_DATABASE = "database";
    public static final String TYPE_OF_UPDATE_FILESYSTEM = "filesystem";
    public static final String TYPE_OF_UPDATE_ALL = "all";
    private Vector vObjs = null;
    private boolean bListSpooledPatches = false;
    private boolean bSyncSpooledPatches = false;
    private boolean bUpdateClient = false;
    private String strPatchDirectory = null;
    private String strRemovePatch = null;
    private String strOsServer = null;
    private int iOperation = -1;
    private boolean bDebug = false;
    private boolean bMachineReadable = false;
    private ServiceWrapper osServerServiceWrapper = null;
    private ServiceWrapper nameServerServiceWrapper = null;
    private VConsoleProperties properties = null;
    private ToolInfrastructure infrastructure = null;
    private boolean bRunning = false;
    private ResourceBundle resourceBundle = null;
    private ApplicationContext nameServerApplicationContext = null;
    private ApplicationContext osServerApplicationContext = null;
    private ToolContext toolContext = null;
    private String nameServerType = null;
    private String nameServer = null;
    protected CommandLineOption coHelp;
    protected CommandLineOption coTask;
    protected CommandLineOption coOsServer;

    public OsServerMgrCli() {
        String string = System.getProperty("osservermgr.Debugging");
        if (string != null && string.equals("ON")) {
            this.setDebugStatus(true);
            this.trace("Debugging enabled");
        }
        this.vObjs = new Vector();
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceManager.getBundle((String)"com.sun.admin.osservermgr.cli.resources.Resources", this.getClass());
            this.setResourceBundle(resourceBundle);
        }
        catch (Exception exception) {
            resourceBundle = null;
            this.trace("Debugging enabled");
        }
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle("com.sun.admin.osservermgr.cli.resources.Resources", Locale.getDefault(), this.getClass().getClassLoader());
            this.setResourceBundle(resourceBundle);
        }
        if (resourceBundle == null) {
            this.trace("OsServerMgrCli Constructor....Null resourceBundle!!!");
        }
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
    }

    private void checkForDcAddOptions(String[] stringArray) throws Exception {
        DisklessClientData disklessClientData = new DisklessClientData();
        Vector vector = new Vector();
        OsCommandParser osCommandParser = new OsCommandParser("dc_add", this.getLocalizedMessage("smdcadd_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("ipaddr", this.getLocalizedMessage("arg_ipaddr_desc"), "i", 1, true, false, (Object)"", false, false);
        CommandLineOption commandLineOption2 = new CommandLineOption("etheraddr", this.getLocalizedMessage("arg_etheraddr_desc"), "e", 1, true, false, (Object)"", false, false);
        CommandLineOption commandLineOption3 = new CommandLineOption("host", this.getLocalizedMessage("arg_hostname_desc"), "n", 1, false, false, (Object)"", false, false);
        CommandLineOption commandLineOption4 = new CommandLineOption("xArgs", this.getLocalizedMessage("arg_xargsdcadd_desc"), "x", 1, true, true, null, false, false);
        try {
            osCommandParser.addOption((CommandOption)commandLineOption);
            osCommandParser.addOption((CommandOption)commandLineOption2);
            osCommandParser.addOption((CommandOption)commandLineOption3);
            osCommandParser.addOption((CommandOption)commandLineOption4);
            osCommandParser.addOption((CommandOption)this.coHelp);
            osCommandParser.addOption((CommandOption)this.coOsServer);
            if (osCommandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    this.trace("ipAddress=" + commandLineOption.getValue());
                    disklessClientData.setIpAddress((String)commandLineOption.getValue());
                }
                if (commandLineOption2.wasSet()) {
                    this.trace("ethernetAddress=" + (String)commandLineOption2.getValue());
                    disklessClientData.setEthernetAddress((String)commandLineOption2.getValue());
                }
                if (commandLineOption3.wasSet()) {
                    this.trace("hostName=" + commandLineOption3.getValue());
                    disklessClientData.setHostName((String)commandLineOption3.getValue());
                }
                if (commandLineOption4.wasSet()) {
                    vector = commandLineOption4.getValues();
                    disklessClientData = this.parseXDcAddOptions(vector, disklessClientData);
                    this.trace("XArgs=" + vector);
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    osCommandParser.printUsage();
                    throw new OsServerMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = osCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 2) {
                String string = "";
                int n = 0;
                while (n < stringArray2.length - 2) {
                    string = String.valueOf(string) + stringArray2[n] + " ";
                    ++n;
                }
                throw new OsServerMgrCliArgParsingException("EXM_BAD_ARGS", string);
            }
            disklessClientData.setFileServer(this.strOsServer);
            if (disklessClientData.getNameService().compareTo("") == 0) {
                if (this.nameServerType.compareTo("nis") == 0 || this.nameServerType.compareTo("nisplus") == 0) {
                    disklessClientData.setNameService(this.nameServerType);
                    disklessClientData.setNameServer(this.nameServer);
                }
                if (this.nameServerType.compareTo("file") == 0) {
                    disklessClientData.setNameService("none");
                }
            }
            this.vObjs.addElement(disklessClientData);
        }
        catch (OsServerMgrCliHelpException osServerMgrCliHelpException) {
            throw osServerMgrCliHelpException;
        }
        catch (OsServerMgrCliArgParsingException osServerMgrCliArgParsingException) {
            osCommandParser.printUsage(osServerMgrCliArgParsingException.getLocalizedMessage());
            throw osServerMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("doh!\t Throwable type-of-exception");
            throw new OsServerMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForDcDeleteOptions(String[] stringArray) throws Exception {
        DisklessClientData disklessClientData = new DisklessClientData();
        OsCommandParser osCommandParser = new OsCommandParser("dc_del", this.getLocalizedMessage("smdcdel_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("host", this.getLocalizedMessage("arg_hostname_desc"), "n", 1, false, false, (Object)"", false, false);
        try {
            osCommandParser.addOption((CommandOption)commandLineOption);
            osCommandParser.addOption((CommandOption)this.coHelp);
            osCommandParser.addOption((CommandOption)this.coOsServer);
            if (osCommandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    this.trace("hostName=" + commandLineOption.getValue());
                    disklessClientData.setHostName((String)commandLineOption.getValue());
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    osCommandParser.printUsage();
                    throw new OsServerMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = osCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 2) {
                String string = "";
                int n = 0;
                while (n < stringArray2.length - 2) {
                    string = String.valueOf(string) + stringArray2[n] + " ";
                    ++n;
                }
                throw new OsServerMgrCliArgParsingException("EXM_BAD_ARGS", string);
            }
            this.vObjs.addElement(disklessClientData);
        }
        catch (OsServerMgrCliHelpException osServerMgrCliHelpException) {
            throw osServerMgrCliHelpException;
        }
        catch (OsServerMgrCliArgParsingException osServerMgrCliArgParsingException) {
            osCommandParser.printUsage(osServerMgrCliArgParsingException.getLocalizedMessage());
            throw osServerMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("doh!\t Throwable type-of-exception");
            throw new OsServerMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForDcModifyOptions(String[] stringArray) throws Exception {
        boolean bl = false;
        DisklessClientData disklessClientData = new DisklessClientData();
        DisklessClientData disklessClientData2 = new DisklessClientData();
        Vector vector = new Vector();
        OsCommandParser osCommandParser = new OsCommandParser("dc_mod", this.getLocalizedMessage("smdcmod_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("host", this.getLocalizedMessage("arg_hostname_desc"), "n", 1, false, false, (Object)"", false, false);
        CommandLineOption commandLineOption2 = new CommandLineOption("etheraddr", this.getLocalizedMessage("arg_etheraddr_desc"), "e", 1, true, false, (Object)"", false, false);
        CommandLineOption commandLineOption3 = new CommandLineOption("xArgs", this.getLocalizedMessage("arg_xargsdcmod_desc"), "x", 1, true, true, null, false, false);
        try {
            osCommandParser.addOption((CommandOption)commandLineOption);
            osCommandParser.addOption((CommandOption)commandLineOption2);
            osCommandParser.addOption((CommandOption)commandLineOption3);
            osCommandParser.addOption((CommandOption)this.coHelp);
            osCommandParser.addOption((CommandOption)this.coOsServer);
            if (osCommandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    this.trace("hostName=" + commandLineOption.getValue());
                    disklessClientData.setHostName((String)commandLineOption.getValue());
                    disklessClientData2.setHostName((String)commandLineOption.getValue());
                }
                if (commandLineOption2.wasSet()) {
                    this.trace("ethernetAddress=" + (String)commandLineOption2.getValue());
                    bl = true;
                    disklessClientData2.setEthernetAddress((String)commandLineOption2.getValue());
                }
                if (commandLineOption3.wasSet()) {
                    vector = commandLineOption3.getValues();
                    disklessClientData2 = this.parseXDcModifyOptions(vector, disklessClientData2);
                    this.trace("XArgs=" + vector);
                    bl = true;
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    osCommandParser.printUsage();
                    throw new OsServerMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = osCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 2) {
                String string = "";
                int n = 0;
                while (n < stringArray2.length - 2) {
                    string = String.valueOf(string) + stringArray2[n] + " ";
                    ++n;
                }
                throw new OsServerMgrCliArgParsingException("EXM_BAD_ARGS", string);
            }
            this.vObjs.addElement(disklessClientData);
            this.vObjs.addElement(disklessClientData2);
        }
        catch (OsServerMgrCliHelpException osServerMgrCliHelpException) {
            throw osServerMgrCliHelpException;
        }
        catch (OsServerMgrCliArgParsingException osServerMgrCliArgParsingException) {
            osCommandParser.printUsage(osServerMgrCliArgParsingException.getLocalizedMessage());
            throw osServerMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("doh!\t Throwable type-of-exception");
            throw new OsServerMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
        if (!bl) {
            osCommandParser.printUsage();
            throw new OsServerMgrCliHelpException(null);
        }
    }

    private void checkForDcViewOptions(String[] stringArray) throws Exception {
        DisklessClientData disklessClientData = new DisklessClientData();
        OsCommandParser osCommandParser = new OsCommandParser("dc_ls", this.getLocalizedMessage("smdcls_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("machinereadable", this.getLocalizedMessage("arg_machinereadable_desc"), "v", 0, true, false, (Object)"", false, false);
        try {
            osCommandParser.addOption((CommandOption)this.coHelp);
            osCommandParser.addOption((CommandOption)this.coOsServer);
            osCommandParser.addOption((CommandOption)commandLineOption);
            if (osCommandParser.parseArgs(stringArray)) {
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    osCommandParser.printUsage();
                    throw new OsServerMgrCliHelpException(null);
                }
                if (commandLineOption.wasSet()) {
                    this.bMachineReadable = true;
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = osCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 2) {
                String string = "";
                int n = 0;
                while (n < stringArray2.length - 2) {
                    string = String.valueOf(string) + stringArray2[n] + " ";
                    ++n;
                }
                throw new OsServerMgrCliArgParsingException("EXM_BAD_ARGS", string);
            }
            this.vObjs.addElement(disklessClientData);
        }
        catch (OsServerMgrCliHelpException osServerMgrCliHelpException) {
            throw osServerMgrCliHelpException;
        }
        catch (OsServerMgrCliArgParsingException osServerMgrCliArgParsingException) {
            osCommandParser.printUsage(osServerMgrCliArgParsingException.getLocalizedMessage());
            throw osServerMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("doh!\t Throwable type-of-exception");
            throw new OsServerMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForOssAddOptions(String[] stringArray) throws Exception {
        OsServiceData osServiceData = new OsServiceData();
        Vector vector = new Vector();
        OsCommandParser osCommandParser = new OsCommandParser("oss_add", this.getLocalizedMessage("smossadd_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("xArgs", this.getLocalizedMessage("arg_xargsossadd_desc"), "x", 1, false, true, null, false, false);
        try {
            osCommandParser.addOption((CommandOption)commandLineOption);
            osCommandParser.addOption((CommandOption)this.coHelp);
            osCommandParser.addOption((CommandOption)this.coOsServer);
            if (osCommandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    vector = commandLineOption.getValues();
                    osServiceData = this.parseXOssAddOptions(vector, osServiceData);
                    this.trace("XArgs=" + vector);
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    osCommandParser.printUsage();
                    throw new OsServerMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = osCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 2) {
                String string = "";
                int n = 0;
                while (n < stringArray2.length - 2) {
                    string = String.valueOf(string) + stringArray2[n] + " ";
                    ++n;
                }
                throw new OsServerMgrCliArgParsingException("EXM_BAD_ARGS", string);
            }
            this.vObjs.addElement(osServiceData);
        }
        catch (OsServerMgrCliHelpException osServerMgrCliHelpException) {
            throw osServerMgrCliHelpException;
        }
        catch (OsServerMgrCliArgParsingException osServerMgrCliArgParsingException) {
            osCommandParser.printUsage(osServerMgrCliArgParsingException.getLocalizedMessage());
            throw osServerMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("doh!\t Throwable type-of-exception");
            throw new OsServerMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForOssDeleteOptions(String[] stringArray) throws Exception {
        OsServiceData osServiceData = new OsServiceData();
        Vector vector = new Vector();
        OsCommandParser osCommandParser = new OsCommandParser("oss_del", this.getLocalizedMessage("smossdel_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("xArgs", this.getLocalizedMessage("arg_xargsossdel_desc"), "x", 1, false, true, null, false, false);
        try {
            if (this.strOsServer != null) {
                System.out.println(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"dash_o_not_supported"));
                osCommandParser.printUsage();
                throw new OsServerMgrCliHelpException(null);
            }
            osCommandParser.addOption((CommandOption)commandLineOption);
            osCommandParser.addOption((CommandOption)this.coHelp);
            osCommandParser.addOption((CommandOption)this.coOsServer);
            if (osCommandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    vector = commandLineOption.getValues();
                    osServiceData = this.parseXOssDeleteOptions(vector, osServiceData);
                    this.trace("XArgs=" + vector);
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    osCommandParser.printUsage();
                    throw new OsServerMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = osCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 2) {
                String string = "";
                int n = 0;
                while (n < stringArray2.length - 2) {
                    string = String.valueOf(string) + stringArray2[n] + " ";
                    ++n;
                }
                throw new OsServerMgrCliArgParsingException("EXM_BAD_ARGS", string);
            }
            this.vObjs.addElement(osServiceData);
        }
        catch (OsServerMgrCliHelpException osServerMgrCliHelpException) {
            throw osServerMgrCliHelpException;
        }
        catch (OsServerMgrCliArgParsingException osServerMgrCliArgParsingException) {
            osCommandParser.printUsage(osServerMgrCliArgParsingException.getLocalizedMessage());
            throw osServerMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("doh!\t Throwable type-of-exception");
            throw new OsServerMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForOssViewOptions(String[] stringArray) throws Exception {
        OsServiceData osServiceData = new OsServiceData();
        OsCommandParser osCommandParser = new OsCommandParser("oss_ls", this.getLocalizedMessage("smossls_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("machinereadable", this.getLocalizedMessage("arg_machinereadable_desc"), "v", 0, true, false, (Object)"", false, false);
        try {
            if (this.strOsServer != null) {
                System.out.println(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"dash_o_not_supported"));
                osCommandParser.printUsage();
                throw new OsServerMgrCliHelpException(null);
            }
            osCommandParser.addOption((CommandOption)this.coHelp);
            osCommandParser.addOption((CommandOption)this.coOsServer);
            osCommandParser.addOption((CommandOption)commandLineOption);
            if (osCommandParser.parseArgs(stringArray)) {
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    osCommandParser.printUsage();
                    throw new OsServerMgrCliHelpException(null);
                }
                if (commandLineOption.wasSet()) {
                    this.bMachineReadable = true;
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = osCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 2) {
                String string = "";
                int n = 0;
                while (n < stringArray2.length - 2) {
                    string = String.valueOf(string) + stringArray2[n] + " ";
                    ++n;
                }
                throw new OsServerMgrCliArgParsingException("EXM_BAD_ARGS", string);
            }
            this.vObjs.addElement(osServiceData);
        }
        catch (OsServerMgrCliHelpException osServerMgrCliHelpException) {
            throw osServerMgrCliHelpException;
        }
        catch (OsServerMgrCliArgParsingException osServerMgrCliArgParsingException) {
            osCommandParser.printUsage(osServerMgrCliArgParsingException.getLocalizedMessage());
            throw osServerMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("doh!\t Throwable type-of-exception");
            throw new OsServerMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForPatchOptions(String[] stringArray) throws Exception {
        boolean bl = false;
        OsCommandParser osCommandParser = new OsCommandParser("oss_patch", this.getLocalizedMessage("smpatch_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("patchdir", this.getLocalizedMessage("arg_patchdir_desc"), "a", 1, true, false, (Object)"", false, false);
        CommandLineOption commandLineOption2 = new CommandLineOption("rmpatchid", this.getLocalizedMessage("arg_rmpatchid_desc"), "r", 1, true, false, (Object)"", false, false);
        CommandLineOption commandLineOption3 = new CommandLineOption("listspooled", this.getLocalizedMessage("arg_listspooled_desc"), "P", 0, true, false, (Object)"", false, false);
        CommandLineOption commandLineOption4 = new CommandLineOption("synchspooled", this.getLocalizedMessage("arg_syncspooled_desc"), "m", 0, true, false, (Object)"", false, false);
        CommandLineOption commandLineOption5 = new CommandLineOption("updateclient", this.getLocalizedMessage("arg_updateclient_desc"), "U", 0, true, false, (Object)"", false, false);
        try {
            if (this.strOsServer != null) {
                System.out.println(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"dash_o_not_supported"));
                osCommandParser.printUsage();
                throw new OsServerMgrCliHelpException(null);
            }
            osCommandParser.addOption((CommandOption)this.coHelp);
            osCommandParser.addOption((CommandOption)commandLineOption);
            osCommandParser.addOption((CommandOption)commandLineOption2);
            osCommandParser.addOption((CommandOption)commandLineOption3);
            osCommandParser.addOption((CommandOption)commandLineOption4);
            osCommandParser.addOption((CommandOption)commandLineOption5);
            osCommandParser.addOption((CommandOption)this.coOsServer);
            if (osCommandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    this.strPatchDirectory = (String)commandLineOption.getValue();
                    bl = true;
                }
                if (commandLineOption2.wasSet()) {
                    this.strRemovePatch = (String)commandLineOption2.getValue();
                    bl = true;
                }
                if (commandLineOption4.wasSet()) {
                    this.bSyncSpooledPatches = true;
                    bl = true;
                }
                if (commandLineOption5.wasSet()) {
                    this.bUpdateClient = true;
                    bl = true;
                }
                if (commandLineOption3.wasSet()) {
                    if (this.bUpdateClient || this.bSyncSpooledPatches || this.strRemovePatch != null || this.strPatchDirectory != null) {
                        osCommandParser.printUsage();
                        throw new OsServerMgrCliHelpException(null);
                    }
                    this.bListSpooledPatches = true;
                    bl = true;
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    osCommandParser.printUsage();
                    throw new OsServerMgrCliHelpException(null);
                }
                if (!bl) {
                    osCommandParser.printUsage();
                    throw new OsServerMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = osCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 2) {
                String string = "";
                int n = 0;
                while (n < stringArray2.length - 2) {
                    string = String.valueOf(string) + stringArray2[n] + " ";
                    ++n;
                }
                throw new OsServerMgrCliArgParsingException("EXM_BAD_ARGS", string);
            }
        }
        catch (OsServerMgrCliHelpException osServerMgrCliHelpException) {
            throw osServerMgrCliHelpException;
        }
        catch (OsServerMgrCliArgParsingException osServerMgrCliArgParsingException) {
            osCommandParser.printUsage(osServerMgrCliArgParsingException.getLocalizedMessage());
            throw osServerMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("doh!\t Throwable type-of-exception");
            throw new OsServerMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    public void dcAdd() throws AdminException {
        DisklessClientData disklessClientData = null;
        if (this.vObjs.size() == 0) {
            throw new OsServerMgrException("EXM_INTERNAL", "dcAdd1");
        }
        try {
            disklessClientData = (DisklessClientData)this.vObjs.elementAt(0);
        }
        catch (Exception exception) {
            throw new OsServerMgrException("EXM_INTERNAL", "dcAdd2");
        }
        if (this.isSameServer()) {
            disklessClientData.setTypeOfUpdate(TYPE_OF_UPDATE_ALL);
            if (this.getOsServerServiceWrapper() == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "dcAdd5");
            }
            this.getOsServerServiceWrapper().addDisklessClient(disklessClientData);
        } else {
            disklessClientData.setTypeOfUpdate(TYPE_OF_UPDATE_FILESYSTEM);
            if (this.getOsServerServiceWrapper() == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "dcAdd4");
            }
            this.getOsServerServiceWrapper().addDisklessClient(disklessClientData);
            String string = this.getOsServerServiceWrapper().getBestNetIf(disklessClientData);
            String string2 = disklessClientData.getFileServer();
            if ((string == null || string.length() == 0) && string2 == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "dcAdd_mhfs1");
            }
            disklessClientData.setFileServer(string);
            disklessClientData.setTypeOfUpdate(TYPE_OF_UPDATE_DATABASE);
            if (this.getNameServerServiceWrapper() == null) {
                disklessClientData.setFileServer(string2);
                throw new OsServerMgrException("EXM_INTERNAL", "dcAdd3");
            }
            this.getNameServerServiceWrapper().addDisklessClient(disklessClientData);
            disklessClientData.setFileServer(string2);
        }
    }

    public void dcDelete() throws AdminException {
        DisklessClientData disklessClientData = null;
        if (this.vObjs.size() == 0) {
            throw new OsServerMgrException("EXM_INTERNAL", "dcDelete1");
        }
        int n = 0;
        while (n < this.vObjs.size()) {
            try {
                disklessClientData = (DisklessClientData)this.vObjs.elementAt(n);
            }
            catch (Exception exception) {
                throw new OsServerMgrException("EXM_INTERNAL", "dcDelete2");
            }
            if (this.isSameServer()) {
                disklessClientData.setTypeOfUpdate(TYPE_OF_UPDATE_ALL);
                if (this.getOsServerServiceWrapper() == null) {
                    throw new OsServerMgrException("EXM_INTERNAL", "dcDelete5");
                }
                this.getOsServerServiceWrapper().deleteDisklessClient(disklessClientData);
            } else {
                disklessClientData.setTypeOfUpdate(TYPE_OF_UPDATE_FILESYSTEM);
                if (this.getOsServerServiceWrapper() == null) {
                    throw new OsServerMgrException("EXM_INTERNAL", "dcDelete3");
                }
                this.getOsServerServiceWrapper().deleteDisklessClient(disklessClientData);
                disklessClientData.setTypeOfUpdate(TYPE_OF_UPDATE_DATABASE);
                if (this.getNameServerServiceWrapper() == null) {
                    throw new OsServerMgrException("EXM_INTERNAL", "dcDelete4");
                }
                this.getNameServerServiceWrapper().deleteDisklessClient(disklessClientData);
            }
            ++n;
        }
    }

    public void dcModify() throws AdminException {
        DisklessClientData disklessClientData = null;
        DisklessClientData disklessClientData2 = null;
        if (this.vObjs.size() < 2) {
            throw new OsServerMgrException("EXM_INTERNAL", "dcMod1");
        }
        try {
            disklessClientData = (DisklessClientData)this.vObjs.elementAt(0);
            disklessClientData2 = (DisklessClientData)this.vObjs.elementAt(1);
        }
        catch (Exception exception) {
            throw new OsServerMgrException("EXM_INTERNAL", "dcMod2");
        }
        if (this.getNameServerServiceWrapper() == null) {
            throw new OsServerMgrException("EXM_INTERNAL", "dcMod3");
        }
        this.getNameServerServiceWrapper().modifyDisklessClient(disklessClientData, disklessClientData2);
    }

    public void dcView() throws AdminException {
        Vector vector = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (this.bMachineReadable) {
            string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"client_prop");
            string4 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"root_prop");
            string5 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"swap_prop");
            string6 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"dump_prop");
            vector = this.getNameServerServiceWrapper().getAllDisklessClients();
            if (vector == null || vector.size() == 0) {
                return;
            }
            int n = 0;
            while (n < vector.size()) {
                DisklessClientData disklessClientData = (DisklessClientData)vector.elementAt(n);
                System.out.println(String.valueOf(string3) + "=" + disklessClientData.getHostName());
                System.out.println(String.valueOf(string4) + "=" + disklessClientData.getRoot());
                System.out.println(String.valueOf(string5) + "=" + disklessClientData.getSwap());
                System.out.println(String.valueOf(string6) + "=" + disklessClientData.getDump());
                System.out.println();
                ++n;
            }
        } else {
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"diskless_client_header1");
            System.out.println(string2);
            string2 = String.valueOf(this.padToSize("", 16)) + ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"diskless_client_header2");
            System.out.println(string2);
            string2 = String.valueOf(this.padToSize("", 16)) + ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"diskless_client_header3");
            System.out.println(string2);
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"diskless_client_header4");
            System.out.println(string2);
            vector = this.getNameServerServiceWrapper().getAllDisklessClients();
            if (vector == null || vector.size() == 0) {
                return;
            }
            int n = 0;
            while (n < vector.size()) {
                DisklessClientData disklessClientData = (DisklessClientData)vector.elementAt(n);
                string = String.valueOf(this.padToSize(disklessClientData.getHostName(), 16)) + this.padToSize(disklessClientData.getRoot(), 54);
                System.out.println(string);
                string = String.valueOf(this.padToSize("", 16)) + this.padToSize(disklessClientData.getSwap(), 54);
                System.out.println(string);
                string = String.valueOf(this.padToSize("", 16)) + this.padToSize(disklessClientData.getDump(), 54);
                System.out.println(string);
                ++n;
            }
        }
    }

    public void destroy() {
    }

    private void doFirstArgPass(String[] stringArray) throws Exception {
        block8: {
            this.trace("parseMyArgs->args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
            OsCommandParser osCommandParser = new OsCommandParser("OsServerMgrCli", "Command line tool for manipulating jobs", true, null, null, this.getResourceBundle());
            try {
                osCommandParser.addOption((CommandOption)this.coTask);
                osCommandParser.addOption((CommandOption)this.coOsServer);
                osCommandParser.addOption((CommandOption)this.coHelp);
                if (osCommandParser.parseArgs(stringArray)) {
                    if (this.coTask.wasSet()) {
                        String string = (String)this.coTask.getValue();
                        this.trace("Task = " + string);
                        this.setTaskOperation(string);
                    }
                    if (this.coOsServer.wasSet()) {
                        this.strOsServer = (String)this.coOsServer.getValue();
                        this.trace("Os Server = " + this.strOsServer);
                    }
                } else {
                    this.trace("Error parsing args");
                    throw new OsServerMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
                }
                this.coHelp.wasSet();
                if (this.getOperation() == -1) {
                    this.trace("Error:  iOperation == -1");
                    throw new OsServerMgrException("EXM_CLI_NO_TASK");
                }
            }
            catch (Throwable throwable) {
                this.trace("Throwable type-of-exception");
                if (!this.getDebugStatus()) break block8;
                throwable.printStackTrace();
            }
        }
    }

    public void doOperation() throws AdminException {
        switch (this.iOperation) {
            case 0: {
                this.dcAdd();
                break;
            }
            case 1: {
                this.dcDelete();
                break;
            }
            case 2: {
                this.dcModify();
                break;
            }
            case 3: {
                this.dcView();
                break;
            }
            case 4: {
                this.ossAdd();
                break;
            }
            case 5: {
                this.ossDelete();
                break;
            }
            case 6: {
                this.ossView();
                break;
            }
            case 7: {
                this.patch();
                break;
            }
        }
    }

    private Vector fileToVectorOfStrings(String string) throws OsServerMgrCliHelpException {
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string), 8192);
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                vector.add(string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            System.out.println(this.getLocalizedMessage("sysidcfg_file_error"));
            throw new OsServerMgrCliHelpException("EXM_INTERNAL", "fileToVectorOfStrings");
        }
        return vector;
    }

    public boolean getDebugStatus() {
        return this.bDebug;
    }

    public String getLocalizedMessage(String string) {
        return ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)string);
    }

    public ServiceWrapper getNameServerServiceWrapper() {
        return this.nameServerServiceWrapper;
    }

    public int getOperation() {
        return this.iOperation;
    }

    public ServiceWrapper getOsServerServiceWrapper() {
        return this.osServerServiceWrapper;
    }

    private String getPassword() {
        String string = "";
        String string2 = "";
        string2 = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"password_prompt");
        System.out.print(string2);
        string = SecureReader.readLine((InputStream)System.in);
        System.out.println();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public VConsoleProperties getProperties() {
        return this.properties;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public VScopeNode getScopeNode() {
        return null;
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.infrastructure = toolInfrastructure;
        AdminCommonTools.CMN_TraceOpen((int)2, (String)"stdout");
    }

    private void initCommandLineOptions() {
        this.coTask = new CommandLineOption("task", this.getLocalizedMessage("arg_task_desc"), "K", 1, false, false, (Object)"", false, true);
        this.coOsServer = new CommandLineOption("os server", this.getLocalizedMessage("arg_os_server_desc"), "o", 1, true, false, (Object)"", false, false);
        this.coHelp = new CommandLineOption("help", this.getLocalizedMessage("arg_help_desc"), "h", 0, true, false, (Object)"", false);
        this.coHelp.setPriority(true);
    }

    public boolean isSameServer() {
        return this.nameServerServiceWrapper == this.osServerServiceWrapper;
    }

    public void ossAdd() throws AdminException {
        OsServiceData osServiceData = null;
        if (this.vObjs.size() == 0) {
            throw new OsServerMgrException("EXM_INTERNAL", "ossAdd1");
        }
        try {
            osServiceData = (OsServiceData)this.vObjs.elementAt(0);
        }
        catch (Exception exception) {
            throw new OsServerMgrException("EXM_INTERNAL", "ossAdd2");
        }
        if (this.isSameServer()) {
            osServiceData.setTypeOfUpdate(TYPE_OF_UPDATE_ALL);
            if (this.getOsServerServiceWrapper() == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "ossAdd3");
            }
            this.getOsServerServiceWrapper().addOsService(osServiceData);
        } else {
            osServiceData.setTypeOfUpdate(TYPE_OF_UPDATE_FILESYSTEM);
            if (this.getOsServerServiceWrapper() == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "ossAdd3");
            }
            this.getOsServerServiceWrapper().addOsService(osServiceData);
            osServiceData.setTypeOfUpdate(TYPE_OF_UPDATE_DATABASE);
            if (this.getNameServerServiceWrapper() == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "ossAdd3");
            }
            this.getNameServerServiceWrapper().addOsService(osServiceData);
        }
    }

    public void ossDelete() throws AdminException {
        OsServiceData osServiceData = null;
        if (this.vObjs.size() == 0) {
            throw new OsServerMgrException("EXM_INTERNAL", "ossDelete1");
        }
        int n = 0;
        while (n < this.vObjs.size()) {
            try {
                osServiceData = (OsServiceData)this.vObjs.elementAt(n);
            }
            catch (Exception exception) {
                throw new OsServerMgrException("EXM_INTERNAL", "ossDelete2");
            }
            osServiceData.setTypeOfUpdate(TYPE_OF_UPDATE_FILESYSTEM);
            if (this.getOsServerServiceWrapper() == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "ossDelete3");
            }
            this.getOsServerServiceWrapper().deleteOsService(osServiceData);
            ++n;
        }
    }

    public void ossView() throws AdminException {
        Vector vector = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.bMachineReadable) {
            vector = this.getNameServerServiceWrapper().getAllOsServices();
            if (vector == null || vector.size() == 0) {
                return;
            }
            string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"platform_prop");
            int n = 0;
            while (n < vector.size()) {
                OsServiceData osServiceData = (OsServiceData)vector.elementAt(n);
                System.out.println(String.valueOf(string3) + "=" + osServiceData.getPlatform());
                System.out.println();
                ++n;
            }
        } else {
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"os_service_header1");
            System.out.println(string2);
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"os_service_header2");
            System.out.println(string2);
            vector = this.getNameServerServiceWrapper().getAllOsServices();
            if (vector == null || vector.size() == 0) {
                return;
            }
            int n = 0;
            while (n < vector.size()) {
                OsServiceData osServiceData = (OsServiceData)vector.elementAt(n);
                string = this.padToSize(osServiceData.getPlatform(), 80);
                System.out.println(string);
                ++n;
            }
        }
    }

    private String padToSize(String string, int n) {
        String string2 = "";
        if (string != null) {
            string2 = string;
        }
        int n2 = string2.length();
        String string3 = null;
        if (n2 > n) {
            string3 = string2.substring(0, n);
        } else if (n2 < n) {
            string3 = string2;
            int n3 = 0;
            while (n3 < n - n2) {
                string3 = String.valueOf(string3) + " ";
                ++n3;
            }
        } else {
            string3 = string2;
        }
        return string3;
    }

    private void parseAndValidateArgs(String[] stringArray) throws Exception {
        boolean bl = false;
        switch (this.getOperation()) {
            case 0: {
                this.checkForDcAddOptions(stringArray);
                break;
            }
            case 1: {
                this.checkForDcDeleteOptions(stringArray);
                break;
            }
            case 2: {
                this.checkForDcModifyOptions(stringArray);
                break;
            }
            case 3: {
                this.checkForDcViewOptions(stringArray);
                break;
            }
            case 4: {
                this.checkForOssAddOptions(stringArray);
                break;
            }
            case 6: {
                this.checkForOssViewOptions(stringArray);
                break;
            }
            case 5: {
                this.checkForOssDeleteOptions(stringArray);
                break;
            }
            case 7: {
                this.checkForPatchOptions(stringArray);
                break;
            }
            default: {
                this.trace("should never be here:  xxxx");
                this.trace("couldn't recognize switch:  " + this.getOperation());
                break;
            }
        }
    }

    public DisklessClientData parseXDcAddOptions(Vector vector, DisklessClientData disklessClientData) throws OsServerMgrCliArgParsingException, OsServerMgrCliHelpException {
        int n = 0;
        String string = null;
        Object var5_5 = null;
        String string2 = null;
        this.trace("in parseXDcAddOptions()");
        if (disklessClientData == null) {
            this.trace("obj = null");
            disklessClientData = new DisklessClientData();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = (string = string.trim()).indexOf("=");
            if (n == -1) {
                throw new OsServerMgrCliArgParsingException("EXM_CLI_UNKNOWN_X_ARG", string);
            }
            string2 = string.substring(n + 1, string.length());
            string2 = string2.trim();
            string = string.substring(0, n);
            this.trace("Parsed out x property:  " + string);
            this.trace("Parsed out x property value:\t " + string2);
            if (string.compareTo(this.getLocalizedMessage("xprop_os")) == 0) {
                disklessClientData.setOs(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_root")) == 0) {
                disklessClientData.setRoot(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_swap")) == 0) {
                disklessClientData.setSwap(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_swapsize")) == 0) {
                disklessClientData.setSwapSize(this.validateSize(string2, "swapsize"));
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_dump")) == 0) {
                disklessClientData.setDump(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_dumpsize")) == 0) {
                disklessClientData.setDumpSize(this.validateSize(string2, "dumpsize"));
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_tz")) == 0) {
                disklessClientData.setTimeZone(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_ns")) == 0) {
                disklessClientData.setNameService(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_nameserver")) == 0) {
                disklessClientData.setNameServer(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_nameserver_ipaddress")) == 0) {
                disklessClientData.setNameServerIpAddress(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_netmask")) == 0) {
                disklessClientData.setNetmask(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_sysidcfg")) == 0) {
                disklessClientData.setSysidcfg(this.fileToVectorOfStrings(string2));
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_security_policy")) == 0) {
                disklessClientData.setSecurityPolicy(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_terminal")) == 0) {
                disklessClientData.setTerminal(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_locale")) == 0) {
                disklessClientData.setLocale(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_pw")) == 0) {
                if (string2.compareTo("Y") == 0) {
                    disklessClientData.setPw(true);
                    disklessClientData.setPassword(this.getPassword());
                    continue;
                }
                throw new OsServerMgrCliArgParsingException("EXM_CLI_UNKNOWN_X_ARG", String.valueOf(string) + "=" + string2);
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_passwd")) == 0) {
                disklessClientData.setPassword(string2);
                continue;
            }
            this.trace("unrecognized: x property value:\t" + string2);
            this.trace("unrecognized: x property:  " + string);
            throw new OsServerMgrCliArgParsingException("EXM_CLI_UNKNOWN_X_ARG", string);
        }
        return disklessClientData;
    }

    public DisklessClientData parseXDcModifyOptions(Vector vector, DisklessClientData disklessClientData) throws OsServerMgrCliArgParsingException {
        int n = 0;
        String string = null;
        Object var5_5 = null;
        String string2 = null;
        this.trace("in parseXDcModifyOptions()");
        if (disklessClientData == null) {
            this.trace("obj = null");
            disklessClientData = new DisklessClientData();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = (string = string.trim()).indexOf("=");
            if (n == -1) {
                throw new OsServerMgrCliArgParsingException("EXM_CLI_UNKNOWN_X_ARG", string);
            }
            string2 = string.substring(n + 1, string.length());
            string2 = string2.trim();
            string = string.substring(0, n);
            this.trace("Parsed out x property:  " + string);
            this.trace("Parsed out x property value:\t " + string2);
            if (string.compareTo(this.getLocalizedMessage("xprop_tz")) == 0) {
                disklessClientData.setTimeZone(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_terminal")) == 0) {
                disklessClientData.setTerminal(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_passwd")) == 0) {
                disklessClientData.setPassword(string2);
                continue;
            }
            this.trace("unrecognized: x property value:\t" + string2);
            this.trace("unrecognized: x property:  " + string);
            throw new OsServerMgrCliArgParsingException("EXM_CLI_UNKNOWN_X_ARG", string);
        }
        return disklessClientData;
    }

    public OsServiceData parseXOssAddOptions(Vector vector, OsServiceData osServiceData) throws OsServerMgrCliArgParsingException {
        int n = 0;
        String string = null;
        Object var5_5 = null;
        String string2 = null;
        this.trace("in parseXOssAddOptions()");
        if (osServiceData == null) {
            this.trace("obj = null");
            osServiceData = new OsServiceData();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = (string = string.trim()).indexOf("=");
            if (n == -1) {
                throw new OsServerMgrCliArgParsingException("EXM_CLI_UNKNOWN_X_ARG", string);
            }
            string2 = string.substring(n + 1, string.length());
            string2 = string2.trim();
            string = string.substring(0, n);
            this.trace("Parsed out x property:  " + string);
            this.trace("Parsed out x property value:\t " + string2);
            if (string.compareTo(this.getLocalizedMessage("xprop_mediapath")) == 0) {
                osServiceData.setMediaPath(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_platform")) == 0) {
                osServiceData.setPlatform(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_cluster")) == 0) {
                osServiceData.setCluster(string2);
                continue;
            }
            if (string.compareTo(this.getLocalizedMessage("xprop_locale")) == 0) {
                osServiceData.setLocale(string2);
                continue;
            }
            this.trace("unrecognized: x property value:\t" + string2);
            this.trace("unrecognized: x property:  " + string);
            throw new OsServerMgrCliArgParsingException("EXM_CLI_UNKNOWN_X_ARG", string);
        }
        return osServiceData;
    }

    public OsServiceData parseXOssDeleteOptions(Vector vector, OsServiceData osServiceData) throws OsServerMgrCliArgParsingException {
        int n = 0;
        String string = null;
        Object var5_5 = null;
        String string2 = null;
        this.trace("in parseXOssDeleteOptions()");
        if (osServiceData == null) {
            this.trace("obj = null");
            osServiceData = new OsServiceData();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = (string = string.trim()).indexOf("=");
            if (n == -1) {
                throw new OsServerMgrCliArgParsingException("EXM_CLI_UNKNOWN_X_ARG", string);
            }
            string2 = string.substring(n + 1, string.length());
            string2 = string2.trim();
            string = string.substring(0, n);
            this.trace("Parsed out x property:  " + string);
            this.trace("Parsed out x property value:\t " + string2);
            if (string.compareTo(this.getLocalizedMessage("xprop_rmplatform")) == 0) {
                osServiceData.setPlatform(string2);
                continue;
            }
            this.trace("unrecognized: x property value:\t" + string2);
            this.trace("unrecognized: x property:  " + string);
            throw new OsServerMgrCliArgParsingException("EXM_CLI_UNKNOWN_X_ARG", string);
        }
        return osServiceData;
    }

    public void patch() throws AdminException {
        if (this.bListSpooledPatches) {
            int n;
            Vector vector = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            if (this.getNameServerServiceWrapper() == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "patch4");
            }
            vector = this.getNameServerServiceWrapper().listSpooledPatches();
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"patch_header1");
            System.out.println(string2);
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"patch_header2");
            System.out.println(string2);
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"patch_header3");
            System.out.println(string2);
            if (vector != null) {
                n = 0;
                while (n < vector.size()) {
                    string = String.valueOf(this.padToSize((String)vector.elementAt(n), 8)) + this.padToSize((String)vector.elementAt(n + 1), 8) + this.padToSize((String)vector.elementAt(n + 2), 12) + this.padToSize((String)vector.elementAt(n + 3), 52);
                    System.out.println(string);
                    n += 4;
                }
            }
            System.out.println("");
            string3 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"patch_update_pending");
            vector = this.getNameServerServiceWrapper().listServicesAndPatches();
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"patch_header4");
            System.out.println(string2);
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"patch_header5");
            System.out.println(string2);
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"patch_header6");
            System.out.println(string2);
            if (vector != null) {
                n = 0;
                while (n < vector.size()) {
                    if (((String)vector.elementAt(n)).startsWith("SERVICE=")) {
                        string = ((String)vector.elementAt(n)).substring(8);
                        string = this.padToSize(string, 40);
                    } else if (((String)vector.elementAt(n)).startsWith("SERVICE_UPDATE_PENDING=")) {
                        string = ((String)vector.elementAt(n)).substring(23);
                        string = this.padToSize(String.valueOf(string) + " " + string3, 40);
                    } else {
                        string = String.valueOf(this.padToSize("", 40)) + this.padToSize((String)vector.elementAt(n), 40);
                    }
                    System.out.println(string);
                    ++n;
                }
            }
            System.out.println("");
            vector = this.getNameServerServiceWrapper().listClonesAndPatches();
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"patch_header7");
            System.out.println(string2);
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"patch_header8");
            System.out.println(string2);
            string2 = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"patch_header9");
            System.out.println(string2);
            if (vector != null) {
                n = 0;
                while (n < vector.size()) {
                    if (((String)vector.elementAt(n)).startsWith("CLONE=")) {
                        string = ((String)vector.elementAt(n)).substring(6);
                        string = this.padToSize(string, 40);
                    } else if (((String)vector.elementAt(n)).startsWith("CLONE_UPDATE_PENDING=")) {
                        string = ((String)vector.elementAt(n)).substring(21);
                        string = this.padToSize(String.valueOf(string) + " " + string3, 40);
                    } else {
                        string = String.valueOf(this.padToSize("", 40)) + this.padToSize((String)vector.elementAt(n), 40);
                    }
                    System.out.println(string);
                    ++n;
                }
            }
            return;
        }
        if (this.strPatchDirectory != null) {
            if (this.getNameServerServiceWrapper() == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "patch1");
            }
            this.getNameServerServiceWrapper().addPatch(this.strPatchDirectory);
        }
        if (this.strRemovePatch != null) {
            if (this.getNameServerServiceWrapper() == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "patch2");
            }
            this.getNameServerServiceWrapper().removePatch(this.strRemovePatch);
        }
        if (this.bSyncSpooledPatches) {
            if (this.getNameServerServiceWrapper() == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "patch4");
            }
            this.getNameServerServiceWrapper().synchronizeSpooledPatches();
        }
        if (this.bUpdateClient) {
            if (this.getNameServerServiceWrapper() == null) {
                throw new OsServerMgrException("EXM_INTERNAL", "patch6");
            }
            this.getNameServerServiceWrapper().updateClients();
        }
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        String[] stringArray2 = new String[]{};
        int n = 0;
        AdminMgmtScope adminMgmtScope = null;
        if (stringArray == null) {
            this.trace("runCommandLine->args = null");
            return 1;
        }
        try {
            adminMgmtScope = (AdminMgmtScope)this.toolContext.getParameter("ToolContext.MGMTSCOPE");
            this.nameServer = adminMgmtScope.getMgmtServerName();
            this.nameServerType = adminMgmtScope.getMgmtScopeType();
            this.nameServerApplicationContext = new ApplicationContext(this, this.toolContext, adminMgmtScope);
            this.trace("calling initCommandLineOptions");
            this.initCommandLineOptions();
            this.trace("calling doFirstArgPass");
            this.doFirstArgPass(stringArray);
            this.initCommandLineOptions();
            this.trace("calling parseAndValidateArgs");
            this.parseAndValidateArgs(stringArray);
        }
        catch (OsServerMgrCliHelpException osServerMgrCliHelpException) {
            this.trace("got OsServerMgrCliHelpException in runCommandLine");
            return 0;
        }
        catch (OsServerMgrCliArgParsingException osServerMgrCliArgParsingException) {
            return 1;
        }
        catch (Exception exception) {
            return 2;
        }
        try {
            this.nameServerServiceWrapper = this.nameServerApplicationContext.getServiceWrapper(this.infrastructure);
        }
        catch (Exception exception) {
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            System.out.println(exception.getLocalizedMessage());
            return 2;
        }
        if (this.strOsServer == null) {
            this.osServerApplicationContext = this.nameServerApplicationContext;
            this.osServerServiceWrapper = this.nameServerServiceWrapper;
        } else if (this.strOsServer.compareTo(adminMgmtScope.getMgmtServerName()) == 0) {
            this.osServerApplicationContext = this.nameServerApplicationContext;
            this.osServerServiceWrapper = this.nameServerServiceWrapper;
        } else {
            AdminMgmtScope adminMgmtScope2 = null;
            try {
                adminMgmtScope2 = new AdminMgmtScope("file", "osserverscope", this.strOsServer, this.strOsServer);
            }
            catch (VException vException) {
                System.out.println(vException.getLocalizedMessage());
                return 2;
            }
            this.osServerApplicationContext = new ApplicationContext(this, this.toolContext, adminMgmtScope2);
            try {
                this.osServerServiceWrapper = this.osServerApplicationContext.getServiceWrapper(this.infrastructure);
            }
            catch (Exception exception) {
                if (this.getDebugStatus()) {
                    exception.printStackTrace();
                }
                System.out.println(exception.getLocalizedMessage());
                return 2;
            }
        }
        try {
            this.validateOsServerOption(this.strOsServer, adminMgmtScope);
        }
        catch (OsServerMgrException osServerMgrException) {
            System.out.println(osServerMgrException.getLocalizedMessage());
            return 2;
        }
        try {
            this.doOperation();
        }
        catch (OsServerMgrException osServerMgrException) {
            this.trace("runCommandLine, OsServerMgrException:  " + osServerMgrException.getLocalizedMessage());
            System.out.println(osServerMgrException.getLocalizedMessage());
            n = 2;
        }
        catch (AdminException adminException) {
            this.trace("runCommandLine, AdminException:  " + adminException.getLocalizedMessage());
            System.out.println(adminException.getLocalizedMessage());
            n = 2;
        }
        catch (Exception exception) {
            this.trace("runCommandLine, Exception:  " + exception.getLocalizedMessage());
            System.out.println(exception.getLocalizedMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            n = 2;
        }
        return n;
    }

    public void setDebugStatus(boolean bl) {
        this.bDebug = bl;
    }

    public void setOperation(int n) {
        this.iOperation = n;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.trace("OsServerMgrCli.setProperties");
        this.properties = vConsoleProperties;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setTaskOperation(String string) {
        if (string.compareTo("DA") == 0) {
            this.iOperation = 0;
            this.trace("Action: Add a diskless client");
            return;
        }
        if (string.compareTo("DX") == 0) {
            this.iOperation = 1;
            this.trace("Action: Delete a diskless client");
            return;
        }
        if (string.compareTo("DM") == 0) {
            this.iOperation = 2;
            this.trace("Action: Modify a diskless client");
            return;
        }
        if (string.compareTo("DV") == 0) {
            this.iOperation = 3;
            this.trace("Action: View diskless clients");
            return;
        }
        if (string.compareTo("OA") == 0) {
            this.iOperation = 4;
            this.trace("Action: Add an os service");
            return;
        }
        if (string.compareTo("OX") == 0) {
            this.iOperation = 5;
            this.trace("Action: Delete an os service");
            return;
        }
        if (string.compareTo("OV") == 0) {
            this.iOperation = 6;
            this.trace("Action: View os services");
            return;
        }
        if (string.compareTo("P") == 0) {
            this.iOperation = 7;
            this.trace("Action: Patch an os service");
            return;
        }
        this.trace("Action: UNKNOWN");
    }

    public void setToolContext(ToolContext toolContext) {
        this.toolContext = toolContext;
    }

    public void start() {
        this.bRunning = true;
    }

    public void stop() {
        this.bRunning = false;
    }

    public void trace(String string) {
        if (this.getDebugStatus()) {
            System.out.println(string);
        }
    }

    private void validateOsServerOption(String string, AdminMgmtScope adminMgmtScope) throws OsServerMgrException {
        String string2 = adminMgmtScope.getMgmtServerName();
        String string3 = adminMgmtScope.getMgmtScopeType();
        this.trace("validateOsServerOption: " + string + " " + string2 + " " + string3);
        if (string != null && string.trim().length() != 0 && string3.compareTo("file") == 0 && string.compareTo(string2) != 0) {
            throw new OsServerMgrException("EXM_CLI_BAD_OSSERVER", string);
        }
    }

    private int validateSize(String string, String string2) throws OsServerMgrCliArgParsingException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new OsServerMgrCliArgParsingException("EXM_CLI_BAD_SIZE_FORMAT", string, string2);
        }
        if (n <= 0 || n > 999) {
            throw new OsServerMgrCliArgParsingException("EXM_CLI_BAD_SIZE", string, string2);
        }
        return n;
    }

    private class OsCommandParser
    extends CommandParser {
        private String prefix = null;
        private ResourceBundle resourceBundle = null;

        public OsCommandParser(String string, String string2, boolean bl, InputStream inputStream, PrintStream printStream, ResourceBundle resourceBundle) {
            super(string, string2, bl, inputStream, printStream);
            this.prefix = string;
            this.resourceBundle = resourceBundle;
        }

        public void printUsage() {
            this.printUsage(null);
        }

        public void printUsage(String string) {
            int n = 1;
            String string2 = null;
            String string3 = null;
            if (string != null) {
                this.outStream.println(CommandParser.getMessage((String)"Error: {0}", (Object[])new String[]{string}));
            }
            string2 = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"usage_header");
            this.outStream.println(string2);
            while ((string2 = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)(string3 = String.valueOf(this.prefix) + "_usage_" + n))).compareTo(string3) != 0) {
                this.outStream.println(string2);
                ++n;
            }
        }
    }
}

