/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.VUserMgr;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class UserTable
extends JTable {
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private JTable userTable;
    private JScrollPane scrollPane;
    private Vector vUsers = new Vector();
    private DataTableModel model;
    private static final int N_COLS = 3;

    public UserTable(VUserMgr vUserMgr) {
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.userTable = this;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.userTable.setLayout(gridBagLayout);
        this.model = new DataTableModel();
        this.userTable.setModel(this.model);
        this.userTable.setBackground(Color.white);
        this.userTable.setShowGrid(false);
        this.userTable.setAutoResizeMode(4);
        this.userTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tableColumnModel = this.userTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setHeaderValue(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_user_name"));
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setHeaderValue(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_full_name"));
        tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setHeaderValue(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_user_desc"));
    }

    public void addUser(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.vUsers.addElement(stringArray);
        this.model.fireTableDataChanged();
    }

    public String getDescription(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[2];
    }

    public String getFullName(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[1];
    }

    public String[] getUser(String string) {
        int n = 0;
        while (n < this.getRowCount()) {
            String[] stringArray = this.getUserRow(n);
            if (string.equals(this.getUserName(stringArray))) {
                return stringArray;
            }
            ++n;
        }
        return null;
    }

    public String getUserName(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public String[] getUserRow(int n) {
        if (this.vUsers == null || this.vUsers.size() == 0) {
            return null;
        }
        return (String[])this.vUsers.elementAt(n);
    }

    public JTable getUserTable() {
        return this.userTable;
    }

    public Object[][] getUsers() {
        if (this.userTable.getRowCount() == 0) {
            return null;
        }
        Object[][] objectArray = new Object[3][this.userTable.getRowCount()];
        int n = 0;
        while (n < this.userTable.getRowCount()) {
            String[] stringArray = this.getUserRow(n);
            objectArray[0][n] = this.getUserName(stringArray);
            objectArray[1][n] = this.getFullName(stringArray);
            objectArray[2][n] = this.getDescription(stringArray);
            ++n;
        }
        return objectArray;
    }

    public Vector getVUsers() {
        return this.vUsers;
    }

    public void removeUser(int n) {
        if (n > this.getRowCount()) {
            return;
        }
        this.vUsers.removeElementAt(n);
        this.model.fireTableDataChanged();
    }

    class DataTableModel
    extends AbstractTableModel {
        DataTableModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return UserTable.this.vUsers.size();
        }

        public Object getValueAt(int n, int n2) {
            if (UserTable.this.vUsers == null || UserTable.this.vUsers.size() == 0) {
                return null;
            }
            if (n >= this.getRowCount() || n2 >= this.getColumnCount()) {
                return null;
            }
            String[] stringArray = UserTable.this.getUserRow(n);
            if (stringArray == null) {
                return null;
            }
            return stringArray[n2];
        }
    }
}

