/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.DblTreeNode;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelPanel;
import com.sun.admin.cis.common.sort.Compare;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.common.UserAttrObj;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SolRoleProps
extends UMgrPropsPanel {
    public static SelPanel rolePanel;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private GenInfoPanel infoPanel;
    private UserObj uObj;
    private static DblTreeNode srcRoot;
    private static DblTreeNode dstRoot;
    private DefaultTreeModel srcModel;
    private DefaultTreeModel dstModel;
    private DblTreeNode[] roleNodes;
    private RoleTreeNode[] roleTreeNodes;
    private boolean isRoleListOK = true;

    public SolRoleProps(VUserMgr vUserMgr, UserObj userObj, GenInfoPanel genInfoPanel) {
        this.theApp = vUserMgr;
        this.uObj = userObj;
        this.bundle = vUserMgr.getResourceBundle();
        this.infoPanel = genInfoPanel;
        this.createGui(userObj);
        Vector vector = new Vector(5);
        UMgrContextHelpListener uMgrContextHelpListener = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprop_roles_assign");
        this.focusListener = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprop_roles");
        Thread thread = new Thread(){

            public void run() {
                try {
                    ContextHelpListener.loadHelp((ContextHelpListener)((UMgrContextHelpListener)((Object)SolRoleProps.this.getFocusListener())));
                }
                catch (Exception exception) {}
            }
        };
        thread.start();
        this.loadRoleTrees();
    }

    private void createGui(UserObj userObj) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        rolePanel = new SelPanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"sol_role_props_avail"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"sol_role_props_assigned"));
        SolRoleProps.rolePanel.srcTree.setCellRenderer(new RoleRenderer(this));
        SolRoleProps.rolePanel.dstTree.setCellRenderer(new RoleRenderer(this));
        Constraints.constrain((Container)this, (Component)rolePanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (int)10, (int)10, (int)10, (int)10);
    }

    private void loadRoleTrees() {
        UserAttrObj userAttrObj;
        int n;
        String string;
        boolean bl;
        int n2;
        Object object;
        String[] stringArray;
        Object object2;
        Vector vector = null;
        try {
            vector = this.theApp.getUserMgr().getAllRoles();
        }
        catch (AdminException adminException) {
            this.isRoleListOK = false;
            this.theApp.reportErrorException((Exception)((Object)adminException));
            return;
        }
        this.srcModel = (DefaultTreeModel)SolRoleProps.rolePanel.srcTree.getModel();
        srcRoot = (DblTreeNode)this.srcModel.getRoot();
        this.dstModel = (DefaultTreeModel)SolRoleProps.rolePanel.dstTree.getModel();
        dstRoot = (DblTreeNode)this.dstModel.getRoot();
        this.roleNodes = new DblTreeNode[vector.size()];
        this.roleTreeNodes = new RoleTreeNode[vector.size()];
        int n3 = 0;
        Object var3_4 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (UserObj)enumeration.nextElement();
            stringArray = ((UserObj)object2).getUserName();
            this.roleTreeNodes[n3] = new RoleTreeNode((UserObj)object2);
            ++n3;
        }
        if (this.roleTreeNodes.length > 1) {
            object2 = new NodeCompare();
            Sort.sort((Object[])this.roleTreeNodes, (Compare)object2);
        }
        int n4 = 0;
        while (n4 < this.roleTreeNodes.length) {
            this.roleNodes[n4] = new DblTreeNode((Object)this.roleTreeNodes[n4]);
            this.srcModel.insertNodeInto((MutableTreeNode)this.roleNodes[n4], (MutableTreeNode)srcRoot, n4);
            stringArray = new TreePath(this.roleNodes[n4].getPath());
            SolRoleProps.rolePanel.srcTree.scrollPathToVisible((TreePath)stringArray);
            ++n4;
        }
        if (!this.theApp.getUserMgr().hasRoleMgrAssignAuth()) {
            if (this.theApp.getUserMgr().hasRoleMgrDelegateAuth()) {
                stringArray = null;
                object = this.theApp.getAuthenticatedUser();
                if (this.theApp.isRoleAssumed()) {
                    stringArray = new String[]{object};
                } else {
                    stringArray = this.theApp.getAdminRoleCache();
                    if (stringArray == null) {
                        try {
                            stringArray = this.theApp.getUserMgr().getUserRoles((String)object);
                            this.theApp.setAdminRoleCache(stringArray);
                        }
                        catch (AdminException adminException) {
                            this.theApp.reportErrorException((Exception)((Object)adminException));
                            return;
                        }
                    }
                }
                n2 = 0;
                while (n2 < this.roleNodes.length) {
                    bl = false;
                    string = this.roleNodes[n2].toString();
                    n = 0;
                    while (n < stringArray.length) {
                        if (string.equals(stringArray[n])) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (bl) {
                        this.roleNodes[n2].setEnabled(true);
                    } else {
                        this.roleNodes[n2].setEnabled(false);
                    }
                    ++n2;
                }
            } else {
                int n5 = 0;
                while (n5 < this.roleNodes.length) {
                    this.roleNodes[n5].setEnabled(false);
                    ++n5;
                }
            }
        }
        if ((userAttrObj = this.uObj.getSolAuthAttrs()) == null) {
            userAttrObj = new UserAttrObj();
        }
        if ((object = userAttrObj.getRoleNames()) == null) {
            return;
        }
        n2 = 0;
        while (n2 < this.roleNodes.length) {
            bl = false;
            string = this.roleNodes[n2].toString();
            n = 0;
            while (n < ((String[])object).length) {
                if (string.equals(object[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                rolePanel.initLeaf(SolRoleProps.rolePanel.srcTree, SolRoleProps.rolePanel.dstTree, this.roleNodes[n2]);
            }
            ++n2;
        }
    }

    public UserObj updateSolRoleProps(UserObj userObj) {
        UserAttrObj userAttrObj;
        if (!this.isRoleListOK) {
            return userObj;
        }
        Vector<String> vector = new Vector<String>();
        DblTreeNode dblTreeNode = (DblTreeNode)this.dstModel.getRoot();
        Enumeration<TreeNode> enumeration = dblTreeNode.children();
        while (enumeration.hasMoreElements()) {
            userAttrObj = (DblTreeNode)enumeration.nextElement();
            vector.addElement(((DefaultMutableTreeNode)((Object)userAttrObj)).toString());
        }
        userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj();
        }
        userAttrObj.setRoleNamesVector(vector);
        userObj.setSolAuthAttrs(userAttrObj);
        return userObj;
    }

    class RoleTreeNode {
        String name;
        UserObj roleObj = null;
        ContextHelpListener help = null;

        public RoleTreeNode(UserObj userObj) {
            this.roleObj = userObj;
            this.name = userObj.getUserName();
        }

        public ContextHelpListener getContextHelp() {
            return this.help;
        }

        public UserObj getRoleObj() {
            return this.roleObj;
        }

        public void setContextHelp(ContextHelpListener contextHelpListener) {
            this.help = contextHelpListener;
        }

        public String toString() {
            return this.name;
        }
    }

    class NodeCompare
    implements Compare {
        NodeCompare() {
        }

        public final int doCompare(Object object, Object object2) {
            RoleTreeNode roleTreeNode = (RoleTreeNode)object;
            RoleTreeNode roleTreeNode2 = (RoleTreeNode)object2;
            String string = roleTreeNode.toString();
            String string2 = roleTreeNode2.toString();
            return string.compareTo(string2);
        }
    }

    class RoleRenderer
    extends DefaultTreeCellRenderer {
        private boolean selected;
        SolRoleProps rightSubProps;

        public RoleRenderer(SolRoleProps solRoleProps2) {
            this.rightSubProps = solRoleProps2;
            this.setClosedIcon(null);
            this.setOpenIcon(null);
            this.setLeafIcon(null);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.selected = bl;
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)jTree.getCellRenderer();
            defaultTreeCellRenderer.setLeafIcon(null);
            DblTreeNode dblTreeNode = (DblTreeNode)object;
            if (dblTreeNode.getParent() == null) {
                this.setText(dblTreeNode.toString());
                this.setForeground(SystemColor.textText);
            } else if (dblTreeNode.getUserObject() instanceof RoleTreeNode) {
                RoleTreeNode roleTreeNode = (RoleTreeNode)dblTreeNode.getUserObject();
                this.setText(roleTreeNode.toString());
                if (bl) {
                    if (dblTreeNode.isEnabled()) {
                        defaultTreeCellRenderer.setTextSelectionColor(SystemColor.textText);
                    } else {
                        defaultTreeCellRenderer.setTextSelectionColor(SystemColor.inactiveCaptionText);
                    }
                } else if (dblTreeNode.isEnabled()) {
                    defaultTreeCellRenderer.setTextNonSelectionColor(SystemColor.textText);
                } else {
                    defaultTreeCellRenderer.setTextNonSelectionColor(SystemColor.inactiveCaptionText);
                }
            }
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            return this;
        }
    }
}

