/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.usermgr.client.AppData;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.ServiceWrapper;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.rbac.ConfDelRightPanel;
import com.sun.admin.usermgr.client.rbac.RightPropsDlg;
import com.sun.admin.usermgr.client.rbac.UMgrRightMenuBar;
import com.sun.admin.usermgr.client.rbac.UMgrRightTBar;
import com.sun.admin.usermgr.common.RightObj;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class RightContent
extends Content {
    private static String[][] columnHeaders = null;
    private ResourceBundle bundle;
    private ImageIcon smallRightIcon;
    private ImageIcon largeRightIcon;
    private UMgrRightMenuBar rightMenuBar;
    private UMgrRightTBar rightToolBar;
    private RightContent rightContent;
    private VUserMgr theApp;

    public RightContent(VUserMgr vUserMgr) {
        super(vUserMgr);
        this.theApp = vUserMgr;
        this.rightContent = this;
        this.bundle = vUserMgr.getResourceBundle();
        this.sortPreferencesKey = String.valueOf(this.getClass().getName()) + ".sortPreferences";
        this.rightMenuBar = new UMgrRightMenuBar(vUserMgr, this);
        this.rightToolBar = new UMgrRightTBar(vUserMgr, this);
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.rightMenuBar);
        this.rootNode.setToolBar((JToolBar)this.rightToolBar);
        this.smallRightIcon = vUserMgr.loadImageIcon("rights_16.gif", "");
        this.largeRightIcon = vUserMgr.loadImageIcon("rights_32.gif", "");
    }

    public void appendToResultsPane(Vector vector) {
        RightObj rightObj;
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        String string = ResourceManager.getLocalizedTextFile((String)"html/rights.html", this.theApp.getClass());
        int n = 0;
        while (n < vector.size()) {
            rightObj = (RightObj)vector.elementAt(n);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.rightMenuBar.getPopupMenu(), this.smallRightIcon, this.largeRightIcon, rightObj.getRightName(), null, null, -1, (Object)rightObj);
            vScopeNode.setHTMLText(string);
            vScopeNode.setDescription(rightObj.getRightDescription());
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(rightObj);
            ++n;
        }
        rightObj = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.getTreeNode());
        this.theApp.fireConsoleAction((VConsoleEvent)rightObj);
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.rightMenuBar);
        this.rootNode.setToolBar((JToolBar)this.rightToolBar);
        this.getTreeNode().setInternalRoot(this.rootNode);
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    public void createProperties() {
        Thread thread = new Thread(){

            public void run() {
                RightContent.this.theApp.waitOn();
                RightPropsDlg rightPropsDlg = new RightPropsDlg(RightContent.this.theApp, RightContent.this.theApp.getFrame(), null, true);
                RightContent.this.theApp.setRightListCache(null);
                ((Dialog)((Object)rightPropsDlg)).show();
                RightContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void deleteSelected() {
        ConfDelRightPanel confDelRightPanel = new ConfDelRightPanel(this.theApp);
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_right"));
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < vector.size()) {
                    try {
                        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(n);
                        RightObj rightObj = (RightObj)vScopeNode.getPayload();
                        RightContent.this.theApp.getUserMgr().deleteRight(rightObj);
                        RightContent.this.theApp.setRightListCache(null);
                        RightContent.this.removeFromResultsPane(rightObj);
                    }
                    catch (AdminException adminException) {
                        RightContent.this.theApp.reportErrorException((Exception)((Object)adminException));
                    }
                    ++n;
                }
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), string, (JPanel)confDelRightPanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_delete"));
    }

    public String[][] getColumnHeaders() {
        Object[][] objectArray = new Object[][]{{ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_templ_desc"), new Integer(32)}};
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    private int getDisplayChunkSize() {
        return 0;
    }

    protected ListProperties getListProperties() {
        return null;
    }

    public UMgrRightMenuBar getMenuBar() {
        return this.rightMenuBar;
    }

    private int getServerChunkSize() {
        return 0;
    }

    public UMgrRightTBar getToolBar() {
        return this.rightToolBar;
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public void refresh() {
        this.theApp.setAuthListCache(null);
        this.theApp.setProfListCache(null);
        this.theApp.setAdminAuthCache(null);
        this.theApp.setAdminProfCache(null);
        this.theApp.setRightListCache(null);
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear(false);
        this.theApp.setStatusBar("");
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                if (vector == null) {
                    RightContent.this.theApp.waitOff();
                    return;
                }
                RightContent.this.updateStatusBar();
                RightContent.this.appendToResultsPane(vector);
            }

            public synchronized void errorException(Exception exception) {
                RightContent.this.theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        ((Thread)((Object)myListFetch)).start();
        this.bRefresh = true;
    }

    private void removeFromResultsPane(RightObj rightObj) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            RightObj rightObj2 = (RightObj)vScopeNode.getPayload();
            if (rightObj2 == rightObj) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
                this.theApp.fireConsoleAction(vConsoleEvent);
                break;
            }
            ++n;
        }
    }

    public void renameSelected() {
    }

    protected void setListProperties(ListProperties listProperties) {
    }

    public void updateStatusBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"RightListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setStatusBar(string2);
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                RightContent.this.theApp.waitOn();
                Vector vector = RightContent.this.getSelected();
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                RightObj rightObj = (RightObj)vScopeNode.getPayload();
                RightPropsDlg rightPropsDlg = new RightPropsDlg(RightContent.this.theApp, RightContent.this.theApp.getFrame(), rightObj, false);
                ((Component)((Object)rightPropsDlg)).setVisible(true);
                RightContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public String whatAmI() {
        return ResourceStrings.getString((ResourceBundle)this.bundle, (String)"rights");
    }

    private class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper userMgr;
        AppData appData = null;

        public MyListFetch(int n, int n2) {
            super(n, n2);
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)RightContent.this.bundle, (String)"rights");
        }

        public Vector listAll() throws AdminException {
            Vector vector = null;
            try {
                vector = RightContent.this.theApp.getUserMgr().getRightProfs();
                RightContent.this.theApp.setRightListCache(vector);
            }
            catch (Exception exception) {
                RightContent.this.theApp.reportErrorException(exception);
            }
            if (vector == null) {
                return new Vector();
            }
            return vector;
        }
    }
}

