/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viperimpl.util.TaskQueue;
import com.sun.management.viperimpl.util.TimerTask;
import com.sun.management.viperimpl.util.TimerThread;
import java.util.Date;

public class Timer {
    private TaskQueue queue = new TaskQueue();
    private TimerThread thread = new TimerThread(this.queue);
    private Object threadReaper = new Object(){

        protected void finalize() throws Throwable {
            TaskQueue taskQueue = Timer.this.queue;
            synchronized (taskQueue) {
                ((Timer)Timer.this).thread.newTasksMayBeScheduled = false;
                Timer.this.queue.notify();
            }
        }
    };

    public Timer() {
        this.thread.start();
    }

    public Timer(boolean bl) {
        this.thread.setDaemon(bl);
        this.thread.start();
    }

    public void cancel() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.thread.newTasksMayBeScheduled = false;
            this.queue.clear();
            this.queue.notify();
        }
    }

    private void sched(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            if (!this.thread.newTasksMayBeScheduled) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            Object object = timerTask.lock;
            synchronized (object) {
                if (timerTask.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                timerTask.nextExecutionTime = l;
                timerTask.period = l2;
                timerTask.state = 1;
            }
            this.queue.add(timerTask);
            if (this.queue.getMin() == timerTask) {
                this.queue.notify();
            }
        }
    }

    public void schedule(TimerTask timerTask, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l, 0L);
    }

    public void schedule(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l, -l2);
    }

    public void schedule(TimerTask timerTask, Date date) {
        this.sched(timerTask, date.getTime(), 0L);
    }

    public void schedule(TimerTask timerTask, Date date, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, date.getTime(), -l);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l, l2);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, Date date, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, date.getTime(), l);
    }
}

