/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.config.FolderNode;
import com.sun.management.viperimpl.console.config.ToolBoxNode;
import com.sun.management.viperimpl.console.config.ToolBoxURLNode;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VBaseNode;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class listtool {
    private static CommandOption listOption = new CommandOption("list", "List Legacy Tools", "l", 0, true, false, null, false);
    private static CommandOption fileinOption = new CommandOption("in-file", "Input file", "f", 1, false, false, null, false);

    protected static String indent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + "|  ";
            ++n2;
        }
        return string;
    }

    protected static void listConfiguration(String string) {
        VBaseConfiguration vBaseConfiguration = null;
        try {
            try {
                vBaseConfiguration = VBaseConfiguration.createConfiguration(new URL(string), true);
            }
            catch (MalformedURLException malformedURLException) {
                vBaseConfiguration = VBaseConfiguration.createConfiguration(new File(string).toURL(), true);
            }
            VBaseNode vBaseNode = (VBaseNode)vBaseConfiguration.getRootNode();
            if (vBaseNode == null) {
                return;
            }
            listtool.printTree(vBaseNode, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed((boolean)false);
        CommandParser commandParser = new CommandParser("listtool", "Tool to list legacy tools", true, System.in, System.out);
        commandParser.addOption(fileinOption);
        commandParser.addOption(listOption);
        if (!commandParser.parseArgs(stringArray)) {
            System.out.println("Failed to parse args");
            System.exit(1);
        }
        String string = (String)fileinOption.getValue();
        if (listOption.wasSet()) {
            listtool.listConfiguration(string);
        }
        System.exit(0);
    }

    protected static void printNode(VBaseNode vBaseNode, int n) {
        if (vBaseNode instanceof FolderNode) {
            String string = listtool.indent(n);
            if (string.length() > 3) {
                string = string.substring(0, string.length() - 3);
                string = String.valueOf(string) + "+--";
            } else {
                string = "+--";
            }
            System.out.println(String.valueOf(string) + vBaseNode.getNodeName() + ": " + vBaseNode.getName() + " (scope = " + vBaseNode.getScope() + ")");
        } else if (vBaseNode instanceof ToolNode) {
            String string = listtool.indent(n);
            string = string.substring(0, string.length() - 3);
            String string2 = ((ToolNode)vBaseNode).getClassName();
            if (!string2.equals("LegacyAppTool.client.LaunchLegacyAppTool")) {
                System.out.println(String.valueOf(string) + "+--" + vBaseNode.getNodeName() + " (scope = " + vBaseNode.getScope() + ")");
                System.out.println(String.valueOf(string) + "|\t" + "name  = " + string2);
            } else {
                System.out.println(String.valueOf(string) + "+--" + "Legacy Tool" + " (scope = " + vBaseNode.getScope() + ")");
                Properties properties = ((ToolNode)vBaseNode).getParameters();
                if (properties != null) {
                    System.out.println(String.valueOf(string) + "|\t" + "name    = " + properties.getProperty("Name").trim());
                    System.out.println(String.valueOf(string) + "|\t" + "command = " + properties.getProperty("Command").trim());
                    System.out.println(String.valueOf(string) + "|\t" + "type    = " + properties.getProperty("Type").trim());
                } else {
                    System.out.println(String.valueOf(string) + "|\t" + "No Properties");
                }
            }
        } else if (vBaseNode instanceof ToolBoxURLNode) {
            String string = listtool.indent(n);
            string = string.substring(0, string.length() - 3);
            String string3 = ((ToolBoxURLNode)vBaseNode).getURL().toString().trim();
            System.out.println(String.valueOf(string) + "+--" + vBaseNode.getNodeName() + " (scope = " + vBaseNode.getScope() + ")");
            System.out.println(String.valueOf(string) + "|\t" + "tbxURL = " + string3);
        } else if (vBaseNode instanceof ToolBoxNode) {
            System.out.println(String.valueOf(listtool.indent(n)) + vBaseNode.getNodeName() + ": " + vBaseNode.getName() + " (scope = " + vBaseNode.getScope() + ")");
        }
    }

    protected static void printTree(VBaseNode vBaseNode, int n) {
        System.out.println(listtool.indent(n));
        listtool.printNode(vBaseNode, n);
        Enumeration enumeration = vBaseNode.children();
        while (enumeration != null && enumeration.hasMoreElements()) {
            listtool.printTree((VBaseNode)enumeration.nextElement(), n + 1);
        }
        String string = listtool.indent(n);
        if (string.length() > 3) {
            string = string.substring(0, string.length() - 2);
            if ((string = String.valueOf(string) + "______________________________________________________").length() < 76) {
                int n2 = 76 - string.length();
                int n3 = 0;
                while (n3 < n2) {
                    string = String.valueOf(string) + "_";
                    ++n3;
                }
            }
        }
        System.out.println(string);
    }
}

