/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import opencard.core.util.Tracer;

public class URLClassLoader
extends ClassLoader {
    private Tracer itracer = new Tracer((Object)this, class$opencard$opt$util$URLClassLoader != null ? class$opencard$opt$util$URLClassLoader : (class$opencard$opt$util$URLClassLoader = URLClassLoader.class$("opencard.opt.util.URLClassLoader")));
    protected Hashtable classCache = new Hashtable();
    protected Hashtable byteCache = new Hashtable();
    protected URL url = null;
    protected String archive = null;
    protected boolean archiveLoaded = false;
    static /* synthetic */ Class class$opencard$opt$util$URLClassLoader;

    public URLClassLoader(URL uRL) {
        this.url = uRL;
    }

    public URLClassLoader(URL uRL, String string) {
        this(uRL);
        this.archive = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            byteArrayOutputStream.close();
            throw throwable;
        }
        byteArrayOutputStream.close();
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadArchive(URL uRL, String string) throws ClassNotFoundException {
        ZipInputStream zipInputStream = null;
        try {
            try {
                ZipEntry zipEntry;
                URL uRL2 = new URL(uRL, string);
                InputStream inputStream = uRL2.openStream();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                zipInputStream = new ZipInputStream(bufferedInputStream);
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String string2 = zipEntry.getName();
                    byte[] byArray = this.inputStreamToByteArray(zipInputStream);
                    this.byteCache.put(string2, byArray);
                }
                this.archiveLoaded = true;
            }
            catch (MalformedURLException malformedURLException) {
                throw new ClassNotFoundException(malformedURLException.toString());
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(iOException.toString());
            }
            Object var5_12 = null;
            if (zipInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            if (zipInputStream == null) throw throwable;
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zipInputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        boolean bl2;
        SecurityManager securityManager = System.getSecurityManager();
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 ? string.substring(0, n) : null;
        boolean bl3 = bl2 = securityManager != null && string2 != null;
        if (bl2) {
            securityManager.checkPackageAccess(string2);
        }
        Hashtable hashtable = this.classCache;
        synchronized (hashtable) {
            if (this.classCache.containsKey(string)) {
                return (Class)this.classCache.get(string);
            }
            try {
                Class<?> clazz2 = this.findSystemClass(string);
                this.itracer.debug("loadClass", "Found System Class: " + string);
                this.classCache.put(string, clazz2);
                return clazz2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl2) {
                    securityManager.checkPackageDefinition(string2);
                }
                byte[] byArray = this.loadClassData(string);
                clazz = this.defineClass(string, byArray, 0, byArray.length);
                this.classCache.put(string, clazz);
                this.itracer.debug("loadClass", "Loaded class from URL: " + string);
            }
        }
        if (!bl) return clazz;
        this.resolveClass(clazz);
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized byte[] loadClassData(String string) throws ClassNotFoundException {
        byte[] byArray;
        String string2 = string.replace('.', '/');
        String string3 = String.valueOf(string2) + ".class";
        if (this.archive != null) {
            if (!this.archiveLoaded) {
                this.loadArchive(this.url, this.archive);
            }
            if (!this.byteCache.containsKey(string3)) throw new ClassNotFoundException("archive: " + this.archive + " does not contain:" + string3);
            byte[] byArray2 = (byte[])this.byteCache.get(string3);
            this.byteCache.remove(string3);
            return byArray2;
        }
        BufferedInputStream bufferedInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try {
                URL uRL = new URL(this.url, string3);
                InputStream inputStream = uRL.openStream();
                bufferedInputStream = new BufferedInputStream(inputStream);
                byArray = this.inputStreamToByteArray(bufferedInputStream);
                Object var8_13 = null;
            }
            catch (MalformedURLException malformedURLException) {
                throw new ClassNotFoundException(malformedURLException.toString());
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(iOException.toString());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new ClassNotFoundException(throwable.toString());
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            try {
                if (bufferedInputStream == null) throw throwable;
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        if (bufferedInputStream == null) return byArray;
        bufferedInputStream.close();
        return byArray;
    }
}

