/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.server;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.OCFParameters;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.opt.security.CertificateAlias;
import com.sun.opencard.opt.security.PrivateKeyAlias;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.server.OCFServer;
import com.sun.opencard.service.ocf.OCFService;
import com.sun.opencard.utils.OCFUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import opencard.core.service.CardService;
import opencard.core.service.SmartCard;

public class OCFDispatcher {
    private final String VALIDATE_AND_UNLOCK = "validateAndUnlock";
    private final String AUTHORIZE_METHOD_NAME = "authorize";

    private String createArgs(Class[] classArray, Vector vector, Object[] objectArray, long l) throws Exception {
        int n = 0;
        while (n < classArray.length) {
            block28: {
                Object object;
                Object object2;
                byte[] byArray;
                Class clazz;
                block27: {
                    block26: {
                        clazz = classArray[n];
                        OCFParameters oCFParameters = (OCFParameters)vector.elementAt(n);
                        byArray = oCFParameters.getValue();
                        object2 = null;
                        if (byArray != null) break block26;
                        object2 = oCFParameters.getRawValue();
                        if (object2 != null) break block27;
                        objectArray[n] = null;
                        break block28;
                    }
                    object2 = new String(byArray);
                }
                if (clazz.getName().equals("java.lang.Integer") || clazz.getName().equals("int")) {
                    objectArray[n] = Integer.valueOf((String)object2);
                } else if (clazz.getName().equals("java.lang.Long") || clazz.getName().equals("long")) {
                    objectArray[n] = Long.valueOf((String)object2);
                } else if (clazz.getName().equals("java.lang.Float") || clazz.getName().equals("float")) {
                    objectArray[n] = Float.valueOf((String)object2);
                } else if (clazz.getName().equals("java.lang.String")) {
                    objectArray[n] = ((String)object2).equals("null") ? null : (String)object2;
                } else if (clazz.getName().equals("java.lang.Boolean") || clazz.getName().equals("boolean")) {
                    objectArray[n] = Boolean.valueOf((String)object2);
                } else if (clazz.getName().equals("com.sun.opencard.server.OCFClientHandle")) {
                    object = OCFServer.getClientHandle(Long.parseLong((String)object2));
                    if (object == null || l != 0L && l != ((OCFClientHandle)object).getUID()) {
                        return OCFConstants.OCF_INVALID_CLIENT;
                    }
                    objectArray[n] = object;
                } else if (clazz.getName().equals("com.sun.opencard.server.OCFCardHandle")) {
                    objectArray[n] = OCFServer.getCardHandle(Long.parseLong((String)object2));
                    if (objectArray[n] == null) {
                        return OCFConstants.OCF_INVALID_CARD;
                    }
                } else if (clazz.getName().equals("opencard.core.service.CardService")) {
                    objectArray[n] = (CardService)object2;
                } else if (clazz.getName().equals("[B")) {
                    objectArray[n] = byArray;
                } else if (clazz.getName().equals("opencard.opt.security.PrivateKeyRef")) {
                    objectArray[n] = new PrivateKeyAlias((String)object2);
                } else if (clazz.getName().equals("com.sun.opencard.opt.security.CertificateRef")) {
                    objectArray[n] = new CertificateAlias((String)object2);
                } else if (clazz.getName().equals("java.util.Hashtable")) {
                    object = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                    objectArray[n] = objectInputStream.readObject();
                }
            }
            ++n;
        }
        return null;
    }

    public String dispatchCardService(String string, String string2, long l, Vector vector) {
        SmartCard smartCard = null;
        try {
            OCFClientHandle oCFClientHandle = OCFServer.getClientHandle(Long.parseLong(new String(((OCFParameters)vector.elementAt(0)).getValue())));
            if (oCFClientHandle == null) {
                OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_INVALID_CLIENT, null);
                return oCFReturnValues.getReturnValues();
            }
            OCFCardHandle oCFCardHandle = OCFServer.getCardHandle(Long.parseLong(new String(((OCFParameters)vector.elementAt(1)).getValue())));
            if (oCFCardHandle == null) {
                OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_INVALID_CARD, null);
                return oCFReturnValues.getReturnValues();
            }
            if (!oCFCardHandle.isAccessGranted(oCFClientHandle)) {
                OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_CARD_LOCKED, null);
                return oCFReturnValues.getReturnValues();
            }
            Class clazz = OCFUtils.getClass("INT_" + string, "cardservicelocations");
            Object t = clazz.newInstance();
            Class clazz2 = OCFUtils.getClass(string, "cardservicelocations");
            smartCard = oCFCardHandle.getSmartCard();
            if (smartCard == null) {
                OCFDebug.debugln("OCFDispatcher: card is NULL");
                OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_NOCARD, null);
                return oCFReturnValues.getReturnValues();
            }
            CardService cardService = OCFUtils.getCardService(smartCard, clazz2, oCFCardHandle);
            if (cardService == null) {
                OCFDebug.debugln("OCFDispatcher: cardService is NULL");
                OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SERVICE_NOT_SUPPORTED, null);
                return oCFReturnValues.getReturnValues();
            }
            vector.removeElementAt(0);
            vector.removeElementAt(0);
            vector.insertElementAt(new OCFParameters("Object", cardService, false), 0);
            String string3 = oCFCardHandle.getPin();
            if (string3 == null) {
                string3 = new String("");
            }
            vector.insertElementAt(new OCFParameters("String", string3, false), 1);
            if (!this.isAuthorized(clazz, t, cardService, oCFCardHandle, l)) {
                OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_UNAUTHORIZED_ACCESS, null);
                return oCFReturnValues.getReturnValues();
            }
            String string4 = this.invokeMethod(clazz, t, string2, vector, l);
            string4 = this.doPinProcessing(string2, string4, oCFCardHandle, vector, l);
            smartCard.close();
            OCFDebug.debugln("OCFDispatcher returning:: " + string4);
            return string4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (smartCard != null) {
                    smartCard.close();
                }
            }
            catch (Exception exception2) {
                OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_EXCEPTION, exception2.getMessage());
                return oCFReturnValues.getReturnValues();
            }
            OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_EXCEPTION, exception.getMessage());
            return oCFReturnValues.getReturnValues();
        }
    }

    public String dispatchOCFService(String string, String string2, long l, Vector vector) {
        OCFService oCFService = new OCFService(l);
        return this.invokeMethod(oCFService.getClass(), oCFService, string2, vector, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String doPinProcessing(String string, String string2, OCFCardHandle oCFCardHandle, Vector vector, long l) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        OCFDebug.debugln("doPinProcessing : method : " + string);
        if (!string.equals("validateAndUnlock")) return string2;
        if (string2.indexOf(OCFConstants.OCF_SUCCESS) == -1) return string2;
        OCFParameters oCFParameters = (OCFParameters)vector.elementAt(2);
        String string3 = (String)oCFParameters.getRawValue();
        if (string3 == null) {
            string3 = new String(oCFParameters.getValue());
        }
        OCFDebug.debugln("doPinProcessing setting Pin : " + string3);
        oCFCardHandle.setPin(string3);
        if (l == 0L) return oCFReturnValues.getReturnValues();
        oCFCardHandle.setUID(l);
        return oCFReturnValues.getReturnValues();
    }

    protected String invokeMethod(Class clazz, Object object, String string, Vector vector, long l) {
        Object object2;
        String string2 = null;
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string)) {
                String string3;
                object2 = methodArray[n].getParameterTypes();
                Object[] objectArray = new Object[((Class<?>[])object2).length];
                try {
                    string3 = this.createArgs((Class[])object2, vector, objectArray, l);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_PARAMETER_ERROR, null);
                    return oCFReturnValues.getReturnValues();
                }
                if (string3 != null) {
                    OCFReturnValues oCFReturnValues = new OCFReturnValues(string3, null);
                    return oCFReturnValues.getReturnValues();
                }
                try {
                    string2 = (String)methodArray[n].invoke(object, objectArray);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_EXCEPTION, invocationTargetException.getTargetException().toString());
                    return oCFReturnValues.getReturnValues();
                }
                catch (IllegalAccessException illegalAccessException) {
                    OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_EXCEPTION, illegalAccessException.getMessage());
                    return oCFReturnValues.getReturnValues();
                }
            }
            ++n;
        }
        if (n == methodArray.length) {
            object2 = new OCFReturnValues(OCFConstants.OCF_EXCEPTION, "No such Method Found :: " + string);
            return ((OCFReturnValues)object2).getReturnValues();
        }
        return string2;
    }

    private boolean isAuthorized(Class clazz, Object object, CardService cardService, OCFCardHandle oCFCardHandle, long l) throws Exception {
        OCFDebug.debugln("In isAuthorized");
        Object[] objectArray = new Object[4];
        Boolean bl = new Boolean("false");
        objectArray[0] = cardService;
        objectArray[1] = Long.toString(oCFCardHandle.getUID());
        objectArray[2] = Long.toString(l);
        objectArray[3] = "authorize";
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals("authorize")) {
                bl = (Boolean)methodArray[n].invoke(object, objectArray);
                break;
            }
            ++n;
        }
        if (n == methodArray.length) {
            bl = new Boolean("true");
        }
        return bl;
    }
}

