/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.http;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFParameters;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.http.Handler;
import com.sun.opencard.http.Request;
import com.sun.opencard.http.Server;
import com.sun.opencard.server.OCFDispatcher;
import com.sun.opencard.server.OCFServer;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class OpenCardHandler
implements Handler {
    private Server server;
    private String propsPrefix;
    private String UrlPrefix;
    private static final String PREFIX = "prefix";
    private static OCFDispatcher dispatch = null;
    private static final String DEFAULT_PROP_FILE_LOADER = "com.sun.opencard.utils.OCFPropertyFileLoader";
    private static boolean init = false;

    public OpenCardHandler() {
        this(DEFAULT_PROP_FILE_LOADER);
    }

    public OpenCardHandler(String string) {
        OCFServer oCFServer = new OCFServer();
        System.setProperty("OpenCard.loaderClassName", string);
    }

    public boolean init(Server server, String string) {
        this.server = server;
        this.propsPrefix = string;
        this.UrlPrefix = server.props.getProperty(String.valueOf(this.propsPrefix) + PREFIX, "/");
        return true;
    }

    public static String ocfResponse(long l, String string, String string2) throws IOException {
        Object object;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = "<html><title>Solaris Smart Card Project</title>\n";
        if (string == null || string.equals("") || string.equals("/")) {
            string6 = String.valueOf(string6) + "<body>OCF</body>\n";
            return string6;
        }
        int n = string.indexOf(47, 1);
        string3 = string.substring(1, n);
        int n2 = string.indexOf(47, n + 1);
        if (n2 < 0) {
            string6 = String.valueOf(string6) + "<body>No Card Service Provided</body>\n";
            return string6;
        }
        string4 = string.substring(n + 1, n2);
        if (n2 >= string.length()) {
            string6 = String.valueOf(string6) + "<body>No Card Method Provided</body>\n";
            return string6;
        }
        string5 = string.substring(n2 + 1);
        Vector<OCFParameters> vector = new Vector<OCFParameters>();
        if (string2 != null) {
            object = new StringTokenizer(string2, "&");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string7 = ((StringTokenizer)object).nextToken();
                int n3 = string7.indexOf(61);
                if (n3 == -1) break;
                String string8 = string7.substring(0, n3);
                String string9 = string7.substring(n3 + 1);
                string9 = string9.trim();
                OCFParameters oCFParameters = new OCFParameters(string8, string9, true);
                vector.addElement(oCFParameters);
            }
        }
        string6 = String.valueOf(string6) + "<head>" + string3 + "/" + string4 + "/" + string5 + "</head>\n";
        object = OpenCardHandler.startOCFServer();
        if (((String)object).indexOf(OCFConstants.OCF_SUCCESS) == -1) {
            string6 = String.valueOf(string6) + "<body>" + (String)object + "</body>\n";
            return string6;
        }
        if (string3.equals("OCF")) {
            string6 = String.valueOf(string6) + "<body>" + dispatch.dispatchOCFService(string4, string5, l, vector) + "</body>\n";
        } else if (string3.equals("CardService")) {
            string6 = String.valueOf(string6) + "<body>" + dispatch.dispatchCardService(string4, string5, l, vector) + "</body>\n";
        }
        return string6;
    }

    public static String respond(long l, String string) throws IOException {
        int n = string.indexOf(63);
        int n2 = string.indexOf(47);
        int n3 = string.indexOf("HTTP");
        String string2 = string.substring(n2, n);
        String string3 = string.substring(n + 1, n3);
        return OpenCardHandler.ocfResponse(l, string2, string3);
    }

    public boolean respond(Request request) throws IOException {
        String string = new String(request.url);
        String string2 = new String(request.query);
        String string3 = OpenCardHandler.ocfResponse(0L, string, string2);
        request.sendResponse(string3);
        return true;
    }

    public static String startOCFServer() {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        if (!init) {
            OCFServer oCFServer = new OCFServer();
            try {
                OCFServer.initializeOCF();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                oCFReturnValues.setStatus(OCFConstants.OCF_EXCEPTION);
                oCFReturnValues.setMessage(exception.getMessage());
                return oCFReturnValues.getReturnValues();
            }
            dispatch = new OCFDispatcher();
            init = true;
        }
        return oCFReturnValues.getReturnValues();
    }
}

