/*
 * Decompiled with CFR 0.152.
 */
package tester;

import com.scmmicro.smartos.core.Session;
import com.scmmicro.smartos.core.SessionListener;
import com.scmmicro.smartos.exceptions.CardException;
import com.scmmicro.smartos.physical.Drive;
import com.scmmicro.smartos.util.Buffer;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.math.BigInteger;
import tester.AutomaticTest;
import tester.AutomaticTestListener;
import tester.DriveNameDlg;
import tester.MessageBox;

public class Tester
extends Frame
implements ActionListener,
SessionListener,
AutomaticTestListener {
    protected Session m_rSession;
    protected Drive m_rTestDrive;
    private boolean m_bCardMoveEmulation;
    private AutomaticTest m_rAutomaticTests;
    private boolean m_bAutomaticTestOnAir = false;
    boolean fComponentsAdjusted = false;
    Button m_butNewSession;
    Button m_butClose;
    Panel borderPanel1;
    Button m_butSetParam;
    Button m_butGetParam;
    Choice m_lbParamList;
    Label label1;
    TextField m_tfParamValue;
    Label label2;
    Panel borderPanel2;
    Button m_butReaderCommand;
    Checkbox m_rbDeactivate;
    CheckboxGroup m_grpCmdType;
    Checkbox m_rbReset;
    Checkbox m_rbWarmReset;
    Panel borderPanel3;
    Button m_butCardSend;
    Label label3;
    TextField m_tfSendCommand;
    Button m_butSetDrive;
    TextField m_tfCardResponse;
    Button m_butRunScenario;
    Label label4;

    public Tester() {
        this.setLayout(null);
        ((Component)this).setVisible(false);
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + 540, this.getInsets().top + this.getInsets().bottom + 379);
        ((Component)this).setBackground(new Color(0xC0C0C0));
        this.m_butNewSession = new Button();
        this.m_butNewSession.setActionCommand("button");
        this.m_butNewSession.setLabel("new Session");
        this.m_butNewSession.setBounds(this.getInsets().left + 396, this.getInsets().top + 48, 110, 30);
        this.m_butNewSession.setBackground(new Color(0xC0C0C0));
        this.add(this.m_butNewSession);
        this.m_butNewSession.setEnabled(false);
        this.m_butClose = new Button();
        this.m_butClose.setActionCommand("button");
        this.m_butClose.setLabel("close Session");
        this.m_butClose.setBounds(this.getInsets().left + 396, this.getInsets().top + 84, 110, 30);
        this.m_butClose.setBackground(new Color(0xC0C0C0));
        this.add(this.m_butClose);
        this.m_butClose.setEnabled(false);
        this.borderPanel1 = new Panel();
        this.borderPanel1.setLayout(null);
        this.borderPanel1.setBounds(this.getInsets().left + 12, this.getInsets().top + 12, 336, 144);
        this.add(this.borderPanel1);
        this.m_butSetParam = new Button();
        this.m_butSetParam.setActionCommand("button");
        this.m_butSetParam.setLabel("setParameter");
        this.m_butSetParam.setBounds(12, 12, 109, 30);
        this.m_butSetParam.setBackground(new Color(0xC0C0C0));
        this.borderPanel1.add(this.m_butSetParam);
        this.m_butSetParam.setEnabled(false);
        this.m_butGetParam = new Button();
        this.m_butGetParam.setActionCommand("button");
        this.m_butGetParam.setLabel("getParameter");
        this.m_butGetParam.setBounds(12, 72, 108, 30);
        this.m_butGetParam.setBackground(new Color(0xC0C0C0));
        this.borderPanel1.add(this.m_butGetParam);
        this.m_butGetParam.setEnabled(false);
        this.m_lbParamList = new Choice();
        this.m_lbParamList.addItem("VERSION");
        this.m_lbParamList.addItem("PROTOCOL");
        this.m_lbParamList.addItem("ETULENGTH");
        this.m_lbParamList.addItem("CARDSTATE");
        this.m_lbParamList.addItem("CWT");
        this.m_lbParamList.addItem("DL");
        this.m_lbParamList.addItem("FL");
        this.m_lbParamList.addItem("CGT");
        this.m_lbParamList.addItem("CONV");
        this.m_lbParamList.addItem("PTS");
        this.m_lbParamList.addItem("TS_TIMEOUT");
        this.m_lbParamList.addItem("AUTOLEARN");
        this.m_lbParamList.addItem("EDC");
        this.m_lbParamList.addItem("IFSC");
        this.m_lbParamList.addItem("IFSD");
        this.m_lbParamList.addItem("BGT");
        this.m_lbParamList.addItem("BWT");
        this.m_lbParamList.addItem("NAD");
        this.m_lbParamList.addItem("IFSE");
        this.m_lbParamList.addItem("WTX");
        this.borderPanel1.add(this.m_lbParamList);
        this.m_lbParamList.setBounds(206, 12, 96, 40);
        this.label1 = new Label("identifier :");
        this.label1.setBounds(146, 24, 60, 24);
        this.borderPanel1.add(this.label1);
        this.m_tfParamValue = new TextField();
        this.m_tfParamValue.setBounds(206, 72, 96, 24);
        this.borderPanel1.add(this.m_tfParamValue);
        this.label2 = new Label("Value :");
        this.label2.setBounds(146, 84, 48, 12);
        this.borderPanel1.add(this.label2);
        this.borderPanel2 = new Panel();
        this.borderPanel2.setLayout(null);
        this.borderPanel2.setBounds(this.getInsets().left + 12, this.getInsets().top + 156, 336, 72);
        this.add(this.borderPanel2);
        this.m_butReaderCommand = new Button();
        this.m_butReaderCommand.setActionCommand("button");
        this.m_butReaderCommand.setLabel("readerCommand");
        this.m_butReaderCommand.setBounds(12, 12, 108, 30);
        this.m_butReaderCommand.setBackground(new Color(0xC0C0C0));
        this.borderPanel2.add(this.m_butReaderCommand);
        this.m_butReaderCommand.setEnabled(false);
        this.m_grpCmdType = new CheckboxGroup();
        this.m_rbDeactivate = new Checkbox("Deactivate Contacts", this.m_grpCmdType, true);
        this.m_rbDeactivate.setBounds(146, 0, 144, 20);
        this.borderPanel2.add(this.m_rbDeactivate);
        this.m_rbReset = new Checkbox("Reset", this.m_grpCmdType, false);
        this.m_rbReset.setBounds(146, 24, 60, 20);
        this.borderPanel2.add(this.m_rbReset);
        this.m_rbWarmReset = new Checkbox("Warm Reset", this.m_grpCmdType, false);
        this.m_rbWarmReset.setBounds(146, 48, 144, 20);
        this.borderPanel2.add(this.m_rbWarmReset);
        this.borderPanel3 = new Panel();
        this.borderPanel3.setLayout(null);
        this.borderPanel3.setBounds(this.getInsets().left + 12, this.getInsets().top + 252, 516, 60);
        this.add(this.borderPanel3);
        this.m_butCardSend = new Button();
        this.m_butCardSend.setActionCommand("button");
        this.m_butCardSend.setLabel("cardSend");
        this.m_butCardSend.setBounds(12, 12, 108, 30);
        this.m_butCardSend.setBackground(new Color(0xC0C0C0));
        this.borderPanel3.add(this.m_butCardSend);
        this.m_butCardSend.setEnabled(false);
        this.label3 = new Label("Command :");
        this.label3.setBounds(134, 0, 76, 15);
        this.label3.setFont(new Font("Dialog", 0, 12));
        this.borderPanel3.add(this.label3);
        this.m_tfSendCommand = new TextField();
        this.m_tfSendCommand.setBounds(132, 24, 384, 28);
        this.borderPanel3.add(this.m_tfSendCommand);
        this.m_butSetDrive = new Button();
        this.m_butSetDrive.setActionCommand("button");
        this.m_butSetDrive.setLabel("set Drive ");
        this.m_butSetDrive.setBounds(this.getInsets().left + 396, this.getInsets().top + 12, 110, 30);
        this.m_butSetDrive.setBackground(new Color(0xC0C0C0));
        this.add(this.m_butSetDrive);
        this.m_tfCardResponse = new TextField();
        this.m_tfCardResponse.setBounds(this.getInsets().left + 12, this.getInsets().top + 336, 516, 28);
        this.m_tfCardResponse.setFont(new Font("Dialog", 1, 12));
        this.m_tfCardResponse.setForeground(new Color(255));
        this.add(this.m_tfCardResponse);
        this.m_tfCardResponse.setEnabled(false);
        this.m_butRunScenario = new Button();
        this.m_butRunScenario.setActionCommand("button");
        this.m_butRunScenario.setLabel("run Scenario");
        this.m_butRunScenario.setBounds(this.getInsets().left + 396, this.getInsets().top + 156, 110, 30);
        this.m_butRunScenario.setBackground(new Color(0xC0C0C0));
        this.add(this.m_butRunScenario);
        this.m_butRunScenario.setEnabled(false);
        this.label4 = new Label("Response :");
        this.label4.setBounds(this.getInsets().left + 12, this.getInsets().top + 312, 100, 24);
        this.add(this.label4);
        this.setTitle("Untitled");
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        SymComponent symComponent = new SymComponent();
        this.addComponentListener(symComponent);
        SymMouseMotion symMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(symMouseMotion);
        SymContainer symContainer = new SymContainer();
        this.addContainerListener(symContainer);
        this.m_lbParamList.select(0);
        this.m_butSetDrive.addActionListener(this);
        this.m_butNewSession.addActionListener(this);
        this.m_butCardSend.addActionListener(this);
        this.m_butReaderCommand.addActionListener(this);
        this.m_butClose.addActionListener(this);
        this.m_butGetParam.addActionListener(this);
        this.m_butSetParam.addActionListener(this);
        this.m_butRunScenario.addActionListener(this);
    }

    public Tester(String string) {
        this();
        this.setTitle(string);
    }

    private static String BytesToString(byte[] byArray) {
        String string = "";
        byte[] byArray2 = new byte[2];
        byArray2[0] = 0;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byArray2[1] = byArray[n2];
            BigInteger bigInteger = new BigInteger(byArray2);
            if (byArray[n2] < 16 && byArray[n2] >= 0) {
                string = String.valueOf(string) + "0";
            }
            string = String.valueOf(string) + bigInteger.toString(16);
            ++n2;
        }
        return string;
    }

    void Frame1_WindowClosing(WindowEvent windowEvent) {
        if (this.m_bAutomaticTestOnAir) {
            new MessageBox((Frame)this, "Java SmartOS TestCT", "A scenario is currently running\n Please wait for its end before closing!");
            return;
        }
        ((Component)this).setVisible(false);
        System.exit(0);
    }

    public void TestComplete(boolean bl) {
        this.m_butClose.setEnabled(true);
        this.m_butCardSend.setEnabled(true);
        this.m_butReaderCommand.setEnabled(true);
        this.m_butGetParam.setEnabled(true);
        this.m_butSetParam.setEnabled(true);
        this.m_butRunScenario.setEnabled(true);
        this.m_bAutomaticTestOnAir = false;
        if (bl) {
            this.m_tfCardResponse.setText("scenario complete OK");
        } else {
            this.m_tfCardResponse.setText("scenario complete KO (see log.00x)");
        }
    }

    void Tester_ComponentRemoved(ContainerEvent containerEvent) {
    }

    void Tester_ComponentShown(ComponentEvent componentEvent) {
    }

    void Tester_MouseDrag(MouseEvent mouseEvent) {
    }

    void Tester_MouseMoved(MouseEvent mouseEvent) {
    }

    void Tester_WindowActivate(WindowEvent windowEvent) {
    }

    void Tester_WindowDeactivated(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_butSetDrive) {
            DriveNameDlg driveNameDlg = new DriveNameDlg((Frame)this, true);
            ((Component)driveNameDlg).setVisible(true);
            if (driveNameDlg.getExitStatus()) {
                try {
                    String string = "com.scmmicro.smartos.physical." + driveNameDlg.getDriveName();
                    Class<?> clazz = Class.forName(string);
                    Object obj = clazz.newInstance();
                    this.m_rTestDrive = (Drive)obj;
                    this.m_rTestDrive.setInitializer("name", "type", "/dev/scmi2c0");
                    this.m_tfCardResponse.setText("Select A Session");
                    this.m_butNewSession.setEnabled(true);
                }
                catch (Exception exception) {
                    this.m_tfCardResponse.setText("Error loading com.scmmicro.smartos.physical." + driveNameDlg.getDriveName());
                    this.m_rTestDrive = null;
                    this.m_butNewSession.setEnabled(false);
                    return;
                }
            }
            return;
        }
        if (actionEvent.getSource() == this.m_butNewSession) {
            this.m_tfCardResponse.setText("Loading Session.......");
            this.m_rSession = null;
            try {
                this.m_rSession = new Session(this.m_rTestDrive);
                this.m_rSession.setListener((SessionListener)this);
            }
            catch (Exception exception) {
                this.m_tfCardResponse.setText("Failed to estable a smartOS session");
                return;
            }
            this.m_butNewSession.setEnabled(false);
            this.m_butClose.setEnabled(true);
            this.m_butCardSend.setEnabled(true);
            this.m_butReaderCommand.setEnabled(true);
            this.m_butGetParam.setEnabled(true);
            this.m_butSetParam.setEnabled(true);
            this.m_butSetDrive.setEnabled(false);
            this.m_butRunScenario.setEnabled(true);
            this.m_tfCardResponse.setText("new session OK");
            return;
        }
        if (actionEvent.getSource() == this.m_butCardSend) {
            this.m_tfCardResponse.setText("Sending Card Command......");
            this.cardExchange_();
            return;
        }
        if (actionEvent.getSource() == this.m_butReaderCommand) {
            this.m_tfCardResponse.setText("Sending Reader Command......");
            this.readerExchange_();
            return;
        }
        if (actionEvent.getSource() == this.m_butClose) {
            this.m_butNewSession.setEnabled(true);
            this.m_butClose.setEnabled(false);
            this.m_butCardSend.setEnabled(false);
            this.m_butReaderCommand.setEnabled(false);
            this.m_butGetParam.setEnabled(false);
            this.m_butSetParam.setEnabled(false);
            this.m_butSetDrive.setEnabled(true);
            this.m_butRunScenario.setEnabled(false);
            try {
                this.m_rSession.close();
            }
            catch (Exception exception) {
                this.m_tfCardResponse.setText("ERR COMM");
                return;
            }
            this.m_tfCardResponse.setText("Close session OK");
            this.m_rSession = null;
            System.exit(0);
            return;
        }
        if (actionEvent.getSource() == this.m_butGetParam) {
            this.getParameter_();
            return;
        }
        if (actionEvent.getSource() == this.m_butSetParam) {
            this.setParameter_();
            return;
        }
        if (actionEvent.getSource() == this.m_butRunScenario) {
            this.m_butNewSession.setEnabled(false);
            this.m_butClose.setEnabled(false);
            this.m_butCardSend.setEnabled(false);
            this.m_butReaderCommand.setEnabled(false);
            this.m_butGetParam.setEnabled(false);
            this.m_butSetParam.setEnabled(false);
            this.m_butSetDrive.setEnabled(false);
            this.m_butRunScenario.setEnabled(false);
            FileDialog fileDialog = new FileDialog((Frame)this, "Choose Scenario File", 0);
            fileDialog.setDirectory("c:\\javasos\\output\\Tester\\scenario");
            ((Component)fileDialog).setVisible(true);
            if (fileDialog.getFile() == null) {
                this.m_butClose.setEnabled(true);
                this.m_butCardSend.setEnabled(true);
                this.m_butReaderCommand.setEnabled(true);
                this.m_butGetParam.setEnabled(true);
                this.m_butSetParam.setEnabled(true);
                this.m_butRunScenario.setEnabled(true);
                return;
            }
            String string = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            this.m_rAutomaticTests = new AutomaticTest(this, this.m_rSession);
            this.m_rAutomaticTests.setListener(this);
            try {
                this.m_rAutomaticTests.openScenarioFile(string);
            }
            catch (IOException iOException) {
                this.m_butClose.setEnabled(true);
                this.m_butCardSend.setEnabled(true);
                this.m_butReaderCommand.setEnabled(true);
                this.m_butGetParam.setEnabled(true);
                this.m_butSetParam.setEnabled(true);
                this.m_butRunScenario.setEnabled(true);
                return;
            }
            this.m_rAutomaticTests.start();
            this.m_tfCardResponse.setText("scenario Running");
            this.m_bAutomaticTestOnAir = true;
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + dimension.width, this.getInsets().top + this.getInsets().bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(this.getInsets().left, this.getInsets().top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.fComponentsAdjusted = true;
    }

    private void cardExchange_() {
        String string = this.m_tfSendCommand.getText();
        if (string.equals("")) {
            this.m_tfCardResponse.setText("Invalid Command : Empty");
            return;
        }
        int n = string.length();
        if (n % 2 != 0) {
            this.m_tfCardResponse.setText("Invalid Command Length");
            return;
        }
        byte[] byArray = new byte[n /= 2];
        int n2 = 0;
        while (n2 < n) {
            this.stringtoBytes(string.substring(2 * n2, 2 * n2 + 2), byArray, n2);
            ++n2;
        }
        Buffer buffer = new Buffer(0);
        buffer.setData(byArray);
        Buffer buffer2 = new Buffer(0);
        try {
            this.m_rSession.cardExchange(buffer, buffer2);
        }
        catch (CardException cardException) {
            try {
                if (this.m_rSession.getParameter((byte)4) == 0L) {
                    this.m_tfCardResponse.setText("ERROR : NO CARD");
                    return;
                }
                this.m_tfCardResponse.setText("ERROR PROTOCOL");
            }
            catch (Exception exception) {
                this.m_tfCardResponse.setText("ERROR COMM");
                return;
            }
            return;
        }
        catch (Exception exception) {
            this.m_tfCardResponse.setText(exception.toString());
            return;
        }
        this.m_tfCardResponse.setText(Tester.BytesToString(buffer2.getData()));
    }

    public void cardMovement(byte by) {
        if (by == -96) {
            this.m_tfCardResponse.setText("Card Inserted!");
        } else if (by == -95) {
            this.m_tfCardResponse.setText("Card Removed!");
        } else {
            this.m_tfCardResponse.setText("Card Status Error!");
        }
    }

    private byte getParameterId_() {
        String string = this.m_lbParamList.getSelectedItem();
        if (string.equals("VERSION")) {
            return 0;
        }
        if (string.equals("PROTOCOL")) {
            return 1;
        }
        if (string.equals("ETULENGTH")) {
            return 15;
        }
        if (string.equals("CARDSTATE")) {
            return 4;
        }
        if (string.equals("CWT")) {
            return 5;
        }
        if (string.equals("DL")) {
            return 9;
        }
        if (string.equals("FL")) {
            return 10;
        }
        if (string.equals("CGT")) {
            return 2;
        }
        if (string.equals("CONV")) {
            return 8;
        }
        if (string.equals("PTS")) {
            return 13;
        }
        if (string.equals("TS_TIMEOUT")) {
            return 14;
        }
        if (string.equals("AUTOLEARN")) {
            return 17;
        }
        if (string.equals("EDC")) {
            return 7;
        }
        if (string.equals("IFSC")) {
            return 11;
        }
        if (string.equals("IFSD")) {
            return 12;
        }
        if (string.equals("BGT")) {
            return 3;
        }
        if (string.equals("BWT")) {
            return 6;
        }
        if (string.equals("NAD")) {
            return 18;
        }
        if (string.equals("IFSE")) {
            return 19;
        }
        if (string.equals("WTX")) {
            return 20;
        }
        return -1;
    }

    private void getParameter_() {
        byte by = this.getParameterId_();
        try {
            long l = this.m_rSession.getParameter(by);
            this.m_tfParamValue.setText(Long.toString(l));
        }
        catch (Exception exception) {
            this.m_tfCardResponse.setText("ERR_PARAM");
        }
    }

    public static void main(String[] stringArray) {
        Tester tester = new Tester("Java SmartOS TestCT (Version 1.0 - 01 April 1999)");
        ((Component)tester).setLocation(200, 160);
        ((Component)tester).setVisible(true);
    }

    private void readerExchange_() {
        Buffer buffer = new Buffer(0);
        buffer.setLength(0);
        Buffer buffer2 = new Buffer(0);
        byte by = this.m_grpCmdType.getSelectedCheckbox() == this.m_rbReset ? (byte)0 : (this.m_grpCmdType.getSelectedCheckbox() == this.m_rbWarmReset ? (byte)1 : 2);
        try {
            this.m_rSession.readerExchange(by, buffer, buffer2);
        }
        catch (CardException cardException) {
            try {
                if (this.m_rSession.getParameter((byte)4) == 0L) {
                    this.m_tfCardResponse.setText("NO CARD");
                    return;
                }
                this.m_tfCardResponse.setText("ERROR ATR");
            }
            catch (Exception exception) {
                this.m_tfCardResponse.setText("ERROR COMM");
                return;
            }
            return;
        }
        catch (Exception exception) {
            this.m_tfCardResponse.setText("ERR_COMM");
            return;
        }
        this.m_tfCardResponse.setText(Tester.BytesToString(buffer2.getData()));
    }

    public void scenarError(String string) {
        this.m_butClose.setEnabled(true);
        this.m_butCardSend.setEnabled(true);
        this.m_butReaderCommand.setEnabled(true);
        this.m_butGetParam.setEnabled(true);
        this.m_butSetParam.setEnabled(true);
        this.m_butRunScenario.setEnabled(true);
        this.m_bAutomaticTestOnAir = false;
        this.m_tfCardResponse.setText("error in scenario");
    }

    private void setParameter_() {
        byte by = this.getParameterId_();
        try {
            long l;
            String string = this.m_tfParamValue.getText();
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_tfCardResponse.setText("ERR_PARAM VALUE");
                return;
            }
            this.m_rSession.setParameter(by, l);
        }
        catch (Exception exception) {
            this.m_tfCardResponse.setText("ERR_PARAM");
        }
    }

    private void stringtoBytes(String string, byte[] byArray, int n) {
        BigInteger bigInteger = new BigInteger(string, 16);
        byArray[n] = (byte)bigInteger.intValue();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == Tester.this) {
                Tester.this.Tester_WindowActivate(windowEvent);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == Tester.this) {
                Tester.this.Frame1_WindowClosing(windowEvent);
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == Tester.this) {
                Tester.this.Tester_WindowDeactivated(windowEvent);
            }
        }
    }

    class SymComponent
    extends ComponentAdapter {
        SymComponent() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == Tester.this) {
                Tester.this.Tester_ComponentShown(componentEvent);
            }
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == Tester.this) {
                Tester.this.Tester_MouseDrag(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == Tester.this) {
                Tester.this.Tester_MouseMoved(mouseEvent);
            }
        }
    }

    class SymContainer
    extends ContainerAdapter {
        SymContainer() {
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Object object = containerEvent.getSource();
            if (object == Tester.this) {
                Tester.this.Tester_ComponentRemoved(containerEvent);
            }
        }
    }
}

