/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.data;

import com.sun.dhcpmgr.data.DhcpClientFlagTypes;
import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.ResourceStrings;
import com.sun.dhcpmgr.data.ValidationException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class DhcpClientRecord
implements Serializable,
Comparable,
Cloneable {
    public static final String DEFAULT_CLIENT_ID = new String("00");
    public static final String DEFAULT_FLAGS = new String("00");
    public static final String DEFAULT_CLIENT_NAME = new String();
    public static final String DEFAULT_EXPIRATION = new String("0");
    public static final String DEFAULT_SIGNATURE = new String("0");
    public static final String DEFAULT_MACRO = new String("UNKNOWN");
    public static final String DEFAULT_COMMENT = new String();
    private static final String EXPIRATION_ZERO = new String("0");
    private static final String EXPIRATION_FOREVER = new String("-1");
    private String clientId;
    private byte flags;
    private IPAddress clientIP;
    private IPAddress serverIP;
    private Date expiration;
    private String signature = DEFAULT_SIGNATURE;
    private String macro;
    private String comment;
    private String clientName = null;
    private String serverName = null;

    public DhcpClientRecord() {
        this.clientId = DEFAULT_CLIENT_ID;
        this.comment = null;
        this.macro = null;
        this.flags = 0;
        this.serverIP = null;
        this.clientIP = null;
        this.expiration = null;
        this.signature = DEFAULT_SIGNATURE;
    }

    public DhcpClientRecord(String string) throws ValidationException {
        this.setDefaults();
        this.setClientIP(new IPAddress(string));
    }

    public DhcpClientRecord(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws ValidationException {
        this(string, string2, string3, string4, string5, string6, string7, DEFAULT_SIGNATURE);
    }

    public DhcpClientRecord(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws ValidationException {
        this.setClientId(string);
        this.flags = Byte.parseByte(string2);
        this.setClientIP(new IPAddress(string3));
        this.setServerIP(new IPAddress(string4));
        this.expiration = new Date(Long.parseLong(string5) * 1000L);
        this.macro = string6;
        this.comment = string7;
        this.signature = string8;
    }

    public Object clone() {
        DhcpClientRecord dhcpClientRecord = new DhcpClientRecord();
        dhcpClientRecord.clientId = this.clientId;
        dhcpClientRecord.flags = this.flags;
        if (this.clientIP != null) {
            dhcpClientRecord.clientIP = (IPAddress)this.clientIP.clone();
        }
        if (this.serverIP != null) {
            dhcpClientRecord.serverIP = (IPAddress)this.serverIP.clone();
        }
        if (this.expiration != null) {
            dhcpClientRecord.expiration = (Date)this.expiration.clone();
        }
        dhcpClientRecord.macro = this.macro;
        dhcpClientRecord.comment = this.comment;
        dhcpClientRecord.clientName = this.clientName;
        dhcpClientRecord.serverName = this.serverName;
        dhcpClientRecord.signature = this.signature;
        return dhcpClientRecord;
    }

    public int compareTo(Object object) {
        DhcpClientRecord dhcpClientRecord = (DhcpClientRecord)object;
        return (int)(this.getBinaryAddress() - dhcpClientRecord.getBinaryAddress());
    }

    public long getBinaryAddress() {
        return this.clientIP.getBinaryAddress();
    }

    public IPAddress getClientIP() {
        return this.clientIP;
    }

    public String getClientIPAddress() {
        if (this.clientIP == null) {
            return "";
        }
        return this.clientIP.getHostAddress();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientName() {
        if (this.clientName == null && this.clientIP != null) {
            this.clientName = this.clientIP.getHostName();
        }
        return this.clientName;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public String getExpirationTime() {
        if (this.expiration == null) {
            return null;
        }
        if (this.expiration.getTime() == Long.parseLong(EXPIRATION_FOREVER)) {
            return EXPIRATION_FOREVER;
        }
        return String.valueOf(this.expiration.getTime() / 1000L);
    }

    public String getFlagString() {
        return this.getFlagString(false);
    }

    public String getFlagString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append(this.flags);
            if (this.flags < 10) {
                stringBuffer.insert(0, 0);
            }
        } else if (this.flags == 0) {
            stringBuffer.append(DhcpClientFlagTypes.DYNAMIC.getCharVal());
        } else {
            if (this.isPermanent()) {
                stringBuffer.append(DhcpClientFlagTypes.PERMANENT.getCharVal());
            }
            if (this.isManual()) {
                stringBuffer.append(DhcpClientFlagTypes.MANUAL.getCharVal());
            }
            if (this.isUnusable()) {
                stringBuffer.append(DhcpClientFlagTypes.UNUSABLE.getCharVal());
            }
            if (this.isBootp()) {
                stringBuffer.append(DhcpClientFlagTypes.BOOTP.getCharVal());
            }
        }
        return stringBuffer.toString();
    }

    public byte getFlags() {
        return this.flags;
    }

    public String getMacro() {
        return this.macro;
    }

    public IPAddress getServerIP() {
        return this.serverIP;
    }

    public String getServerIPAddress() {
        if (this.serverIP == null) {
            return "";
        }
        return this.serverIP.getHostAddress();
    }

    public String getServerName() {
        if (this.serverName == null && this.serverIP != null) {
            this.serverName = this.serverIP.getHostName();
        }
        return this.serverName;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isBootp() {
        return DhcpClientFlagTypes.BOOTP.isSet(this.flags);
    }

    public boolean isManual() {
        return DhcpClientFlagTypes.MANUAL.isSet(this.flags);
    }

    public boolean isPermanent() {
        return DhcpClientFlagTypes.PERMANENT.isSet(this.flags);
    }

    public boolean isUnusable() {
        return DhcpClientFlagTypes.UNUSABLE.isSet(this.flags);
    }

    public void setBootp(boolean bl) {
        this.flags = bl ? (byte)(this.flags | DhcpClientFlagTypes.BOOTP.getNumericVal()) : (byte)(this.flags & ~DhcpClientFlagTypes.BOOTP.getNumericVal());
    }

    public void setClientIP(IPAddress iPAddress) throws ValidationException {
        if (iPAddress == null) {
            String string = ResourceStrings.getString("dcr_invalid_null_clientip");
            throw new ValidationException(string);
        }
        this.clientIP = iPAddress;
    }

    public void setClientIP(String string) throws ValidationException {
        if (string == null) {
            String string2 = ResourceStrings.getString("dcr_invalid_null_clientip");
            throw new ValidationException(string2);
        }
        try {
            this.setClientIP(new IPAddress(string));
        }
        catch (Throwable throwable) {
            String string3 = ResourceStrings.getString("dcr_invalid_clientip");
            throw new ValidationException(string3);
        }
    }

    public void setClientId(String string) throws ValidationException {
        if (string.length() > 128 || string.length() % 2 != 0) {
            String string2 = ResourceStrings.getString("dcr_invalid_clientid");
            throw new ValidationException(string2);
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (!(cArray[n] >= '0' && cArray[n] <= '9' || cArray[n] >= 'A' && cArray[n] <= 'F')) {
                String string3 = ResourceStrings.getString("dcr_invalid_clientid");
                throw new ValidationException(string3);
            }
            ++n;
        }
        this.clientId = string;
        if (this.clientId.length() == 0) {
            this.clientId = DEFAULT_CLIENT_ID;
        }
    }

    public void setClientName(String string) {
        this.clientName = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setDefaults() throws ValidationException {
        this.setClientId(DEFAULT_CLIENT_ID);
        this.setFlags(DEFAULT_FLAGS);
        this.setClientName(DEFAULT_CLIENT_NAME);
        this.setExpiration(DEFAULT_EXPIRATION);
        this.setMacro(DEFAULT_MACRO);
        this.setComment(DEFAULT_COMMENT);
    }

    public void setExpiration(String string) {
        this.expiration = new Date(Long.parseLong(string) * 1000L);
    }

    public void setExpiration(String string, String string2) throws ValidationException {
        if (string2 == null) {
            this.setExpiration(string2);
        } else if (string2.equals(EXPIRATION_ZERO)) {
            this.setExpiration(string2);
        } else if (string2.equals(EXPIRATION_FOREVER)) {
            this.setExpiration(string2);
        } else {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                this.expiration = simpleDateFormat.parse(string2);
            }
            catch (Exception exception) {
                String string3 = ResourceStrings.getString("dcr_invalid_expiration");
                throw new ValidationException(string3);
            }
        }
    }

    public void setExpiration(Date date) {
        this.expiration = date;
    }

    public void setFlags(byte by) {
        this.flags = by;
    }

    public void setFlags(String string) throws ValidationException {
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            this.flags = Byte.parseByte(string);
        } else {
            this.flags = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase(DhcpClientFlagTypes.DYNAMIC.getKeyword())) continue;
                if (string2.equalsIgnoreCase(DhcpClientFlagTypes.PERMANENT.getKeyword())) {
                    this.flags = (byte)(this.flags | DhcpClientFlagTypes.PERMANENT.getNumericVal());
                    continue;
                }
                if (string2.equalsIgnoreCase(DhcpClientFlagTypes.MANUAL.getKeyword())) {
                    this.flags = (byte)(this.flags | DhcpClientFlagTypes.MANUAL.getNumericVal());
                    continue;
                }
                if (string2.equalsIgnoreCase(DhcpClientFlagTypes.UNUSABLE.getKeyword())) {
                    this.flags = (byte)(this.flags | DhcpClientFlagTypes.UNUSABLE.getNumericVal());
                    continue;
                }
                if (string2.equalsIgnoreCase(DhcpClientFlagTypes.BOOTP.getKeyword())) {
                    this.flags = (byte)(this.flags | DhcpClientFlagTypes.BOOTP.getNumericVal());
                    continue;
                }
                String string3 = ResourceStrings.getString("dcr_invalid_flags");
                throw new ValidationException(string3);
            }
        }
    }

    public void setMacro(String string) {
        this.macro = string;
    }

    public void setManual(boolean bl) {
        this.flags = bl ? (byte)(this.flags | DhcpClientFlagTypes.MANUAL.getNumericVal()) : (byte)(this.flags & ~DhcpClientFlagTypes.MANUAL.getNumericVal());
    }

    public void setPermanent(boolean bl) {
        this.flags = bl ? (byte)(this.flags | DhcpClientFlagTypes.PERMANENT.getNumericVal()) : (byte)(this.flags & ~DhcpClientFlagTypes.PERMANENT.getNumericVal());
    }

    public void setServerIP(IPAddress iPAddress) throws ValidationException {
        if (iPAddress == null) {
            String string = ResourceStrings.getString("dcr_invalid_null_serverip");
            throw new ValidationException(string);
        }
        this.serverIP = iPAddress;
    }

    public void setServerIP(String string) throws ValidationException {
        if (string == null) {
            String string2 = ResourceStrings.getString("dcr_invalid_null_serverip");
            throw new ValidationException(string2);
        }
        try {
            this.setServerIP(new IPAddress(string));
        }
        catch (Throwable throwable) {
            String string3 = ResourceStrings.getString("dcr_invalid_serverip");
            throw new ValidationException(string3);
        }
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setSignature(String string) {
        this.signature = string;
    }

    public void setUnusable(boolean bl) {
        this.flags = bl ? (byte)(this.flags | DhcpClientFlagTypes.UNUSABLE.getNumericVal()) : (byte)(this.flags & ~DhcpClientFlagTypes.UNUSABLE.getNumericVal());
    }

    public String toString() {
        String string = null;
        if (this.serverIP != null) {
            string = this.serverIP.getHostAddress();
        }
        String string2 = null;
        if (this.clientIP != null) {
            string2 = this.clientIP.getHostAddress();
        }
        String string3 = null;
        if (this.expiration != null) {
            string3 = this.expiration.toString();
        }
        String string4 = String.valueOf(this.clientId) + " " + String.valueOf(this.flags) + " " + string2 + " " + string + " " + string3 + " " + this.signature + " " + this.macro + " " + this.comment;
        return string4;
    }
}

