/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import java.net.InetAddress;
import java.util.Vector;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpQManager;
import javax.management.snmp.manager.SnmpRequest;

class WaitQ
extends Vector {
    boolean isBeingDestroyed = false;

    WaitQ(int n, int n2) {
        super(n, n2);
    }

    public synchronized void addWaiting(SnmpRequest snmpRequest) {
        long l = snmpRequest.getAbsMaxTimeToWait();
        int n = this.size();
        while (n > 0) {
            if (l < this.getRequestAt(n - 1).getAbsMaxTimeToWait()) break;
            --n;
        }
        if (n == this.size()) {
            this.addElement(snmpRequest);
            this.notifyClients();
        } else {
            this.insertElementAt(snmpRequest, n);
        }
    }

    public synchronized SnmpPduFactory findPduFactory(InetAddress inetAddress, int n) {
        SnmpPduFactory snmpPduFactory = null;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2 && snmpPduFactory == null) {
            SnmpPeer snmpPeer;
            SnmpRequest snmpRequest = this.getRequestAt(n3);
            if (snmpRequest instanceof SnmpRequest && (snmpPeer = snmpRequest.getPeer()).getDestAddr().equals(inetAddress) && snmpPeer.getDestPort() == n) {
                snmpPduFactory = snmpPeer.getPduFactory();
            }
            ++n3;
        }
        return snmpPduFactory;
    }

    public SnmpRequest getRequestAt(int n) {
        return (SnmpRequest)this.elementAt(n);
    }

    public synchronized SnmpRequest getTimeoutRequests() {
        if (this.waitUntilReady()) {
            SnmpRequest snmpRequest = (SnmpRequest)this.lastElement();
            --this.elementCount;
            return snmpRequest;
        }
        return null;
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized String printAllRequest(long l) {
        if (this.isEmpty()) {
            return "------- WaitQ empty.......";
        }
        StringBuffer stringBuffer = new StringBuffer("\n------------------------ Requests in WaitQ -> " + this.size());
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            SnmpRequest snmpRequest = this.getRequestAt(n2);
            stringBuffer.append("\n" + n2 + ". (" + snmpRequest.toString() + " RemainingTimeToSend = " + snmpRequest.timeRemainingForAction(l) + "  ) ................................\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public synchronized SnmpRequest removeRequest(long l) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            SnmpRequest snmpRequest = this.getRequestAt(n2);
            if (l == (long)snmpRequest.getRequestId()) {
                this.removeElementAt(n2);
                return snmpRequest;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void waitOnThisQueue(long l) {
        if (l == 0L && !this.isEmpty() && SnmpQManager.isDebugOn()) {
            SnmpQManager.debug("waitOnThisQueue", "[" + Thread.currentThread().toString() + "]:" + "Fatal BUG :: Blocking on waitq permenantly. But size = " + this.size());
        }
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized boolean waitUntilReady() {
        while (!this.isBeingDestroyed) {
            long l = 0L;
            if (!this.isEmpty()) {
                long l2 = System.currentTimeMillis();
                SnmpRequest snmpRequest = (SnmpRequest)this.lastElement();
                l = snmpRequest.getAbsMaxTimeToWait() - l2;
                if (l <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(l);
        }
        return false;
    }
}

