/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import com.sun.jdmk.Trace;
import java.net.DatagramPacket;
import javax.management.snmp.SnmpMessage;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.manager.SnmpQManager;
import javax.management.snmp.manager.SnmpRequest;

class SnmpResponseHandler {
    SnmpQManager snmpq = null;
    String dbgTag = "SnmpResponseHandler";

    public SnmpResponseHandler() {
        this.snmpq = SnmpQManager.getTheInstance();
    }

    public SnmpResponseHandler(SnmpQManager snmpQManager) {
        this.snmpq = snmpQManager;
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    public synchronized void processDatagram(DatagramPacket datagramPacket) {
        block15: {
            byte[] byArray = datagramPacket.getData();
            int n = datagramPacket.getLength();
            if (this.isTraceOn()) {
                this.trace("processDatagram", "Received from peer " + datagramPacket.getAddress().toString() + " Length = " + n + "\nDump : \n" + SnmpMessage.dumpHexBuffer(byArray, 0, n));
            }
            try {
                SnmpMessage snmpMessage = new SnmpMessage();
                snmpMessage.decodeMessage(byArray, n);
                snmpMessage.address = datagramPacket.getAddress();
                snmpMessage.port = datagramPacket.getPort();
                SnmpPduFactory snmpPduFactory = this.snmpq.findPduFactory(snmpMessage.address, snmpMessage.port);
                if (snmpPduFactory == null) {
                    if (this.isDebugOn()) {
                        this.debug("processDatagram", "Dropping packet. Unable to find the pdu factory for = " + snmpMessage.address + ":" + snmpMessage.port);
                    }
                } else {
                    SnmpPduPacket snmpPduPacket = snmpPduFactory.decodePdu(snmpMessage);
                    if (snmpPduPacket == null) {
                        if (this.isDebugOn()) {
                            this.debug("processDatagram", "Dropping packet. Pdu factory returned a null value");
                        }
                    } else if (snmpPduPacket instanceof SnmpPduRequest) {
                        SnmpPduRequest snmpPduRequest = (SnmpPduRequest)snmpPduPacket;
                        SnmpRequest snmpRequest = this.snmpq.removeRequest(snmpPduRequest.requestId);
                        if (snmpRequest != null) {
                            snmpRequest.invokeOnResponse(snmpPduRequest);
                        } else if (this.isDebugOn()) {
                            this.debug("processDatagram", "Dropping packet. Unable to find corresponding for requestId = " + snmpPduRequest.requestId);
                        }
                    } else if (this.isDebugOn()) {
                        this.debug("processDatagram", "Dropping packet. The packet does not contain a response");
                    }
                    snmpPduPacket = null;
                }
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block15;
                this.debug("processDatagram", "Exception while processsing");
                this.debug("processDatagram", exception);
            }
        }
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }
}

