/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.JIntSpinBox;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelectableLabel;
import com.sun.admin.diskmgr.client.DiskGraphic;
import com.sun.admin.diskmgr.client.DiskGraphicBtnPanel;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.SlicePropDialog;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SliceSizePanel
extends JPanel {
    public static final int HELP_CACHE_SIZE = 3;
    GenInfoPanel infoPanel;
    Vector helpCache;
    DiskMgrContextHelpListener helpListener;
    private VDiskMgr theApp;
    private VOptionPane optionPane;
    private SlicePropDialog dialog;
    private DiskGraphic diskGraphic;
    private ResourceBundle bundle;
    private DiskData diskData;
    private SliceData sliceData;
    private ActionString actionString;
    private JLabel fromLabel = new JLabel();
    private JIntSpinBox fromSpin;
    private int fromFloor;
    private int fromCeiling;
    private JLabel toLabel = new JLabel();
    private JIntSpinBox toSpin;
    private int toFloor;
    private int toCeiling;
    private JLabel sizeLabel = new JLabel();
    private SelectableLabel sizeField;
    private DiskGraphicBtnPanel btnPanel = null;
    private short currentTag;

    public SliceSizePanel(VDiskMgr vDiskMgr, VOptionPane vOptionPane) {
        this.theApp = vDiskMgr;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.bundle = vDiskMgr.getResourceBundle();
        this.optionPane = vOptionPane;
        this.dialog = (SlicePropDialog)vOptionPane;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceCylRangeLabel"));
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)this, (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.initLabel(this.fromLabel, "SliceCylFrom");
        Constraints.constrain((Container)jPanel2, (Component)this.fromLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        this.fromSpin = new JIntSpinBox(5, 0, 0);
        SpinBoxDocListener spinBoxDocListener = new SpinBoxDocListener();
        this.fromSpin.getTextField().getDocument().addDocumentListener(spinBoxDocListener);
        this.infoPanel = new GenInfoPanel(vOptionPane);
        this.helpCache = new Vector(3);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, "diskpart_cyl");
        vDiskMgr.addHelpListener(this.helpListener, (Component)this.fromSpin);
        this.fromLabel.setLabelFor(this.fromSpin.getTextField());
        Constraints.constrain((Container)jPanel2, (Component)this.fromSpin, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)0, (int)6, (int)6);
        this.initLabel(this.toLabel, "SliceCylTo");
        Constraints.constrain((Container)jPanel2, (Component)this.toLabel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)12, (int)6, (int)6);
        this.toSpin = new JIntSpinBox(5, 0, 0);
        this.toSpin.getTextField().getDocument().addDocumentListener(spinBoxDocListener);
        vDiskMgr.addHelpListener(this.helpListener, (Component)this.toSpin);
        this.toLabel.setLabelFor(this.toSpin.getTextField());
        Constraints.constrain((Container)jPanel2, (Component)this.toSpin, (int)3, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)0, (int)6, (int)6);
        this.initLabel(this.sizeLabel, "SliceSize");
        Constraints.constrain((Container)jPanel2, (Component)this.sizeLabel, (int)4, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)12, (int)6, (int)6);
        this.sizeField = new SelectableLabel("", 5);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, "diskpart_size");
        vDiskMgr.addHelpListener(this.helpListener, (Component)this.sizeField);
        this.sizeLabel.setLabelFor((Component)this.sizeField);
        Constraints.constrain((Container)jPanel2, (Component)this.sizeField, (int)5, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)0, (int)6, (int)6);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"MB"));
        Constraints.constrain((Container)jPanel2, (Component)jLabel, (int)6, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)6, (int)0, (int)6, (int)6);
        Constraints.constrain((Container)this, (Component)jPanel2, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
    }

    public short getCurrentTag() {
        return this.currentTag;
    }

    public int getEndCyl() {
        return this.toSpin.getIntValue();
    }

    protected JIntSpinBox getEndSpin() {
        return this.toSpin;
    }

    public int getStartCyl() {
        return this.fromSpin.getIntValue();
    }

    public int getStartFloor() {
        return this.fromSpin.getFloor();
    }

    protected JIntSpinBox getStartSpin() {
        return this.fromSpin;
    }

    protected void initFields() {
        this.diskData = this.dialog.getDiskData();
        if (this.sliceData.getEndCylinder() != 0 && !this.diskData.hasSliceOverlap()) {
            if (this.sliceData.getTag() != 5) {
                this.fromSpin.setCeiling(this.sliceData.getEndCylinder());
                this.fromFloor = this.diskGraphic.getPreviousStartCylinder(this.sliceData);
                if (this.fromFloor == -1) {
                    this.fromSpin.setFloor(this.sliceData.getStartCylinder());
                } else {
                    this.fromSpin.setFloor(this.fromFloor);
                }
                this.toSpin.setFloor(this.sliceData.getStartCylinder());
                this.toCeiling = this.diskGraphic.getNextEndCylinder(this.sliceData);
                if (this.toCeiling == -1) {
                    this.toSpin.setCeiling(this.sliceData.getEndCylinder());
                } else {
                    this.toSpin.setCeiling(this.toCeiling);
                }
            } else {
                this.toSpin.setCeiling(this.diskData.getSolarisCylinders() - 1);
                this.setBackup(true);
            }
        } else {
            this.fromSpin.setFloor(0);
            this.fromSpin.setCeiling(this.diskData.getSolarisCylinders() - 1);
            this.toSpin.setFloor(0);
            this.toSpin.setCeiling(this.diskData.getSolarisCylinders() - 1);
        }
        this.setStartCyl(this.sliceData.getStartCylinder());
        this.setEndCyl(this.sliceData.getEndCylinder());
        this.sizeField.setText(this.sliceData.getSize());
    }

    private void initLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    public boolean isValid() {
        this.diskData.sortSlicesByPartition();
        DiskData diskData = (DiskData)this.diskData.clone();
        Vector vector = diskData.getVSlices();
        SliceData sliceData = new SliceData(diskData, this.sliceData.getPartition());
        sliceData.setStartCylinder(this.getStartCyl());
        sliceData.setEndCylinder(this.getEndCyl());
        sliceData.setTag(this.getCurrentTag());
        vector.setElementAt(sliceData, this.sliceData.getPartition());
        diskData.setVSlices(vector);
        return this.getStartCyl() <= this.getEndCyl() && !diskData.hasSliceOverlap();
    }

    public void setBackup(boolean bl) {
        if (bl) {
            this.fromSpin.setIntValue(0);
            this.toSpin.setIntValue(this.diskData.getSolarisCylinders() - 1);
        }
        this.fromSpin.setEnabled(bl ^ true);
        this.toSpin.setEnabled(bl ^ true);
        this.validate();
        this.repaint();
    }

    public void setCurrentTag(short s) {
        this.currentTag = s;
    }

    public void setEndCyl(int n) {
        this.toSpin.setIntValue(n);
    }

    protected void setSliceData(SliceData sliceData) {
        this.sliceData = sliceData;
        this.diskGraphic = this.dialog.getDiskGraphic();
        this.btnPanel = this.dialog.getBtnPanel();
        this.initFields();
    }

    public void setStartCyl(int n) {
        this.fromSpin.setIntValue(n);
    }

    private void updateSize() {
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"BadSize"));
        int n = this.fromSpin.getIntValue();
        int n2 = this.toSpin.getIntValue();
        int n3 = n2 - n;
        if (n3 >= 0) {
            string = Float.toString(this.dialog.getDiskData().cylinderToMB(n3));
        }
        if (!this.sizeField.getText().equals(string)) {
            this.sizeField.setText(string);
        }
        this.btnPanel.setPreviewEnabled(n != this.sliceData.getStartCylinder() || n2 != this.sliceData.getEndCylinder());
        if (this.sliceData.getEndCylinder() != 0) {
            this.toSpin.setFloor(this.fromSpin.getIntValue() - 1);
            this.fromSpin.setCeiling(this.toSpin.getIntValue() + 1);
        }
    }

    private class SpinBoxDocListener
    implements DocumentListener {
        SpinBoxDocListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            SliceSizePanel.this.updateSize();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            SliceSizePanel.this.updateSize();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            SliceSizePanel.this.updateSize();
        }
    }
}

