/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.DiskGraphic;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.SliceWizard;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SliceReviewStep
extends VWizardCard {
    public static final String NAME = "SliceReviewStep";
    public static final int HELP_CACHE_SIZE = 1;
    private static ResourceBundle bundle;
    GenInfoPanel infoPanel;
    Vector helpCache;
    DiskMgrContextHelpListener helpListener;
    DiskData diskData;
    SliceWizard wizard;
    VDiskMgr theApp;
    Vector slices;

    public SliceReviewStep(VDiskMgr vDiskMgr, SliceWizard sliceWizard) {
        this.theApp = vDiskMgr;
        this.wizard = sliceWizard;
        this.diskData = sliceWizard.getDiskData();
        bundle = vDiskMgr.getResourceBundle();
        this.infoPanel = new GenInfoPanel((VOptionPane)sliceWizard);
        this.helpCache = new Vector(1);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, "disk_wiz_review");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.helpListener), true);
        this.setTitle(ResourceStrings.getString((ResourceBundle)bundle, (String)"SliceWizReviewStep"));
        this.constructStep();
    }

    private void constructStep() {
        Object object;
        ((Container)((Object)this)).removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)bundle, (String)"SliceWizReviewWarning"), 30, Constants.PROPS_RO_VALUE_FONT);
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)bundle, (String)"SliceWizPartition"));
        Constraints.constrain((Container)jPanel2, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)bundle, (String)"SliceWizSize"));
        Constraints.constrain((Container)jPanel2, (Component)jLabel, (int)1, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)bundle, (String)"SliceWizUsedFor"));
        Constraints.constrain((Container)jPanel2, (Component)jLabel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)bundle, (String)"SliceWizFileSystem"));
        Constraints.constrain((Container)jPanel2, (Component)jLabel, (int)3, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        JPanel jPanel3 = new JPanel();
        Constraints.constrain((Container)jPanel2, (Component)jPanel3, (int)4, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        int n = 1;
        this.slices = this.wizard.getSlices();
        SliceData sliceData = null;
        int n2 = this.wizard.getNumSlices();
        if (this.wizard.hasBackup()) {
            ++n2;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3;
            if (this.wizard.hasBackup() && n2 < 3 && n3 == 1) {
                n4 = 2;
            }
            sliceData = (SliceData)this.slices.elementAt(n4);
            JLabel jLabel2 = new JLabel(Integer.toString(n4));
            Constraints.constrain((Container)jPanel2, (Component)jLabel2, (int)0, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            JLabel jLabel3 = new JLabel(Content.formatSuffix(sliceData.getSize(), ResourceStrings.getString((ResourceBundle)bundle, (String)"Megabytes")));
            Constraints.constrain((Container)jPanel2, (Component)jLabel3, (int)1, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            JLabel jLabel4 = new JLabel(sliceData.getTagAsString());
            Constraints.constrain((Container)jPanel2, (Component)jLabel4, (int)2, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            object = ResourceStrings.getString((ResourceBundle)bundle, (String)"No");
            if (sliceData.getFS()) {
                object = ResourceStrings.getString((ResourceBundle)bundle, (String)"Yes");
            }
            JLabel jLabel5 = new JLabel((String)object);
            if (sliceData.getTag() == 5) {
                jLabel5.setText("");
                jLabel2.setFont(Constants.ITALIC_DIALOG_FONT);
                jLabel3.setFont(Constants.ITALIC_DIALOG_FONT);
                jLabel4.setText(ResourceStrings.getString((ResourceBundle)bundle, (String)"SliceWizBackup"));
                jLabel4.setFont(Constants.ITALIC_DIALOG_FONT);
            }
            Constraints.constrain((Container)jPanel2, (Component)jLabel5, (int)3, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            jPanel3 = new JPanel();
            Constraints.constrain((Container)jPanel2, (Component)jPanel3, (int)4, (int)n, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            ++n;
            ++n3;
        }
        Constraints.constrain((Container)((Object)this), (Component)jPanel2, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        object = new DiskGraphic(this.theApp, this.diskData, null, false);
        Constraints.constrain((Container)jPanel4, (Component)object, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        this.slices = this.wizard.getSlices();
        Constraints.constrain((Container)((Object)this), (Component)jPanel4, (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        jPanel3 = new JPanel();
        Constraints.constrain((Container)((Object)this), (Component)jPanel3, (int)0, (int)3, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    public static Dimension getMaxStepSize(ResourceBundle resourceBundle, String string) {
        int n = 0;
        int n2 = 0;
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"SliceWizReviewWarning"), 30, Constants.PROPS_RO_VALUE_FONT);
        n += flowArea.getPreferredSize().width + 12;
        n2 += flowArea.getPreferredSize().height + 12;
        int n3 = 0;
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"SliceWizPartition"));
        n2 += jLabel.getPreferredSize().height + 12;
        n3 += jLabel.getPreferredSize().width + 12;
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"SliceWizSize"));
        int n4 = jLabel.getPreferredSize().width + 12;
        jLabel = new JLabel(Content.formatSuffix(string, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Megabytes")));
        int n5 = jLabel.getPreferredSize().width + 12;
        n3 += Math.max(n4, n5);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"SliceWizUsedFor"));
        n3 += jLabel.getPreferredSize().width + 12;
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"SliceWizFileSystem"));
        n = Math.max(n, n3 += jLabel.getPreferredSize().width + 12);
        n2 += 8 * (jLabel.getPreferredSize().height + 12);
        n2 += 134;
        return new Dimension(n, n2 += 12);
    }

    public boolean isSubStep() {
        return true;
    }

    public void reset() {
    }

    public void start() {
        super.start();
        this.constructStep();
        this.getManager().setNext(NAME, "");
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.true");
        this.setProperty("vwp.canmoveforward", "vwp.true");
    }

    public boolean stop(boolean bl) {
        this.getManager().setPrevious(NAME, "SliceFsStep");
        if (bl) {
            this.wizard.doFinish();
            this.wizard.cancelWizard();
        } else {
            this.setProperty("vwp.finishstate", "vwp.false");
        }
        return true;
    }
}

