/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import COM.odi.ClassInfo;
import COM.odi.GenericObject;
import COM.odi.IPersistent;
import COM.odi.ObjectStore;
import COM.odi.util.OSHashtable;
import COM.odi.util.OSVector;
import com.sun.jini.lease.landlord.LeasedResource;
import com.sun.jini.outrigger.BasicSpace;
import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryHandleTmplDesc;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.LeaseDesc;
import com.sun.jini.outrigger.NotifyChit;
import com.sun.jini.outrigger.SimpleEntryHolder;
import com.sun.jini.outrigger.SpaceProxy;
import com.sun.jini.outrigger.TemplateHandle;
import com.sun.jini.outrigger.TemplateHolderClassInfo;
import com.sun.jini.outrigger.TransactableMgr;
import com.sun.jini.outrigger.TxnTemplateHandle;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import net.jini.core.event.RemoteEventListener;

class TemplateHolder
extends SimpleEntryHolder {
    static final long serialVersionUID = 8812450886813060000L;
    private static final PrintWriter dbgEvents;
    static ClassInfo myOdiClassInfoInstance;

    static {
        myOdiClassInfoInstance = ClassInfo.register((ClassInfo)new TemplateHolderClassInfo());
        dbgEvents = BasicSpace.debug.getWriter("events");
    }

    TemplateHolder(OSHashtable oSHashtable, String string) {
        super(oSHashtable, string);
    }

    public Object add(EntryRep entryRep, TransactableMgr transactableMgr) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        TemplateHandle templateHandle = (TemplateHandle)this.contents.head();
        while (templateHandle != null) {
            if (entryRep.equals(templateHandle.rep())) {
                if (templateHandle.txn() != transactableMgr) {
                    if (dbgEvents != null) {
                        dbgEvents.println("txns don't match, continuing");
                    }
                } else {
                    TemplateHandle templateHandle2 = templateHandle;
                    synchronized (templateHandle2) {
                        if (!templateHandle.removed()) {
                            if (dbgEvents != null) {
                                dbgEvents.println("found match using txn " + transactableMgr);
                            }
                            TemplateHandle templateHandle3 = templateHandle;
                            Object var6_6 = null;
                            return templateHandle3;
                        }
                    }
                }
            }
            templateHandle = (TemplateHandle)templateHandle.next();
        }
        if (dbgEvents != null) {
            dbgEvents.println("adding: no match using txn " + transactableMgr);
        }
        return super.add(entryRep, transactableMgr, false);
    }

    public synchronized void allMatches(EntryRep entryRep, TransactableMgr transactableMgr, boolean bl, Vector vector) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (dbgEvents != null) {
            dbgEvents.println();
            dbgEvents.print("TemplateHolder: allMatches, ");
            dbgEvents.println("numFields = " + this.numFields);
        }
        if (this.numFields < 0) {
            return;
        }
        long l = EntryHandle.hashFor(entryRep, entryRep.numFields());
        if (dbgEvents != null) {
            dbgEvents.print("rep hash = 0x" + Long.toHexString(l));
            dbgEvents.println(", writeTxn = " + transactableMgr);
        }
        TemplateHandle templateHandle = (TemplateHandle)this.contents.head();
        while (templateHandle != null) {
            EntryHandleTmplDesc entryHandleTmplDesc;
            EntryHandleTmplDesc entryHandleTmplDesc2;
            EntryHandleTmplDesc entryHandleTmplDesc3 = templateHandle.descFor(entryRep.numFields());
            if (dbgEvents != null) {
                EntryHandleTmplDesc entryHandleTmplDesc4;
                EntryHandleTmplDesc entryHandleTmplDesc5;
                StringBuffer stringBuffer = new StringBuffer("template hash = 0x");
                if ((entryHandleTmplDesc5 = entryHandleTmplDesc3).ODIObjectState < 0) {
                    entryHandleTmplDesc5 = entryHandleTmplDesc5;
                    ObjectStore.fetch((IPersistent)entryHandleTmplDesc5);
                }
                dbgEvents.print(stringBuffer.append(Long.toHexString(entryHandleTmplDesc5.hash)).toString());
                StringBuffer stringBuffer2 = new StringBuffer(", mask = 0x");
                if ((entryHandleTmplDesc4 = entryHandleTmplDesc3).ODIObjectState < 0) {
                    entryHandleTmplDesc4 = entryHandleTmplDesc4;
                    ObjectStore.fetch((IPersistent)entryHandleTmplDesc4);
                }
                dbgEvents.print(stringBuffer2.append(Long.toHexString(entryHandleTmplDesc4.mask)).toString());
                dbgEvents.println(", txn = " + templateHandle.txn());
            }
            if ((entryHandleTmplDesc2 = entryHandleTmplDesc3).ODIObjectState < 0) {
                entryHandleTmplDesc2 = entryHandleTmplDesc2;
                ObjectStore.fetch((IPersistent)entryHandleTmplDesc2);
            }
            long l2 = l & entryHandleTmplDesc2.mask;
            if ((entryHandleTmplDesc = entryHandleTmplDesc3).ODIObjectState < 0) {
                entryHandleTmplDesc = entryHandleTmplDesc;
                ObjectStore.fetch((IPersistent)entryHandleTmplDesc);
            }
            if (l2 == entryHandleTmplDesc.hash) {
                if (dbgEvents != null) {
                    EntryRep entryRep2 = templateHandle.rep();
                    dbgEvents.println("inList.matches(rep) == " + entryRep2.matches(entryRep));
                }
                if (templateHandle.matches(entryRep) && !templateHandle.removed()) {
                    OSVector oSVector;
                    templateHandle.waitUntilStable();
                    int n = 0;
                    OSVector oSVector2 = oSVector = templateHandle.chits();
                    synchronized (oSVector2) {
                        Enumeration enumeration = templateHandle.chits().elements();
                        while (enumeration.hasMoreElements()) {
                            try {
                                RemoteEventListener remoteEventListener;
                                NotifyChit notifyChit = (NotifyChit)enumeration.nextElement();
                                if (bl && !((remoteEventListener = notifyChit.listener()) instanceof SpaceProxy.ProxyListener) || !notifyChit.canSee(transactableMgr)) continue;
                                vector.addElement(notifyChit);
                                ++n;
                            }
                            catch (RemoteException remoteException) {}
                        }
                    }
                    if (dbgEvents != null) {
                        dbgEvents.println("found template match, added " + n + " chits");
                    }
                    if (n > 0) {
                        templateHandle.usedMatch();
                    }
                }
            }
            templateHandle = (TemplateHandle)templateHandle.next();
        }
    }

    public boolean cancel(LeaseDesc leaseDesc) {
        OSVector oSVector;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        NotifyChit notifyChit = (NotifyChit)leaseDesc;
        Object object = notifyChit.getCookie();
        boolean bl = false;
        TemplateHandle templateHandle = notifyChit.handle();
        OSVector oSVector2 = oSVector = templateHandle.chits();
        synchronized (oSVector2) {
            int n = 0;
            while (n < oSVector.size()) {
                NotifyChit notifyChit2 = (NotifyChit)oSVector.elementAt(n);
                if (object.equals(notifyChit2.getCookie())) {
                    oSVector.removeElementAt(n);
                    bl = true;
                    if (oSVector.size() != 0) break;
                    this.remove(templateHandle);
                    break;
                }
                ++n;
            }
        }
        boolean bl2 = this.idMap.remove(notifyChit.getCookie()) != null;
        return bl2 || bl;
    }

    EntryHandle newHandle(EntryRep entryRep, TransactableMgr transactableMgr) {
        if (transactableMgr == null) {
            return new TemplateHandle(entryRep);
        }
        return new TxnTemplateHandle(entryRep, transactableMgr);
    }

    void reapExpired(long l) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        TemplateHandle templateHandle = (TemplateHandle)this.contents.head();
        while (templateHandle != null) {
            OSVector oSVector;
            OSVector oSVector2 = oSVector = templateHandle.chits();
            synchronized (oSVector2) {
                int n = 0;
                while (n < oSVector.size()) {
                    NotifyChit notifyChit = (NotifyChit)oSVector.elementAt(n);
                    if (BasicSpace.staticSpace.expired((LeasedResource)notifyChit, l)) {
                        if (dbgEvents != null) {
                            dbgEvents.println("Expiring chit " + notifyChit.getCookie() + " it expired at " + notifyChit.getExpiration() + " now is " + l);
                        }
                        oSVector.removeElementAt(n);
                        this.idMap.remove(notifyChit.getCookie());
                        BasicSpace.staticSpace.cancelOp((Long)notifyChit.getCookie());
                        --n;
                    }
                    ++n;
                }
                if (oSVector.size() == 0) {
                    this.remove(templateHandle);
                }
            }
            templateHandle = (TemplateHandle)templateHandle.next();
        }
    }

    boolean remove(EntryHandle entryHandle) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.contents.remove(entryHandle);
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        super.initializeContents(genericObject);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        super.flushContents(genericObject);
    }

    public void clearContents() {
        super.clearContents();
    }

    public TemplateHolder(ClassInfo classInfo) {
        super(classInfo);
    }
}

