/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import COM.odi.ClassInfo;
import COM.odi.GenericObject;
import COM.odi.IPersistent;
import COM.odi.ObjectStore;
import COM.odi.util.OSVector;
import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryHandleTmplDesc;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.NotifyChit;
import com.sun.jini.outrigger.TemplateHandleClassInfo;
import com.sun.jini.outrigger.TransactableMgr;

class TemplateHandle
extends EntryHandle {
    private long numMatches;
    private OSVector descs;
    private OSVector chits;
    private boolean onAbort;
    static ClassInfo myOdiClassInfoInstance = ClassInfo.register((ClassInfo)new TemplateHandleClassInfo());

    TemplateHandle(EntryRep entryRep) {
        super(entryRep);
        this.descs = new OSVector();
        this.chits = new OSVector();
    }

    void add(NotifyChit notifyChit) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        notifyChit.handle(this);
        this.chits.addElement((Object)notifyChit);
    }

    synchronized void changeSeq(long l) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this.numMatches < l) {
            TemplateHandle templateHandle;
            if (((templateHandle = this).ODIObjectState & 2) != 0) {
                templateHandle = templateHandle;
                ObjectStore.dirty((IPersistent)templateHandle);
            }
            templateHandle.numMatches = l;
        }
    }

    OSVector chits() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.chits;
    }

    EntryHandleTmplDesc descFor(int n) {
        Object object;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (n < this.descs.size() && (object = this.descs.elementAt(n)) != null) {
            return (EntryHandleTmplDesc)object;
        }
        EntryHandleTmplDesc entryHandleTmplDesc = EntryHandle.descFor(this.rep(), n);
        this.descs.setSize(n + 1);
        this.descs.setElementAt((Object)entryHandleTmplDesc, n);
        return entryHandleTmplDesc;
    }

    public long id() {
        EntryRep entryRep;
        if ((entryRep = this.rep()).ODIObjectState < 0) {
            entryRep = entryRep;
            ObjectStore.fetch((IPersistent)entryRep);
        }
        return entryRep.id;
    }

    public void id(long l) {
        if (this.id() != 0L) {
            throw new IllegalArgumentException("id already set");
        }
        this.rep().id(l);
    }

    boolean matches(EntryRep entryRep) {
        return this.rep().matches(entryRep);
    }

    boolean notifyOnAbort() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.onAbort;
    }

    void notifyOnAbort(boolean bl) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this.onAbort = bl;
    }

    long numMatches() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.numMatches;
    }

    TransactableMgr txn() {
        return null;
    }

    synchronized void usedMatch() {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        ++this.numMatches;
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this.numMatches = genericObject.getLongField(1, classInfo);
        this.descs = (OSVector)genericObject.getClassField(2, classInfo);
        this.chits = (OSVector)genericObject.getClassField(3, classInfo);
        this.onAbort = genericObject.getBooleanField(4, classInfo);
        super.initializeContents(genericObject);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setLongField(1, this.numMatches, classInfo);
        genericObject.setClassField(2, (Object)this.descs, classInfo);
        genericObject.setClassField(3, (Object)this.chits, classInfo);
        genericObject.setBooleanField(4, this.onAbort, classInfo);
        super.flushContents(genericObject);
    }

    public void clearContents() {
        this.numMatches = 0L;
        this.descs = null;
        this.chits = null;
        this.onAbort = false;
        super.clearContents();
    }

    public TemplateHandle(ClassInfo classInfo) {
        super(classInfo);
    }
}

