/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ChangeAppState;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.VCommonInfo;
import com.sun.admin.usermgr.client.ApplicationContext;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.NavigationSelectionListener;
import com.sun.admin.usermgr.client.ServiceWrapper;
import com.sun.admin.usermgr.client.TreeNodeData;
import com.sun.admin.usermgr.client.UserActionsListener;
import com.sun.admin.usermgr.client.UserMgrTree;
import com.sun.admin.usermgr.client.email.EmailContent;
import com.sun.admin.usermgr.client.email.UMgrEmailTBar;
import com.sun.admin.usermgr.client.groups.UMgrGroupTBar;
import com.sun.admin.usermgr.client.rbac.UMgrRightTBar;
import com.sun.admin.usermgr.client.rbac.UMgrRoleTBar;
import com.sun.admin.usermgr.client.templates.UMgrTemplTBar;
import com.sun.admin.usermgr.client.users.UMgrUserTBar;
import com.sun.admin.usermgr.common.AuthAttrObj;
import com.sun.admin.usermgr.common.ProfAttrObj;
import com.sun.admin.usermgr.common.UserException;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class VUserMgr
implements Tool,
IClientResource,
PropertyChangeListener,
VConsoleActionListener {
    private ServiceWrapper userMgr;
    private VConsoleProperties properties = null;
    private VDisplayModel displayModel = null;
    private JFrame consoleFrame = null;
    private ApplicationContext applicationContext = null;
    private ToolInfrastructure infrastructure = null;
    private boolean bRunning = false;
    private Vector consoleListeners = new Vector();
    private Vector allUsersCache = null;
    private Vector allTemplsCache = null;
    private Vector allGroupsCache = null;
    private Vector allRolesCache = null;
    private AuthAttrObj[] authListCache = null;
    private String[] adminAuthCache = null;
    private ProfAttrObj[] profListCache = null;
    private String[] adminProfCache = null;
    private String[] adminRoleCache = null;
    private Vector rightListCache = null;
    private Vector navigationSelectionListeners = new Vector();
    private String iconView = null;
    private boolean changeBackToDetails = false;
    private int busyCount = 0;
    private Component glassPane = null;
    private UserMgrTree theTree = null;
    private ResourceBundle resourceBundle = null;
    private ResourceBundle cisBundle = null;
    private AdminException initException = null;
    private boolean isCriticalStop = false;
    private Clipboard umClipBoard = new Clipboard("umgr");

    public VUserMgr() {
        try {
            this.resourceBundle = ResourceManager.getBundle((String)"com.sun.admin.usermgr.client.resources.Resources", this.getClass());
        }
        catch (Exception exception) {
            this.reportErrorException(exception);
            this.resourceBundle = null;
        }
        try {
            this.cisBundle = ResourceManager.getBundle((String)VCommonInfo.resourceClass, this.getClass());
        }
        catch (Exception exception) {
            this.reportErrorException(exception);
            this.cisBundle = null;
        }
        this.theTree = new UserMgrTree(this);
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (vConsoleActionListener != null) {
            this.consoleListeners.addElement(vConsoleActionListener);
        }
    }

    public void addHelpListener(Component component, ContextHelpListener contextHelpListener) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addHelpListener(componentArray[n], contextHelpListener);
                ++n;
            }
        }
        component.addFocusListener((FocusListener)contextHelpListener);
    }

    public void addNavigationSelectionListener(NavigationSelectionListener navigationSelectionListener) {
        this.navigationSelectionListeners.addElement(navigationSelectionListener);
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (!this.bRunning) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.refresh")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Refresh");
            UserActionsListener userActionsListener = new UserActionsListener(this, false);
            userActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.sechelpselection")) {
            Vector vector = (Vector)vConsoleEvent.getPayload();
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.onSelection(vector);
        } else if (string.equals("vconsole.scopechildopened")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.onDoubleClick();
        } else if (string.equals("vconsole.sortup") || string.equals("vconsole.sortdown")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.saveSortPreferences();
        } else if (string.equals("vconsole.displayproperties")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "ViewProps");
            UserActionsListener userActionsListener = new UserActionsListener(this, false);
            userActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.delete")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Delete");
            UserActionsListener userActionsListener = new UserActionsListener(this, false);
            userActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.updateselinfo")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            if (content instanceof EmailContent) {
                this.iconView = this.properties.getProperty("vconsole.iconstyle");
                if (this.iconView.equals("details")) {
                    this.properties.setProperty("vconsole.iconstyle", "list");
                    this.changeBackToDetails = true;
                }
                this.properties.setProperty("vconsole.iconviewsenabled", "smalllargelist");
            } else {
                this.properties.setProperty("vconsole.iconviewsenabled", "smalllargelistdetails");
                if (this.changeBackToDetails) {
                    this.properties.setProperty("vconsole.iconstyle", "details");
                    this.changeBackToDetails = false;
                }
            }
        }
    }

    public void destroy() {
    }

    public void fireConsoleAction(VConsoleEvent vConsoleEvent) {
        int n = 0;
        while (n < this.consoleListeners.size()) {
            VConsoleActionListener vConsoleActionListener = (VConsoleActionListener)this.consoleListeners.elementAt(n);
            vConsoleActionListener.consoleAction(vConsoleEvent);
            ++n;
        }
    }

    private void fireNavigationSelection(VConsoleEvent vConsoleEvent) {
        int n = 0;
        while (n < this.navigationSelectionListeners.size()) {
            Object e = this.navigationSelectionListeners.elementAt(n);
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)e;
            navigationSelectionListener.valueChanged((VScopeNode)vConsoleEvent.getPayload());
            ++n;
        }
    }

    public String[] getAdminAuthCache() {
        return this.adminAuthCache;
    }

    public String[] getAdminProfCache() {
        return this.adminProfCache;
    }

    public String[] getAdminRoleCache() {
        return this.adminRoleCache;
    }

    public Vector getAllGroupsCache() {
        return this.allGroupsCache;
    }

    public Vector getAllRolesCache() {
        return this.allRolesCache;
    }

    public Vector getAllTemplsCache() {
        return this.allTemplsCache;
    }

    public Vector getAllUsersCache() {
        return this.allUsersCache;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public AuthAttrObj[] getAuthListCache() {
        return this.authListCache;
    }

    public String getAuthenticatedUser() {
        String string = null;
        VIdentity vIdentity = this.infrastructure.getIdentity();
        if (vIdentity != null) {
            string = vIdentity.getName();
        }
        return string;
    }

    public ResourceBundle getCisBundle() {
        return this.cisBundle;
    }

    public Clipboard getClipBoard() {
        return this.umClipBoard;
    }

    public VScopeNode getCurrentNode() {
        return this.theTree.getCurrentNode();
    }

    public VDisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public JFrame getFrame() {
        return this.consoleFrame;
    }

    public ProfAttrObj[] getProfListCache() {
        return this.profListCache;
    }

    public VConsoleProperties getProperties() {
        return this.properties;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public Vector getRightListCache() {
        return this.rightListCache;
    }

    public VScopeNode getScopeNode() {
        return this.theTree.getRootNode();
    }

    public ToolInfrastructure getToolInfrastructure() {
        return this.infrastructure;
    }

    public UserMgrTree getTree() {
        return this.theTree;
    }

    public ServiceWrapper getUserMgr() {
        return this.userMgr;
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.infrastructure = toolInfrastructure;
        try {
            this.userMgr = this.applicationContext.getServiceWrapper(toolInfrastructure);
        }
        catch (AdminException adminException) {
            this.initException = adminException;
            String string = "<HTML><BODY>";
            string = String.valueOf(string) + ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"DESCRIPTION");
            string = String.valueOf(string) + "</p><p>" + adminException.getLocalizedMessage() + "</p>";
            string = String.valueOf(string) + "</BODY></HTML>";
            ChangeAppState.setErrorState((VScopeNode)this.getScopeNode(), (String)string);
            String string2 = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"err_log_summary");
            String string3 = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"err_log_message");
            String string4 = adminException.getLocalizedMessage();
            VLogEvent vLogEvent = new VLogEvent((Object)this, 30, new Date(), string2, string3, string4, (Throwable)adminException, null);
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
            this.fireConsoleAction(vConsoleEvent);
            return;
        }
        if (!this.userMgr.hasUserMgrReadAuth()) {
            String string = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"warn_log_detail");
            this.initException = new UserException(string);
            String string5 = "<HTML><BODY>";
            string5 = String.valueOf(string5) + ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"DESCRIPTION");
            string5 = String.valueOf(string5) + "</p><p>" + this.initException.getLocalizedMessage() + "</p>";
            string5 = String.valueOf(string5) + "</BODY></HTML>";
            ChangeAppState.setWarningState((VScopeNode)this.getScopeNode(), (String)string5);
            String string6 = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"warn_log_summary");
            String string7 = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"warn_log_message");
            VLogEvent vLogEvent = new VLogEvent((Object)this, 20, new Date(), string6, string7, this.initException.getLocalizedMessage(), (Throwable)this.initException, null);
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
            this.fireConsoleAction(vConsoleEvent);
            return;
        }
    }

    public boolean isRoleAssumed() {
        boolean bl = false;
        VIdentity vIdentity = this.infrastructure.getIdentity();
        if (vIdentity != null) {
            bl = vIdentity.isInRole();
        }
        return bl;
    }

    public boolean isWaitOn() {
        return this.busyCount > 0;
    }

    public ImageIcon loadImageIcon(String string, String string2) {
        String string3 = "images/" + string;
        return ConsoleUtility.loadImageIcon((String)string3, this.getClass());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.displaymodel")) {
            this.displayModel = (VDisplayModel)propertyChangeEvent.getNewValue();
        } else if (string.equals("vconsole.frame")) {
            this.consoleFrame = (JFrame)propertyChangeEvent.getNewValue();
        }
    }

    public void reportErrorException(Exception exception) {
        AdminException adminException;
        String string = "";
        while (exception != null) {
            if (exception instanceof AdminException) {
                adminException = (AdminException)((Object)exception);
                string = String.valueOf(string) + "\n" + adminException.getLocalizedMessage();
                if (adminException.isEmbeddedException()) {
                    exception = adminException.getEmbeddedException();
                    continue;
                }
                exception = null;
                continue;
            }
            string = String.valueOf(string) + "\n" + exception.getMessage();
            exception = null;
        }
        adminException = new ErrorDialog(this.getFrame(), string);
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        return -1;
    }

    public void setAdminAuthCache(String[] stringArray) {
        this.adminAuthCache = stringArray;
    }

    public void setAdminProfCache(String[] stringArray) {
        this.adminProfCache = stringArray;
    }

    public void setAdminRoleCache(String[] stringArray) {
        this.adminRoleCache = stringArray;
    }

    public void setAllGroupsCache(Vector vector) {
        this.allGroupsCache = vector;
    }

    public void setAllRolesCache(Vector vector) {
        this.allRolesCache = vector;
    }

    public void setAllTemplsCache(Vector vector) {
        this.allTemplsCache = vector;
    }

    public void setAllUsersCache(Vector vector) {
        this.allUsersCache = vector;
    }

    public void setAuthListCache(AuthAttrObj[] authAttrObjArray) {
        this.authListCache = authAttrObjArray;
    }

    private synchronized void setBusy(boolean bl) {
        if (this.glassPane == null) {
            return;
        }
        if (bl) {
            ++this.busyCount;
            if (this.busyCount == 1) {
                this.glassPane.setVisible(true);
            }
        } else {
            --this.busyCount;
            this.busyCount = Math.max(0, this.busyCount);
            if (this.busyCount == 0) {
                this.glassPane.setVisible(false);
                this.getFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void setProfListCache(ProfAttrObj[] profAttrObjArray) {
        this.profListCache = profAttrObjArray;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            VScopeNode vScopeNode;
            VScopeNode vScopeNode2;
            VScopeNode vScopeNode3;
            VScopeNode vScopeNode4;
            VScopeNode vScopeNode5;
            this.displayModel = (VDisplayModel)vConsoleProperties.getPropertyObject("vconsole.displaymodel");
            this.consoleFrame = (JFrame)vConsoleProperties.getPropertyObject("vconsole.frame");
            this.glassPane = this.getFrame().getGlassPane();
            this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
            this.glassPane.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                }
            });
            vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)this);
            int n = 0;
            VScopeNode vScopeNode6 = (VScopeNode)this.getScopeNode().getChildAt(n++);
            if (vScopeNode6 != null) {
                ((UMgrUserTBar)vScopeNode6.getToolBar()).setProperties(vConsoleProperties);
            }
            if ((vScopeNode5 = (VScopeNode)this.getScopeNode().getChildAt(n++)) != null) {
                ((UMgrTemplTBar)vScopeNode5.getToolBar()).setProperties(vConsoleProperties);
            }
            if ((vScopeNode4 = (VScopeNode)this.getScopeNode().getChildAt(n++)) != null) {
                ((UMgrRightTBar)vScopeNode4.getToolBar()).setProperties(vConsoleProperties);
            }
            if ((vScopeNode3 = (VScopeNode)this.getScopeNode().getChildAt(n++)) != null) {
                ((UMgrRoleTBar)vScopeNode3.getToolBar()).setProperties(vConsoleProperties);
            }
            if ((vScopeNode2 = (VScopeNode)this.getScopeNode().getChildAt(n++)) != null) {
                ((UMgrGroupTBar)vScopeNode2.getToolBar()).setProperties(vConsoleProperties);
            }
            if ((vScopeNode = (VScopeNode)this.getScopeNode().getChildAt(n++)) != null) {
                ((UMgrEmailTBar)vScopeNode.getToolBar()).setProperties(vConsoleProperties);
            }
        }
    }

    public void setRightListCache(Vector vector) {
        this.rightListCache = vector;
    }

    public void setStatusBar(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.updateselinfo", (Object)string);
        this.fireConsoleAction(vConsoleEvent);
    }

    public void setToolContext(ToolContext toolContext) {
        this.applicationContext = new ApplicationContext(this, toolContext);
    }

    public void start() throws CriticalStopException {
        if (this.initException != null) {
            if (this.isCriticalStop) {
                return;
            }
            this.reportErrorException((Exception)((Object)this.initException));
            this.isCriticalStop = true;
            throw new CriticalStopException(this.initException.getLocalizedMessage());
        }
        this.bRunning = true;
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.scopeselected", (Object)this.displayModel.getSelectedNavigationNode());
        this.fireNavigationSelection(vConsoleEvent);
    }

    public void stop() throws CriticalStopException {
        if (!this.bRunning) {
            return;
        }
        if (this.changeBackToDetails) {
            this.properties.setProperty("vconsole.iconviewsenabled", "smalllargelistdetails");
            this.properties.setProperty("vconsole.iconstyle", "details");
            this.changeBackToDetails = false;
        }
        this.bRunning = false;
    }

    public void waitOff() {
        this.setBusy(false);
    }

    public void waitOn() {
        this.setBusy(true);
    }
}

