/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.solarisprovider.scheduledjob.CronLog;
import com.sun.wbem.solarisprovider.scheduledjob.CronUtility;
import com.sun.wbem.solarisprovider.scheduledjob.CrontabEntries;
import com.sun.wbem.solarisprovider.scheduledjob.NameFilter;
import com.sun.wbem.solarisprovider.scheduledjob.ScheduledJobProvider;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.io.File;

public class Crontab {
    private static String CRONTAB_DIRECTORY = "/var/spool/cron/crontabs";
    CronLog cronLog = null;
    DirectoryTable crontab = null;
    boolean crontabOpen = false;
    TableDefinitions crontabTableDefs = null;
    int minuteCol = 0;
    int hourCol = 0;
    int dayOfMonthCol = 0;
    int dayOfWeekCol = 0;
    int monthCol = 0;
    int commandCol = 0;
    int nameCol = 0;
    ScheduledJobProvider provHandle = null;

    public Crontab(ScheduledJobProvider scheduledJobProvider) {
        this.provHandle = scheduledJobProvider;
    }

    public void addEntry(CrontabEntries crontabEntries) throws CIMException {
        String string = crontabEntries.getOwner(1);
        String string2 = String.valueOf(CRONTAB_DIRECTORY) + File.separator + string;
        this.openCrontab(string2, string);
        DirectoryRow directoryRow = this.crontabEntryToDirectoryRow(crontabEntries);
        try {
            this.crontab.addRow(directoryRow);
        }
        catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
            this.provHandle.logErrorAndThrow("LM_7650", "LM_7692", string2);
        }
        catch (DirectoryTableException directoryTableException) {
            this.provHandle.logErrorAndThrow("LM_7650", "LM_7693", string2);
        }
        this.closeCrontab();
        CronUtility.notifyCron(this.provHandle, CronUtility.TYPE_CRON, CronUtility.ACTION_ADD, string, string);
    }

    private void closeCrontab() {
        if (this.crontabOpen) {
            this.crontab.close();
            this.crontabOpen = false;
        }
    }

    public DirectoryRow crontabEntryToDirectoryRow(CrontabEntries crontabEntries) throws CIMException {
        DirectoryRow directoryRow = null;
        String string = null;
        try {
            directoryRow = this.crontab.getRowInstance();
            directoryRow.putColumn(this.minuteCol, crontabEntries.getMinutes(1));
            directoryRow.putColumn(this.hourCol, crontabEntries.getHours(1));
            directoryRow.putColumn(this.dayOfMonthCol, crontabEntries.getDaysOfTheMonth(1));
            directoryRow.putColumn(this.dayOfWeekCol, crontabEntries.getDaysOfTheWeek(1));
            directoryRow.putColumn(this.monthCol, crontabEntries.getMonths(1));
            string = crontabEntries.getName(1);
            if (NameFilter.isGeneratedName(string)) {
                string = "";
                directoryRow.putColumn(this.commandCol, crontabEntries.getCommand(1));
            } else {
                directoryRow.putColumn(this.commandCol, String.valueOf(crontabEntries.getCommand(1)) + " ");
            }
            directoryRow.putColumn(this.nameCol, string);
        }
        catch (DirectoryTableException directoryTableException) {}
        return directoryRow;
    }

    public void deleteEntry(String string, String string2) throws CIMException {
        NameFilter nameFilter = null;
        String string3 = String.valueOf(CRONTAB_DIRECTORY) + File.separator + string;
        this.openCrontab(string3, string);
        nameFilter = new NameFilter(string2);
        try {
            DirectoryRow directoryRow = this.crontab.getFirstRow((SearchTemplate)nameFilter);
            this.crontab.deleteRow(directoryRow);
        }
        catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            this.provHandle.logErrorAndThrow("LM_7656", "LM_7694", string2, string);
        }
        catch (DirectoryTableException directoryTableException) {
            this.provHandle.logErrorAndThrow("LM_7656", "LM_7695", string2, string, string3);
        }
        this.closeCrontab();
        CronUtility.notifyCron(this.provHandle, CronUtility.TYPE_CRON, CronUtility.ACTION_DELETE, string, string);
    }

    public CrontabEntries getAllEntries(boolean bl) throws CIMException {
        CrontabEntries crontabEntries = null;
        CrontabEntries crontabEntries2 = null;
        File file = new File(CRONTAB_DIRECTORY);
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            if (CronUtility.isUser(stringArray[n]) && (crontabEntries2 = this.getEntriesByOwner(stringArray[n], bl, true)) != null) {
                if (crontabEntries == null) {
                    crontabEntries = crontabEntries2;
                } else {
                    crontabEntries.addEntries(crontabEntries2);
                }
            }
            ++n;
        }
        if (!bl) {
            this.cronLog.unloadCronLog();
            this.cronLog = null;
        }
        return crontabEntries;
    }

    public CrontabEntries getEntriesByOwner(String string, boolean bl, boolean bl2) throws CIMException {
        String string2 = String.valueOf(CRONTAB_DIRECTORY) + File.separator + string;
        DirectoryRow directoryRow = null;
        CrontabEntries crontabEntries = null;
        this.openCrontab(string2, string);
        try {
            directoryRow = this.crontab.getAll();
            if (directoryRow != null) {
                if (!(bl || bl2 && this.cronLog != null)) {
                    this.cronLog = new CronLog(this.provHandle);
                    this.cronLog.initialize();
                    this.cronLog.loadCronLog();
                }
                int n = directoryRow.getNumberOfRows();
                crontabEntries = new CrontabEntries(n);
                int n2 = 1;
                while (n2 <= n) {
                    String string3 = "";
                    if (!bl && (string3 = this.cronLog.getCronLogJobStatus(string, directoryRow.getColumn(this.commandCol, n2))) == null) {
                        string3 = "";
                    }
                    crontabEntries.setEntry(n2, string, directoryRow.getColumn(this.nameCol, n2), directoryRow.getColumn(this.commandCol, n2), directoryRow.getColumn(this.hourCol, n2), directoryRow.getColumn(this.minuteCol, n2), directoryRow.getColumn(this.dayOfWeekCol, n2), directoryRow.getColumn(this.dayOfMonthCol, n2), directoryRow.getColumn(this.monthCol, n2), string3);
                    ++n2;
                }
                if (!bl && !bl2) {
                    this.cronLog.unloadCronLog();
                    this.cronLog = null;
                }
            }
        }
        catch (DirectoryTableException directoryTableException) {}
        this.closeCrontab();
        return crontabEntries;
    }

    public CrontabEntries getEntryByName(String string, String string2) throws CIMException {
        String string3 = String.valueOf(CRONTAB_DIRECTORY) + File.separator + string;
        DirectoryRow directoryRow = null;
        CrontabEntries crontabEntries = null;
        NameFilter nameFilter = null;
        this.openCrontab(string3, string);
        try {
            nameFilter = new NameFilter(string2);
            directoryRow = this.crontab.getFirstRow((SearchTemplate)nameFilter);
            if (directoryRow != null) {
                String string4 = "";
                CronLog cronLog = new CronLog(this.provHandle);
                cronLog.initialize();
                cronLog.loadCronLog();
                string4 = cronLog.getCronLogJobStatus(string, directoryRow.getColumn(this.commandCol, 1));
                if (string4 == null) {
                    string4 = "";
                }
                cronLog.unloadCronLog();
                crontabEntries = new CrontabEntries(1);
                crontabEntries.setEntry(1, string, directoryRow.getColumn(this.nameCol, 1), directoryRow.getColumn(this.commandCol, 1), directoryRow.getColumn(this.hourCol, 1), directoryRow.getColumn(this.minuteCol, 1), directoryRow.getColumn(this.dayOfWeekCol, 1), directoryRow.getColumn(this.dayOfMonthCol, 1), directoryRow.getColumn(this.monthCol, 1), string4);
            }
        }
        catch (DirectoryTableException directoryTableException) {}
        this.closeCrontab();
        return crontabEntries;
    }

    public void initialize() throws CIMException {
        try {
            this.crontab = DirectoryTableFactory.getDirectoryTableInstance((String)"File", (String)"", (String)"");
            this.crontabTableDefs = this.crontab.getTableDefinitionsInstance();
            this.crontabTableDefs.loadTableDefinitions("crontab");
            this.minuteCol = this.crontabTableDefs.getColumnNumber("minute");
            this.hourCol = this.crontabTableDefs.getColumnNumber("hour");
            this.dayOfMonthCol = this.crontabTableDefs.getColumnNumber("dayofmonth");
            this.dayOfWeekCol = this.crontabTableDefs.getColumnNumber("dayofweek");
            this.monthCol = this.crontabTableDefs.getColumnNumber("month");
            this.commandCol = this.crontabTableDefs.getColumnNumber("command");
            this.nameCol = this.crontabTableDefs.getColumnNumber("comment");
        }
        catch (DirectoryTableException directoryTableException) {
            this.crontab = null;
            this.provHandle.logErrorAndThrow("LM_7688", "LM_7689");
        }
    }

    public void modifyEntry(String string, String string2, CrontabEntries crontabEntries) throws CIMException {
        NameFilter nameFilter = null;
        String string3 = String.valueOf(CRONTAB_DIRECTORY) + File.separator + string;
        this.openCrontab(string3, string);
        nameFilter = new NameFilter(string2);
        try {
            DirectoryRow directoryRow = this.crontab.getFirstRow((SearchTemplate)nameFilter);
            DirectoryRow directoryRow2 = this.crontabEntryToDirectoryRow(crontabEntries);
            this.crontab.modifyRow(directoryRow, directoryRow2);
        }
        catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            this.provHandle.logErrorAndThrow("LM_7652", "LM_7696", string2, string);
        }
        catch (DirectoryTableException directoryTableException) {
            this.provHandle.logErrorAndThrow("LM_7652", "LM_7697", string2, string, string3);
        }
        this.closeCrontab();
        CronUtility.notifyCron(this.provHandle, CronUtility.TYPE_CRON, CronUtility.ACTION_ADD, string, string);
    }

    private void openCrontab(String string, String string2) throws CIMException {
        if (this.crontab == null) {
            return;
        }
        if (!CronUtility.isUser(string2)) {
            this.provHandle.logErrorAndThrow("LM_7698", "LM_7699", string2);
        }
        int n = CronUtility.getGid(string2);
        try {
            this.crontabTableDefs.setMappedTableName(string);
            this.crontabTableDefs.setGroup(n);
            this.crontab.open(this.crontabTableDefs);
        }
        catch (DirectoryTableException directoryTableException) {
            try {
                this.crontab.create(this.crontabTableDefs);
                this.provHandle.logWarning("LM_7900", "LM_7901", string);
            }
            catch (DirectoryTableException directoryTableException2) {
                this.provHandle.logErrorAndThrow("LM_7690", "LM_7691", string);
            }
        }
        this.crontabOpen = true;
    }
}

