/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.osserver;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.solarisprovider.osserver.DBTableWrapper;
import com.sun.wbem.solarisprovider.osserver.DisklessClient;
import com.sun.wbem.solarisprovider.osserver.OsServerLog;
import com.sun.wbem.solarisprovider.osserver.OsServerNative;
import com.sun.wbem.solarisprovider.osserver.OsServerProvider;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_DisklessClient
extends OsServerProvider
implements MethodProvider,
Authorizable {
    private static String FIELDNAME_HOST_NAME = "HostName";
    private static String FIELDNAME_PW = "Pw";
    private static String FIELDNAME_NETMASK = "Netmask";
    private static String FIELDNAME_SECURITY_POLICY = "SecurityPolicy";
    private static String FIELDNAME_TERMINAL = "Terminal";
    private static String FIELDNAME_LOCALE = "Locale";
    private static String FIELDNAME_PASSWORD = "Password";
    private static String FIELDNAME_IP_ADDRESS = "IpAddress";
    private static String FIELDNAME_ETHERNET_ADDRESS = "EthernetAddress";
    private static String FIELDNAME_OS = "Os";
    private static String FIELDNAME_FILE_SERVER = "FileServer";
    private static String FIELDNAME_ROOT = "Root";
    private static String FIELDNAME_SWAP = "Swap";
    private static String FIELDNAME_NAME_SERVER_IP_ADDRESS = "NameServerIpAddress";
    private static String FIELDNAME_DUMP = "Dump";
    private static String FIELDNAME_TIME_ZONE = "TimeZone";
    private static String FIELDNAME_NAME_SERVICE = "NameService";
    private static String FIELDNAME_NAME_SERVER = "NameServer";
    private static String FIELDNAME_DOMAIN = "Domain";
    private static String FIELDNAME_SWAP_SIZE = "SwapSize";
    private static String FIELDNAME_DUMP_SIZE = "DumpSize";
    private static String FIELDNAME_SYSIDCFG = "Sysidcfg";
    private static String FIELDNAME_TYPEOFUPDATE = "TypeOfUpdate";
    private static String UPDATE_FILESYSTEM = "filesystem";
    private static String UPDATE_DATABASE = "database";
    private static String UPDATE_ALL = "all";
    private static String BOOTTYPE_DI = "di";
    private static String DEFAULT_ROOT = "/export/root/";
    private static String DEFAULT_SWAP = "/export/swap/";
    private static int DEFAULT_SWAP_SIZE = 24;
    private static int DEFAULT_DUMP_SIZE = 24;
    protected String providerName = "Solaris_DisklessClient";

    public void cleanup() throws CIMException {
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        Object object;
        Object object2;
        Object object3;
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt16 unsignedInt162 = null;
        DisklessClient disklessClient = new DisklessClient();
        boolean bl = false;
        this.provUtil.checkRights("solaris.admin.dcmgr.clients", cIMObjectPath);
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object3 = (CIMProperty)enumeration.nextElement();
            if (!object3.getName().equalsIgnoreCase(FIELDNAME_HOST_NAME)) continue;
            disklessClient.setHostName((String)object3.getValue().getValue());
        }
        if (disklessClient.getHostName() == null) {
            this.logErrorAndThrow("LM_11010", "LM_11011", FIELDNAME_HOST_NAME);
        }
        disklessClient.setNetmask((String)cIMInstance.getProperty(FIELDNAME_NETMASK).getValue().getValue());
        disklessClient.setSecurityPolicy((String)cIMInstance.getProperty(FIELDNAME_SECURITY_POLICY).getValue().getValue());
        disklessClient.setTerminal((String)cIMInstance.getProperty(FIELDNAME_TERMINAL).getValue().getValue());
        disklessClient.setLocale((String)cIMInstance.getProperty(FIELDNAME_LOCALE).getValue().getValue());
        object3 = (String)cIMInstance.getProperty(FIELDNAME_PASSWORD).getValue().getValue();
        if (object3 != null) {
            object3 = this.provUtil.decryptPassword((String)object3);
        }
        disklessClient.setPassword((String)object3);
        disklessClient.setIpAddress((String)cIMInstance.getProperty(FIELDNAME_IP_ADDRESS).getValue().getValue());
        disklessClient.setEthernetAddress((String)cIMInstance.getProperty(FIELDNAME_ETHERNET_ADDRESS).getValue().getValue());
        disklessClient.setOs((String)cIMInstance.getProperty(FIELDNAME_OS).getValue().getValue());
        disklessClient.setFileServer((String)cIMInstance.getProperty(FIELDNAME_FILE_SERVER).getValue().getValue());
        disklessClient.setRoot((String)cIMInstance.getProperty(FIELDNAME_ROOT).getValue().getValue());
        disklessClient.setSwap((String)cIMInstance.getProperty(FIELDNAME_SWAP).getValue().getValue());
        disklessClient.setNameServerIpAddress((String)cIMInstance.getProperty(FIELDNAME_NAME_SERVER_IP_ADDRESS).getValue().getValue());
        disklessClient.setDump((String)cIMInstance.getProperty(FIELDNAME_DUMP).getValue().getValue());
        disklessClient.setTimeZone((String)cIMInstance.getProperty(FIELDNAME_TIME_ZONE).getValue().getValue());
        disklessClient.setNameService((String)cIMInstance.getProperty(FIELDNAME_NAME_SERVICE).getValue().getValue());
        disklessClient.setNameServer((String)cIMInstance.getProperty(FIELDNAME_NAME_SERVER).getValue().getValue());
        disklessClient.setDomain((String)cIMInstance.getProperty(FIELDNAME_DOMAIN).getValue().getValue());
        unsignedInt16 = (UnsignedInt16)cIMInstance.getProperty(FIELDNAME_SWAP_SIZE).getValue().getValue();
        if (unsignedInt16 != null) {
            disklessClient.setSwapSize(unsignedInt16.intValue());
        }
        if ((unsignedInt162 = (UnsignedInt16)cIMInstance.getProperty(FIELDNAME_DUMP_SIZE).getValue().getValue()) != null) {
            disklessClient.setDumpSize(unsignedInt162.intValue());
        }
        disklessClient.setSysidcfg((Vector)cIMInstance.getProperty(FIELDNAME_SYSIDCFG).getValue().getValue());
        String string = (String)cIMInstance.getProperty(FIELDNAME_TYPEOFUPDATE).getValue().getValue();
        if (string == null || string.length() == 0) {
            string = UPDATE_ALL;
        }
        if (disklessClient.getRoot() == null) {
            disklessClient.setRoot(String.valueOf(DEFAULT_ROOT) + disklessClient.getHostName());
        }
        if (disklessClient.getSwap() == null) {
            disklessClient.setSwap(String.valueOf(DEFAULT_SWAP) + disklessClient.getHostName());
        }
        if (disklessClient.getSwapSize() == 0) {
            disklessClient.setSwapSize(DEFAULT_SWAP_SIZE);
        }
        if (disklessClient.getDump() != null && disklessClient.getDumpSize() == 0) {
            disklessClient.setDumpSize(DEFAULT_DUMP_SIZE);
        }
        if (string.equalsIgnoreCase(UPDATE_FILESYSTEM) || string.equalsIgnoreCase(UPDATE_ALL)) {
            object2 = new OsServerLog();
            OsServerNative.dc_add(disklessClient, (OsServerLog)object2);
            object = ((OsServerLog)object2).writeLog(this.providerName, this.cimomhandle);
            if (((OsServerLog)object2).isError()) {
                throw new CIMProviderException("GENERAL_EXCEPTION", object);
            }
            if (string.equalsIgnoreCase(UPDATE_FILESYSTEM)) {
                this.logSuccess("LM_11044");
                return null;
            }
        }
        object2 = null;
        try {
            object2 = this.getMgmtScope(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            this.logErrorAndThrow("LM_11010", "LM_11025");
        }
        if (disklessClient.getFileServer() == null || disklessClient.getFileServer().length() == 0) {
            object = null;
            try {
                object = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                this.logErrorAndThrow("LM_11010", "LM_11030");
            }
            disklessClient.setFileServer((String)object);
        }
        object = new DBTableWrapper(this.provUtil, (String)object2);
        try {
            ((DBTableWrapper)object).addDisklessClient(disklessClient);
        }
        catch (Exception exception) {
            this.logErrorAndThrow("LM_11010", exception.getLocalizedMessage());
        }
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
        cIMObjectPath2.addKey(FIELDNAME_HOST_NAME, new CIMValue((Object)disklessClient.getHostName()));
        cIMObjectPath2.addKey(FIELDNAME_TYPEOFUPDATE, new CIMValue((Object)string));
        cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)this.provUtil.getScopeClassType((String)object2)));
        cIMObjectPath2.addKey("SystemName", new CIMValue((Object)this.provUtil.getScopeDomainName((String)object2)));
        if (string.equalsIgnoreCase(UPDATE_DATABASE)) {
            this.logSuccess("LM_11045");
        }
        this.logSuccess("LM_11012", "LM_11013", disklessClient.getHostName());
        return cIMObjectPath2;
    }

    private CIMInstance createNewInstance(CIMClass cIMClass, DisklessClient disklessClient, String string) {
        UnsignedInt16 unsignedInt16;
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)this.provUtil.getScopeClassType(string)));
        cIMInstance.setProperty("SystemName", new CIMValue((Object)this.provUtil.getScopeDomainName(string)));
        cIMInstance.setProperty(FIELDNAME_HOST_NAME, new CIMValue((Object)disklessClient.getHostName()));
        cIMInstance.setProperty(FIELDNAME_TYPEOFUPDATE, new CIMValue((Object)UPDATE_ALL));
        cIMInstance.setProperty(FIELDNAME_ROOT, new CIMValue((Object)disklessClient.getRoot()));
        cIMInstance.setProperty(FIELDNAME_SWAP, new CIMValue((Object)disklessClient.getSwap()));
        cIMInstance.setProperty(FIELDNAME_DUMP, new CIMValue((Object)disklessClient.getDump()));
        short s = new Integer(disklessClient.getSwapSize()).shortValue();
        if (s > 0) {
            unsignedInt16 = this.convertShortToCIMUnsignedInt16(s);
            cIMInstance.setProperty(FIELDNAME_SWAP_SIZE, new CIMValue((Object)unsignedInt16));
        }
        if ((s = new Integer(disklessClient.getDumpSize()).shortValue()) > 0) {
            unsignedInt16 = this.convertShortToCIMUnsignedInt16(s);
            cIMInstance.setProperty(FIELDNAME_DUMP_SIZE, new CIMValue((Object)unsignedInt16));
        }
        cIMInstance.setProperty(FIELDNAME_IP_ADDRESS, new CIMValue((Object)disklessClient.getIpAddress()));
        cIMInstance.setProperty(FIELDNAME_ETHERNET_ADDRESS, new CIMValue((Object)disklessClient.getEthernetAddress()));
        cIMInstance.setProperty(FIELDNAME_TIME_ZONE, new CIMValue((Object)disklessClient.getTimeZone()));
        return cIMInstance;
    }

    public synchronized void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        Object object;
        Object object2;
        DisklessClient disklessClient = new DisklessClient();
        String string = null;
        this.provUtil.checkRights("solaris.admin.dcmgr.clients", cIMObjectPath);
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object2 = (CIMProperty)enumeration.nextElement();
            if (object2.getName().equalsIgnoreCase(FIELDNAME_HOST_NAME)) {
                disklessClient.setHostName((String)object2.getValue().getValue());
                continue;
            }
            if (!object2.getName().equalsIgnoreCase(FIELDNAME_TYPEOFUPDATE)) continue;
            string = (String)object2.getValue().getValue();
        }
        if (disklessClient.getHostName() == null) {
            this.logErrorAndThrow("LM_11018", "LM_11019", FIELDNAME_HOST_NAME);
        }
        if (string == null || string.length() == 0) {
            string = UPDATE_ALL;
        }
        if (string.equalsIgnoreCase(UPDATE_FILESYSTEM) || string.equalsIgnoreCase(UPDATE_ALL)) {
            object2 = new OsServerLog();
            OsServerNative.dc_delete(disklessClient, (OsServerLog)object2);
            object = ((OsServerLog)object2).writeLog(this.providerName, this.cimomhandle);
            if (((OsServerLog)object2).isError()) {
                throw new CIMProviderException("GENERAL_EXCEPTION", object);
            }
            if (string.equalsIgnoreCase(UPDATE_FILESYSTEM)) {
                this.logSuccess("LM_11046");
                return;
            }
        }
        object2 = null;
        try {
            object2 = this.getMgmtScope(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            this.logErrorAndThrow("LM_11018", "LM_11026");
        }
        object = new DBTableWrapper(this.provUtil, (String)object2);
        try {
            ((DBTableWrapper)object).deleteDisklessClient(disklessClient.getHostName());
        }
        catch (Exception exception) {
            this.logErrorAndThrow("LM_11018", exception.getLocalizedMessage());
        }
        if (string.equalsIgnoreCase(UPDATE_DATABASE)) {
            this.logSuccess("LM_11047");
        }
        this.logSuccess("LM_11020", "LM_11021", disklessClient.getHostName());
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkRights("solaris.admin.dcmgr.read", cIMObjectPath);
        String string = null;
        try {
            string = this.getMgmtScope(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            this.logErrorAndThrow("LM_11024", "LM_11029");
        }
        Vector vector = null;
        Vector<CIMObjectPath> vector2 = null;
        DBTableWrapper dBTableWrapper = new DBTableWrapper(this.provUtil, string);
        try {
            vector = dBTableWrapper.getDisklessClientKeys();
        }
        catch (Exception exception) {
            this.logErrorAndThrow("LM_11024", exception.getLocalizedMessage());
        }
        int n = 0;
        while (vector != null && n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
            cIMObjectPath2.addKey(FIELDNAME_HOST_NAME, new CIMValue((Object)string2));
            cIMObjectPath2.addKey(FIELDNAME_TYPEOFUPDATE, new CIMValue((Object)UPDATE_ALL));
            cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)this.provUtil.getScopeClassType(string)));
            cIMObjectPath2.addKey("SystemName", new CIMValue((Object)this.provUtil.getScopeDomainName(string)));
            if (vector2 == null) {
                vector2 = new Vector<CIMObjectPath>();
            }
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        this.provUtil.checkRights("solaris.admin.dcmgr.read", cIMObjectPath);
        String string = null;
        try {
            string = this.getMgmtScope(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            this.logErrorAndThrow("LM_11024", "LM_11029");
        }
        Vector vector = null;
        Vector<CIMInstance> vector2 = null;
        DisklessClient disklessClient = null;
        DBTableWrapper dBTableWrapper = new DBTableWrapper(this.provUtil, string);
        try {
            vector = dBTableWrapper.listDisklessClients();
        }
        catch (Exception exception) {
            this.logErrorAndThrow("LM_11024", exception.getLocalizedMessage());
        }
        int n = 0;
        while (vector != null && n < vector.size()) {
            disklessClient = (DisklessClient)vector.elementAt(n);
            CIMInstance cIMInstance = this.createNewInstance(cIMClass, disklessClient, string);
            if (vector2 == null) {
                vector2 = new Vector<CIMInstance>();
            }
            vector2.addElement(cIMInstance);
            ++n;
        }
        return vector2;
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkRights("solaris.admin.dcmgr.read", cIMObjectPath);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        Object object;
        String string = null;
        this.provUtil.checkRights("solaris.admin.dcmgr.read", cIMObjectPath);
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (!object.getName().equalsIgnoreCase(FIELDNAME_HOST_NAME)) continue;
            string = (String)object.getValue().getValue();
        }
        if (string == null) {
            this.logErrorAndThrow("LM_11022", "LM_11023", FIELDNAME_HOST_NAME);
        }
        object = null;
        try {
            object = this.getMgmtScope(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            this.logErrorAndThrow("LM_11022", "LM_11028");
        }
        DBTableWrapper dBTableWrapper = new DBTableWrapper(this.provUtil, (String)object);
        DisklessClient disklessClient = null;
        try {
            disklessClient = dBTableWrapper.getDisklessClient(string);
        }
        catch (Exception exception) {
            this.logErrorAndThrow("LM_11022", exception.getLocalizedMessage());
        }
        CIMInstance cIMInstance = this.createNewInstance(cIMClass, disklessClient, (String)object);
        return cIMInstance;
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        CIMValue cIMValue = new CIMValue((Object)new Integer(1));
        if (string.equalsIgnoreCase("getBestNetIf")) {
            this.provUtil.checkRights("solaris.admin.dcmgr.read", cIMObjectPath);
            String string2 = (String)((CIMValue)vector.elementAt(0)).getValue();
            String string3 = (String)((CIMValue)vector.elementAt(1)).getValue();
            String string4 = (String)((CIMValue)vector.elementAt(2)).getValue();
            OsServerLog osServerLog = new OsServerLog();
            String string5 = OsServerNative.dc_get_best_net_if(string2, string3, string4, osServerLog);
            if (string5 != null) {
                vector2.add(new CIMValue((Object)string5));
            } else {
                vector2.add(new CIMValue((Object)new String("")));
            }
            String string6 = osServerLog.writeLog(this.providerName, this.cimomhandle);
            if (osServerLog.isError()) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string6);
            }
            cIMValue = new CIMValue((Object)new Integer(0));
            return cIMValue;
        }
        return cIMValue;
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        Object object;
        DisklessClient disklessClient = new DisklessClient();
        this.provUtil.checkRights("solaris.admin.dcmgr.clients", cIMObjectPath);
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (!object.getName().equalsIgnoreCase(FIELDNAME_HOST_NAME)) continue;
            disklessClient.setHostName((String)object.getValue().getValue());
        }
        if (disklessClient.getHostName() == null) {
            this.logErrorAndThrow("LM_11014", "LM_11015", FIELDNAME_HOST_NAME);
        }
        disklessClient.setEthernetAddress((String)cIMInstance.getProperty(FIELDNAME_ETHERNET_ADDRESS).getValue().getValue());
        if (disklessClient.getEthernetAddress() == null) {
            this.logErrorAndThrow("LM_11014", "LM_11015", FIELDNAME_ETHERNET_ADDRESS);
        }
        disklessClient.setTimeZone((String)cIMInstance.getProperty(FIELDNAME_TIME_ZONE).getValue().getValue());
        object = null;
        try {
            object = this.getMgmtScope(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            this.logErrorAndThrow("LM_11014", "LM_11027");
        }
        DBTableWrapper dBTableWrapper = new DBTableWrapper(this.provUtil, (String)object);
        try {
            dBTableWrapper.modifyDisklessClient(disklessClient);
        }
        catch (Exception exception) {
            this.logErrorAndThrow("LM_11014", exception.getLocalizedMessage());
        }
        this.logSuccess("LM_11016", "LM_11017", disklessClient.getHostName());
    }
}

