/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.fsmgr.fstype;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrException;
import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrNetCfgTable;
import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrNfsSecTable;
import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrNfsSecurityModeException;
import com.sun.wbem.solarisprovider.fsmgr.common.Solaris_FileSystem_Data;
import com.sun.wbem.solarisprovider.fsmgr.common.Solaris_FileSystem_Native;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Solaris_NFS
implements InstanceProvider,
MethodProvider,
Authorizable {
    private static final String FSMGR_READ_RIGHT = "solaris.admin.fsmgr.read";
    private Hashtable hash = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil;
    private static final String providerName = "Solaris_NFS";

    public void cleanup() throws CIMException {
    }

    private UnsignedInt32 convertIntToCIMUnsignedInt(int n) {
        try {
            return new UnsignedInt32(Integer.toString(n));
        }
        catch (Exception exception) {
            return new UnsignedInt32("0");
        }
    }

    private UnsignedInt64 convertLongToCIMUnsignedLong(long l) {
        try {
            return new UnsignedInt64(new BigInteger(Long.toString(l)));
        }
        catch (Exception exception) {
            return new UnsignedInt64(new BigInteger("0"));
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMInstance createNewInstance(CIMClass cIMClass, Solaris_FileSystem_Data solaris_FileSystem_Data) throws Exception {
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        cIMInstance.setProperty("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)providerName));
        cIMInstance.setProperty("Name", new CIMValue((Object)solaris_FileSystem_Data.getMountPoint()));
        cIMInstance.setProperty("Root", new CIMValue((Object)solaris_FileSystem_Data.getDevice()));
        UnsignedInt64 unsignedInt64 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getBlockSize());
        cIMInstance.setProperty("BlockSize", new CIMValue((Object)unsignedInt64));
        UnsignedInt64 unsignedInt642 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getFileSystemSize());
        cIMInstance.setProperty("FileSystemSize", new CIMValue((Object)unsignedInt642));
        UnsignedInt64 unsignedInt643 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getAvailableSpace());
        cIMInstance.setProperty("AvailableSpace", new CIMValue((Object)unsignedInt643));
        cIMInstance.setProperty("ReadOnly", new CIMValue((Object)new Boolean(solaris_FileSystem_Data.getReadOnly())));
        cIMInstance.setProperty("EncryptionMethod", new CIMValue((Object)"Unknown"));
        cIMInstance.setProperty("CompressionMethod", new CIMValue((Object)"Unknown"));
        cIMInstance.setProperty("CaseSensitive", new CIMValue((Object)new Boolean(true)));
        cIMInstance.setProperty("CasePreserved", new CIMValue((Object)new Boolean(true)));
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        vector.addElement(new UnsignedInt16(0));
        cIMInstance.setProperty("CodeSet", new CIMValue(vector));
        UnsignedInt32 unsignedInt32 = this.convertIntToCIMUnsignedInt(solaris_FileSystem_Data.getMaxFileNameLength());
        cIMInstance.setProperty("MaxFileNameLength", new CIMValue((Object)unsignedInt32));
        cIMInstance.setProperty("ClusterSize", new CIMValue((Object)new UnsignedInt32(Integer.toString(solaris_FileSystem_Data.getClusterSize()))));
        UnsignedInt32 unsignedInt322 = this.convertIntToCIMUnsignedInt(solaris_FileSystem_Data.getClusterSize());
        cIMInstance.setProperty("FileSystemType", new CIMValue((Object)solaris_FileSystem_Data.getFileSystemType()));
        UnsignedInt64 unsignedInt644 = this.convertLongToCIMUnsignedLong(solaris_FileSystem_Data.getUsedSpace());
        cIMInstance.setProperty("UsedSpace", new CIMValue((Object)unsignedInt644));
        return cIMInstance;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkRights(FSMGR_READ_RIGHT, cIMObjectPath);
        Vector<CIMObjectPath> vector = null;
        try {
            this.hash = this.getNFSFileSystemData();
            vector = new Vector<CIMObjectPath>();
            Enumeration enumeration = this.hash.elements();
            while (enumeration.hasMoreElements()) {
                Solaris_FileSystem_Data solaris_FileSystem_Data = (Solaris_FileSystem_Data)enumeration.nextElement();
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath2.addKey("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)providerName));
                cIMObjectPath2.addKey("Name", new CIMValue((Object)solaris_FileSystem_Data.getMountPoint()));
                vector.addElement(cIMObjectPath2);
            }
        }
        catch (Exception exception) {
            String string = this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return vector;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        this.provUtil.checkRights(FSMGR_READ_RIGHT, cIMObjectPath);
        Vector<CIMInstance> vector = null;
        try {
            this.hash = this.getNFSFileSystemData();
            vector = new Vector<CIMInstance>();
            Enumeration enumeration = this.hash.elements();
            while (enumeration.hasMoreElements()) {
                Solaris_FileSystem_Data solaris_FileSystem_Data = (Solaris_FileSystem_Data)enumeration.nextElement();
                CIMInstance cIMInstance = this.createNewInstance(cIMClass, solaris_FileSystem_Data);
                vector.addElement(cIMInstance);
            }
        }
        catch (Exception exception) {
            String string = this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return vector;
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Integer getDefaultNfsSecMode(Vector vector) throws FsMgrException {
        FsMgrNfsSecTable fsMgrNfsSecTable;
        String string = null;
        try {
            fsMgrNfsSecTable = new FsMgrNfsSecTable(this);
            string = fsMgrNfsSecTable.getDefaultSecurityMode();
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, "LM_4048", "LM_4073", null, null, null, null);
            throw new FsMgrNfsSecurityModeException("EXM_FSS_NOMODE");
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_4051", "LM_4073", null, null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        if (string == null) {
            throw new FsMgrNfsSecurityModeException("EXM_FSS_NOMODE");
        }
        fsMgrNfsSecTable = new CIMValue((Object)string);
        vector.addElement(fsMgrNfsSecTable);
        return new Integer(0);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        this.provUtil.checkRights(FSMGR_READ_RIGHT, cIMObjectPath);
        try {
            Solaris_FileSystem_Data solaris_FileSystem_Data;
            String string = "";
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                solaris_FileSystem_Data = (CIMProperty)enumeration.nextElement();
                if (!solaris_FileSystem_Data.getName().equalsIgnoreCase("Name")) continue;
                string = (String)solaris_FileSystem_Data.getValue().getValue();
            }
            solaris_FileSystem_Data = this.getNFSFileSystemData(string);
            if (solaris_FileSystem_Data != null) {
                CIMInstance cIMInstance = this.createNewInstance(cIMClass, solaris_FileSystem_Data);
                return cIMInstance;
            }
        }
        catch (Exception exception) {
            String string = this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return null;
    }

    private Hashtable getNFSFileSystemData() {
        Hashtable<String, Solaris_FileSystem_Data> hashtable = new Hashtable<String, Solaris_FileSystem_Data>();
        Vector vector = new Vector();
        vector = (Vector)Solaris_FileSystem_Native.getFileSystemData();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Solaris_FileSystem_Data solaris_FileSystem_Data = (Solaris_FileSystem_Data)vector.elementAt(n);
                if (solaris_FileSystem_Data.getFileSystemType().equalsIgnoreCase("nfs")) {
                    hashtable.put(solaris_FileSystem_Data.getMountPoint(), solaris_FileSystem_Data);
                }
                ++n;
            }
        }
        return hashtable;
    }

    private Solaris_FileSystem_Data getNFSFileSystemData(String string) {
        Vector vector = new Vector();
        vector = (Vector)Solaris_FileSystem_Native.getFileSystemData();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Solaris_FileSystem_Data solaris_FileSystem_Data = (Solaris_FileSystem_Data)vector.elementAt(n);
                if (solaris_FileSystem_Data.getFileSystemType().equalsIgnoreCase("nfs") && solaris_FileSystem_Data.getMountPoint().equals(string)) {
                    return solaris_FileSystem_Data;
                }
                ++n;
            }
        }
        return null;
    }

    public Integer getNetCfgList(Vector vector) throws FsMgrException {
        Object[] objectArray;
        Vector vector2 = null;
        try {
            objectArray = new FsMgrNetCfgTable(this);
            vector2 = objectArray.list();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            this.provUtil.writeLog(2, "LM_4049", "LM_4070", null, null, null, null);
            throw new FsMgrException("EXM_FSS_CFGLST_DTDNE_TRY");
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.provUtil.writeLog(2, "LM_4050", "LM_4070", null, null, null, null);
            throw new FsMgrException("EXM_FSS_CFGLST_DTACC");
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, "LM_4048", "LM_4070", null, null, null, null);
            throw new FsMgrException("EXM_FSS_CFGLST_DTERR_TRY");
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_4051", "LM_4070", null, null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        Vector<Object> vector3 = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector3.addElement(objectArray[n]);
            ++n;
        }
        CIMValue cIMValue = new CIMValue(vector3);
        vector.addElement(cIMValue);
        return new Integer(0);
    }

    public Integer getNfsSecList(Vector vector) throws FsMgrException {
        Object[] objectArray;
        Vector vector2 = null;
        try {
            objectArray = new FsMgrNfsSecTable(this);
            vector2 = objectArray.listModes();
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, "LM_4048", "LM_4073", null, null, null, null);
            throw new FsMgrNfsSecurityModeException("EXM_FSS_NOMODES");
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_4051", "LM_4073", null, null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        Vector<Object> vector3 = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector3.addElement(objectArray[n]);
            ++n;
        }
        CIMValue cIMValue = new CIMValue(vector3);
        vector.addElement(cIMValue);
        return new Integer(0);
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, providerName);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        this.provUtil.checkRights(FSMGR_READ_RIGHT, cIMObjectPath);
        try {
            if (string.equalsIgnoreCase("getNfsSecList")) {
                return new CIMValue((Object)this.getNfsSecList(vector2));
            }
            if (string.equalsIgnoreCase("getDefaultNfsSecMode")) {
                return new CIMValue((Object)this.getDefaultNfsSecMode(vector2));
            }
            if (string.equalsIgnoreCase("getNetCfgList")) {
                return new CIMValue((Object)this.getNetCfgList(vector2));
            }
        }
        catch (FsMgrException fsMgrException) {
            String string2 = this.provUtil.writeLog(2, fsMgrException);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return null;
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

