/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.computersystem;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.ProviderCIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.computersystem.SystemPowerMgtData;
import com.sun.wbem.solarisprovider.packaging.Solaris_Package;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_ComputerSystem
implements Authorizable,
InstanceProvider,
MethodProvider {
    public static final String COMPSYS_WRITE_RIGHT = "solaris.compsys.write";
    public static final String COMPSYS_READ_RIGHT = "solaris.compsys.read";
    private ProviderCIMOMHandle cimomhandle = null;
    static ProviderUtility provUtil = null;
    private String providerName = "Solaris_ComputerSystem";

    static {
        System.loadLibrary("solprov");
    }

    native String GetMachineType();

    public Boolean Reboot() {
        int n = 0;
        while (n < 2) {
            if (this.runCommand("sync", true) != 0) {
                return new Boolean(false);
            }
            ++n;
        }
        this.runCommand("reboot", true);
        return new Boolean(false);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        try {
            Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
            cIMObjectPath2.addKey("Name", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            vector.addElement(cIMObjectPath2);
            return vector;
        }
        catch (Exception exception) {
            provUtil.writeLog(2, "LM_9000", "LM_9001", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        try {
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            String string = InetAddress.getLocalHost().getHostName();
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("Name", new CIMValue((Object)string));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMInstance.setProperty("Status", new CIMValue((Object)"0"));
            String string2 = InetAddress.getLocalHost().getHostName();
            String string3 = InetAddress.getLocalHost().getHostAddress();
            cIMInstance.setProperty("Caption", new CIMValue((Object)(String.valueOf(string2) + ":" + string3)));
            cIMInstance.setProperty("Description", new CIMValue((Object)this.GetMachineType()));
            cIMInstance.setProperty("ResetCapability", new CIMValue((Object)new UnsignedInt16(2)));
            cIMInstance.setProperty("PowerManagementSupported", this.getPowerManagement());
            cIMInstance.setProperty("NameFormat", new CIMValue((Object)"IP"));
            Vector vector2 = new Vector();
            vector2 = SystemPowerMgtData.getSystemPowerMgtData();
            if (vector2 == null) {
                vector2 = new Vector();
                int n = 0;
                while (n < 4) {
                    vector2.addElement(null);
                    ++n;
                }
            }
            if (vector2.size() == 4) {
                cIMInstance.setProperty("AutoShutdownIdleTime", new CIMValue((Object)((String)vector2.elementAt(0))));
                cIMInstance.setProperty("AutoShutdownStartTime", new CIMValue((Object)((String)vector2.elementAt(1))));
                cIMInstance.setProperty("AutoShutdownStopTime", new CIMValue((Object)((String)vector2.elementAt(2))));
                cIMInstance.setProperty("AutoShutdownBehavior", new CIMValue((Object)((String)vector2.elementAt(3))));
            }
            vector.addElement(cIMInstance);
            return vector;
        }
        catch (Exception exception) {
            provUtil.writeLog(2, "LM_9000", "LM_9001", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) {
        return null;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        try {
            CIMInstance cIMInstance;
            String string = "";
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMProperty)enumeration.nextElement();
                if (!cIMInstance.getName().equalsIgnoreCase("name")) continue;
                string = (String)cIMInstance.getValue().getValue();
            }
            cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("Name", new CIMValue((Object)string));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMInstance.setProperty("Status", new CIMValue((Object)"0"));
            String string2 = InetAddress.getLocalHost().getHostName();
            String string3 = InetAddress.getLocalHost().getHostAddress();
            cIMInstance.setProperty("Caption", new CIMValue((Object)(String.valueOf(string2) + ":" + string3)));
            cIMInstance.setProperty("Description", new CIMValue((Object)this.GetMachineType()));
            cIMInstance.setProperty("ResetCapability", new CIMValue((Object)new UnsignedInt16(2)));
            cIMInstance.setProperty("PowerManagementSupported", this.getPowerManagement());
            cIMInstance.setProperty("NameFormat", new CIMValue((Object)"IP"));
            Vector vector = new Vector();
            vector = SystemPowerMgtData.getSystemPowerMgtData();
            if (vector == null) {
                vector = new Vector();
                int n = 0;
                while (n < 4) {
                    vector.addElement(null);
                    ++n;
                }
            }
            if (vector.size() == 4) {
                cIMInstance.setProperty("AutoShutdownIdleTime", new CIMValue((Object)((String)vector.elementAt(0))));
                cIMInstance.setProperty("AutoShutdownStartTime", new CIMValue((Object)((String)vector.elementAt(1))));
                cIMInstance.setProperty("AutoShutdownStopTime", new CIMValue((Object)((String)vector.elementAt(2))));
                cIMInstance.setProperty("AutoShutdownBehavior", new CIMValue((Object)((String)vector.elementAt(3))));
            }
            return cIMInstance;
        }
        catch (Exception exception) {
            provUtil.writeLog(2, "LM_9000", "LM_9001", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
    }

    private CIMValue getPowerManagement() {
        Solaris_Package solaris_Package = new Solaris_Package();
        String string = solaris_Package.getPkgStatus("SUNWpmu");
        if (string.equals("0")) {
            return CIMValue.TRUE;
        }
        String string2 = solaris_Package.getPkgStatus("SUNWpmux");
        if (string2.equals("0")) {
            return CIMValue.TRUE;
        }
        return CIMValue.FALSE;
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)cIMOMHandle;
        provUtil = new ProviderUtility(cIMOMHandle, this.providerName);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        provUtil.checkRights(COMPSYS_WRITE_RIGHT, cIMObjectPath);
        try {
            if (string.equalsIgnoreCase("reboot")) {
                return new CIMValue((Object)this.Reboot());
            }
            if (string.equalsIgnoreCase("setpowermgtdata")) {
                int n = (Integer)((CIMValue)vector.elementAt(0)).getValue();
                int n2 = (Integer)((CIMValue)vector.elementAt(1)).getValue();
                int n3 = (Integer)((CIMValue)vector.elementAt(2)).getValue();
                int n4 = (Integer)((CIMValue)vector.elementAt(3)).getValue();
                int n5 = (Integer)((CIMValue)vector.elementAt(4)).getValue();
                int n6 = (Integer)((CIMValue)vector.elementAt(5)).getValue();
                SystemPowerMgtData systemPowerMgtData = new SystemPowerMgtData(n, n2, n3, n4, n5, n6, provUtil);
                return new CIMValue((Object)new Integer(systemPowerMgtData.setSystemPowerMgtData()));
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private int runCommand(String string, boolean bl) {
        int n = -1;
        try {
            Process process = Runtime.getRuntime().exec(string);
            if (bl) {
                process.waitFor();
                n = process.exitValue();
            }
        }
        catch (Exception exception) {}
        return n;
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

