/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.common;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.ProviderCIMOMHandle;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import com.sun.wbem.utility.directorytable.DirectoryTableSetup;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Vector;

public class ProviderUtility {
    public static final String MGMT_DOMAIN_KEY = "SystemName";
    public static final String MGMT_TYPE_KEY = "SystemCreationClassName";
    public static final String FILE_SCOPE_TYPE = "file";
    public static final String NIS_SCOPE_TYPE = "nis";
    public static final String NISPLUS_SCOPE_TYPE = "nisplus";
    public static final String LDAP_SCOPE_TYPE = "ldap";
    public static final String DNS_SCOPE_TYPE = "dns";
    public static final String DFLT_SCOPE_TYPE = "file";
    private static final String GUEST = "guest";
    private static final String[] MGMT_CLASS_TABLE = new String[]{"Solaris_SystemAdminDomain", "Solaris_NisAdminDomain", "Solaris_NisplusAdminDomain", "Solaris_LdapAdminDomain", "Solaris_DnsAdminDomain"};
    private static final String[] MGMT_TYPE_TABLE = new String[]{"file", "nis", "nisplus", "ldap", "dns"};
    private ProviderCIMOMHandle cimomhandle = null;
    private String providerName = null;
    private LogUtil logUtil = null;
    private String hostname = null;
    private Vector mgmtScopes = null;
    private DirectoryTableSetup dirtbl = null;

    public ProviderUtility(CIMOMHandle cIMOMHandle, String string) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)cIMOMHandle;
        this.providerName = string;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)this.cimomhandle);
    }

    public String checkAuthenticated() throws CIMException {
        String string = this.getClientUserName();
        if (string == null) {
            this.logUtil.writeLog(this.providerName, "LM_1001", "LM_1010", null, "", false, 1, 2);
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
        if (string.equals(GUEST)) {
            this.logUtil.writeLog(this.providerName, "LM_1001", "LM_1011", null, "", false, 1, 1);
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
        return string;
    }

    public void checkRights(String string, CIMObjectPath cIMObjectPath) throws CIMException {
        String string2 = this.checkAuthenticated();
        if (!AuthorizationUtility.checkAuthName((String)string2, (String)string)) {
            String[] stringArray = new String[]{string2};
            this.logUtil.writeLog(this.providerName, "LM_1001", "LM_1012", stringArray, "", false, 1, 1);
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
    }

    public UnsignedInt32 convertIntToCIMUnsignedInt(int n) {
        try {
            return new UnsignedInt32(Integer.toString(n));
        }
        catch (Exception exception) {
            return new UnsignedInt32("0");
        }
    }

    public UnsignedInt16 convertShortToCIMUnsignedInt16(short s) {
        try {
            return new UnsignedInt16(Short.toString(s));
        }
        catch (Exception exception) {
            return new UnsignedInt16("0");
        }
    }

    public String decryptPassword(String string) {
        return this.cimomhandle.decryptData(string);
    }

    public ProviderCIMOMHandle getCimomHandle() {
        return this.cimomhandle;
    }

    public String getClientUserName() {
        String string = this.cimomhandle.getCurrentRole();
        if (string == null || string.trim().length() == 0) {
            string = this.cimomhandle.getCurrentUser();
        }
        return string;
    }

    public String getDefaultScope() {
        String string = this.getServerHostName();
        String string2 = "file:/" + string + "/" + string;
        return string2;
    }

    public String getMgmtScope(CIMInstance cIMInstance) throws CIMException {
        String string = null;
        String string2 = null;
        if (cIMInstance != null) {
            CIMValue cIMValue;
            CIMProperty cIMProperty = cIMInstance.getProperty(MGMT_DOMAIN_KEY);
            if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                string = (String)cIMValue.getValue();
            }
            if ((cIMProperty = cIMInstance.getProperty(MGMT_TYPE_KEY)) != null && (cIMValue = cIMProperty.getValue()) != null) {
                string2 = (String)cIMValue.getValue();
            }
        }
        return this.getMgmtScope(string2, string);
    }

    public String getMgmtScope(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = null;
        String string2 = null;
        Vector vector = null;
        if (cIMObjectPath != null) {
            vector = cIMObjectPath.getKeys();
        }
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                CIMValue cIMValue;
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
                if (cIMProperty.getName().equalsIgnoreCase(MGMT_DOMAIN_KEY) && (cIMValue = cIMProperty.getValue()) != null) {
                    string = (String)cIMValue.getValue();
                }
                if (cIMProperty.getName().equalsIgnoreCase(MGMT_TYPE_KEY) && (cIMValue = cIMProperty.getValue()) != null) {
                    string2 = (String)cIMValue.getValue();
                }
                ++n;
            }
        }
        return this.getMgmtScope(string2, string);
    }

    public String getMgmtScope(String string, String string2) throws CIMException {
        int n;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        if (string == null && string2 == null) {
            return this.getDefaultScope();
        }
        string3 = this.getScopeTypeFromClass(string);
        if (string3 == null) {
            string7 = this.writeLog(2, "LM_2410", "LM_2414", string, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string7);
        }
        if (string3.equals("file")) {
            bl = true;
        }
        string5 = this.getServerHostName();
        if (string2 == null || string2.trim().length() == 0) {
            if (bl) {
                return this.getDefaultScope();
            }
            string7 = this.writeLog(2, "LM_2410", "LM_2413", string3, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string7);
        }
        string4 = string2;
        if (bl && (n = string2.indexOf(46)) > 0) {
            string4 = string2.substring(0, n);
        }
        string6 = String.valueOf(string3) + ":/" + string5 + "/" + string4;
        if (this.dirtbl == null) {
            this.dirtbl = new DirectoryTableSetup();
        }
        if (!this.dirtbl.isValidScope(string6)) {
            string7 = this.writeLog(2, "LM_2410", "LM_2411", string6, string5, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string7);
        }
        return string6;
    }

    public String getScopeClassFromType(String string) {
        String string2 = "";
        int n = 0;
        while (n < MGMT_TYPE_TABLE.length) {
            if (string.equals(MGMT_TYPE_TABLE[n])) {
                string2 = MGMT_CLASS_TABLE[n];
                break;
            }
            ++n;
        }
        return string2;
    }

    public String getScopeClassType(String string) {
        int n;
        String string2;
        if (string == null || string.trim().length() == 0) {
            string2 = "file";
        }
        string2 = (n = string.indexOf(58)) < 1 ? "file" : string.substring(0, n);
        return this.getScopeClassFromType(string2);
    }

    public String getScopeDomainName(String string) {
        int n;
        if (string != null && string.trim().length() > 0 && (n = string.lastIndexOf(47)) > 0 && n < string.length()) {
            return string.substring(n + 1);
        }
        if (string.startsWith("file")) {
            return this.getServerHostName();
        }
        return "";
    }

    private Vector getScopeList() {
        Vector vector = null;
        try {
            DirectoryTableSetup directoryTableSetup = new DirectoryTableSetup();
            vector = directoryTableSetup.getScopes(2);
        }
        catch (Exception exception) {
            vector = new Vector(0);
        }
        return vector;
    }

    public String getScopeType(String string) {
        int n;
        if (string != null && string.trim().length() > 0 && (n = string.indexOf(58)) > 0) {
            return string.substring(0, n);
        }
        return "";
    }

    public String getScopeTypeFromClass(String string) {
        String string2 = null;
        if (string != null) {
            int n = 0;
            while (n < MGMT_CLASS_TABLE.length) {
                if (string.equals(MGMT_CLASS_TABLE[n])) {
                    string2 = MGMT_TYPE_TABLE[n];
                    break;
                }
                ++n;
            }
        }
        return string2;
    }

    public String getServerHostName() {
        if (this.hostname == null) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                this.hostname = "??";
            }
            int n = this.hostname.indexOf(46);
            if (n > 0) {
                this.hostname = this.hostname.substring(0, n);
            }
        }
        return this.hostname;
    }

    public boolean isClientRole() {
        boolean bl = false;
        String string = this.cimomhandle.getCurrentRole();
        if (string != null && string.trim().length() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean testRights(String string, CIMObjectPath cIMObjectPath) {
        boolean bl = false;
        String string2 = this.getClientUserName();
        if (string2 != null && !string2.equals(GUEST)) {
            return AuthorizationUtility.checkAuthName((String)string2, (String)string);
        }
        return false;
    }

    public String writeLog(int n, Exception exception) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        if (n == 2) {
            bl = true;
        }
        try {
            string2 = exception.getLocalizedMessage();
            String[] stringArray = new String[]{string2};
            string = this.logUtil.writeLog(this.providerName, "LM_2001", "LM_2100", stringArray, null, bl, 0, n);
        }
        catch (Exception exception2) {}
        if (string == null) {
            string = string2;
        }
        return string;
    }

    public String writeLog(int n, String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = null;
        boolean bl = false;
        if (n == 2) {
            bl = true;
        }
        try {
            String[] stringArray = new String[]{string3, string4, string5, string6};
            string7 = this.logUtil.writeLog(this.providerName, string, string2, stringArray, "", bl, 0, n);
        }
        catch (Exception exception) {}
        return string7;
    }
}

