/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.common;

import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.PopupMsg;
import com.sun.wbem.apps.common.Util;
import com.sun.wbem.apps.common.WaitDialog;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.client.CIMClient;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreePane
extends JScrollPane
implements ActionListener,
TreeSelectionListener,
TreeExpansionListener,
MouseListener {
    protected JTree tree;
    protected DefaultTreeSelectionModel selectionModel;
    protected DefaultTreeModel treeModel;
    protected JComboBox objectBox;
    protected CIMClient cimClient = null;
    protected CIMClientObject cimClientObject;
    protected DefaultMutableTreeNode root;
    protected JPopupMenu popupMenu;
    protected JPopupMenu rootPopupMenu;
    protected Window thisWindow;
    protected PopupMsg popupMsg = new PopupMsg();
    protected final int CLASS_TREE = 0;
    protected final int NAMESPACE_TREE = 1;
    protected int treeType;

    public TreePane() {
        this.popupMenu = new JPopupMenu();
        this.rootPopupMenu = new JPopupMenu();
        this.root = new DefaultMutableTreeNode("root");
        this.tree = new JTree(this.root);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeExpansionListener(this);
        this.tree.addMouseListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
        this.treeModel = new DefaultTreeModel(this.root);
        this.selectionModel = (DefaultTreeSelectionModel)this.tree.getSelectionModel();
        this.setViewportView(this.tree);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void addNodeToSelected(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
    }

    public void addNodeToSelected(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getSelectedNode();
        defaultMutableTreeNode2.setAllowsChildren(true);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, 0);
    }

    protected void addSubNodes(DefaultMutableTreeNode defaultMutableTreeNode, Enumeration enumeration) {
        defaultMutableTreeNode.setAllowsChildren(enumeration.hasMoreElements());
        int n = 0;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        while (enumeration.hasMoreElements()) {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.treeType == 1 ? new DefaultMutableTreeNode(this.getLastElementInPath(cIMObjectPath.getNameSpace())) : new DefaultMutableTreeNode(cIMObjectPath.getObjectName());
            if (defaultTreeModel.getIndexOfChild(defaultMutableTreeNode, defaultMutableTreeNode2) >= 0) continue;
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n++);
        }
    }

    protected void addSubNodesToChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        int n = defaultTreeModel.getChildCount(defaultMutableTreeNode);
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultTreeModel.getChild(defaultMutableTreeNode, n2);
            if (defaultTreeModel.getChildCount(defaultMutableTreeNode2) == 0) {
                try {
                    Enumeration enumeration;
                    if (this.treeType == 1) {
                        String string = this.getPathBeforeRootString(defaultMutableTreeNode2);
                        enumeration = this.cimClient.enumNameSpace(new CIMObjectPath("", string), false);
                    } else {
                        enumeration = this.cimClient.enumClass(new CIMObjectPath(defaultMutableTreeNode2.toString()), false);
                    }
                    if (enumeration.hasMoreElements()) {
                        this.addSubNodes(defaultMutableTreeNode2, enumeration);
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    protected void cleanTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        while (defaultTreeModel.getChildCount(defaultMutableTreeNode) > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultTreeModel.getChild(defaultMutableTreeNode, 0);
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
    }

    protected void deleteNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
        defaultTreeModel.reload();
    }

    protected void deleteNode(TreePath treePath) {
        this.deleteNode((DefaultMutableTreeNode)treePath.getLastPathComponent());
    }

    protected void deleteSelectedNode() {
        int n = this.tree.getLeadSelectionRow();
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        this.deleteNode(defaultMutableTreeNode);
        if (this.tree.getRowCount() == 0) {
            return;
        }
        if (n >= this.tree.getRowCount()) {
            --n;
        }
        this.tree.setSelectionRow(n);
    }

    protected void generateTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.cleanTree(defaultMutableTreeNode);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        CIMObjectPath cIMObjectPath = defaultMutableTreeNode == this.root ? new CIMObjectPath() : new CIMObjectPath(defaultMutableTreeNode.toString());
        try {
            int n = 0;
            Enumeration enumeration = this.treeType == 1 ? this.cimClient.enumNameSpace(cIMObjectPath, false) : this.cimClient.enumClass(cIMObjectPath, false);
            while (enumeration.hasMoreElements()) {
                Enumeration enumeration2;
                String string;
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                if (this.treeType == 1) {
                    string = this.getLastElementInPath(cIMObjectPath2.getNameSpace());
                    enumeration2 = this.cimClient.enumNameSpace(cIMObjectPath2, false);
                } else {
                    string = cIMObjectPath2.getObjectName();
                    enumeration2 = this.cimClient.enumClass(cIMObjectPath2, false);
                }
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
                defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n++);
                if (!enumeration2.hasMoreElements()) continue;
                this.addSubNodes(defaultMutableTreeNode2, enumeration2);
            }
        }
        catch (CIMException cIMException) {
            CIMErrorDialog.display(this, cIMException);
        }
    }

    public String getLastElementInPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public String getPathBeforeRootString(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == this.root) {
            return "";
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.pathFromAncestorEnumeration(this.root);
        StringBuffer stringBuffer = new StringBuffer("");
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(String.valueOf(((DefaultMutableTreeNode)enumeration.nextElement()).toString()) + "\\");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public String getPathString(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.pathFromAncestorEnumeration(this.root);
        StringBuffer stringBuffer = new StringBuffer("");
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(String.valueOf(((DefaultMutableTreeNode)enumeration.nextElement()).toString()) + "\\");
        }
        stringBuffer.insert(0, this.root.toString());
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public String getPathString(TreePath treePath) {
        Object[] objectArray = treePath.getPath();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(String.valueOf(objectArray[n].toString()) + "\\");
            ++n;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public DefaultMutableTreeNode getSelectedNode() {
        if (this.tree.getSelectionPath() == null) {
            return null;
        }
        return (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    public TreePath getSelectedPath() {
        return this.tree.getSelectionPath();
    }

    public String getSelectedPathString() {
        return this.getPathString(this.tree.getSelectionPath());
    }

    protected void insertNewSubNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        if (defaultTreeModel.getIndexOfChild(defaultMutableTreeNode, defaultMutableTreeNode2 = new DefaultMutableTreeNode(string)) < 0) {
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultTreeModel.getChildCount(defaultMutableTreeNode));
        }
    }

    public boolean isRootSelected() {
        return this.getSelectedNode() == this.root;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void setCIMClient() {
        WaitDialog waitDialog = new WaitDialog(Util.getFrame(this), I18N.loadString("LBL_WAIT", "com.sun.wbem.apps.common.common"), I18N.loadString("MSG_ENUM_CLASSES"));
        ((Component)waitDialog).setLocation(Util.getCenterPoint(Util.getFrame(this), waitDialog));
        Thread thread = new Thread(waitDialog);
        thread.start();
        waitDialog.setVisible(true);
        this.cimClient = CIMClientObject.getClient();
        this.root.setUserObject(CIMClientObject.getNameSpace());
        this.generateTree(this.root);
        this.tree.expandPath(new TreePath(this.root));
        this.tree.setSelectionRow(0);
        this.tree.repaint();
        thread.stop();
        thread = null;
        waitDialog.dispose();
    }

    protected void showPopupMenu(Point point) {
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return;
        }
        this.tree.setSelectionPath(treePath);
        if (this.getSelectedNode() != this.root) {
            Point point2 = this.getViewport().getViewPosition();
            this.popupMenu.show(this, point.x - point2.x + 10, point.y - point2.y);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Cursor cursor = this.getCursor();
        Util.setWaitCursor(this);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        if (defaultMutableTreeNode == this.root) {
            return;
        }
        this.addSubNodesToChildren(defaultMutableTreeNode);
        Util.setCursor(this, cursor);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }
}

