/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.CalendarSync;

import com.sun.pdasync.Properties.UserProps;
import com.sun.pdasync.SyncUtils.SyncConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class CalendarSyncProperties
extends UserProps {
    private static Locale theLocale;
    private static ResourceBundle calRes;
    private static ResourceBundle calTips;
    public static final String CALENDAR_LOC = "calconduit.location";
    public static final String DATE_RANGE_WINDOW_SIZE = "calconduit.windowSize";
    public static final String PRIVACY_SHOW_TIME = "calconduit.privacyShowTime";
    public static final String SYNC_BEHAVIOR = "calconduit.syncBehavior";
    public static final String SYNC_BEHAVIOR_MERGE = "merge";
    public static final String SYNC_BEHAVIOR_DESKTOP = "desktop";
    public static final String SYNC_BEHAVIOR_PDA = "pda";
    public String calLocation;
    public int windowSize;
    public boolean privacyShowTime;
    public String syncBehavior;

    static {
        try {
            theLocale = Locale.getDefault();
            calRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CalendarSyncPropsUIMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: CalendarSyncProperties can't find properties");
            System.err.println("PDASync:" + e.getMessage());
            System.exit(1);
        }
    }

    public CalendarSyncProperties() {
        super("CalSyncConduit.def", "Calendar Synchronization Properties");
        this.getProperties();
    }

    private String getDefaultCalendar() {
        FileInputStream in = null;
        String tmp = null;
        File handle = new File(String.valueOf(SyncConstants.HOME_DIR) + "/.desksetdefaults");
        if (handle.exists()) {
            Properties desksetDefaults = new Properties();
            try {
                in = new FileInputStream(String.valueOf(SyncConstants.HOME_DIR) + "/.desksetdefaults");
                desksetDefaults.load(in);
            }
            catch (IOException iOException) {}
            tmp = desksetDefaults.getProperty("deskset.calendar.DefaultCal");
        }
        if (tmp == null) {
            String hostname = null;
            try {
                InetAddress local = InetAddress.getLocalHost();
                hostname = local.getHostName();
            }
            catch (UnknownHostException unknownHostException) {}
            if (hostname == null) {
                hostname = new String("localhost");
            }
            tmp = new String(String.valueOf(System.getProperty("user.name")) + "@" + hostname);
        }
        if (tmp.indexOf(47) != -1 || tmp.indexOf(64) == -1) {
            tmp = null;
        }
        return tmp;
    }

    public String getNextMonth(int nMonths) {
        String tmp = null;
        DateFormat dateFormatter = DateFormat.getDateInstance(1, theLocale);
        Calendar cal = Calendar.getInstance();
        cal.add(2, nMonths);
        tmp = new String(dateFormatter.format(cal.getTime()));
        return tmp;
    }

    public void printProps(String msg, Properties props) {
    }

    protected void savePropertiesError() {
    }

    public void setDefaultSettings(Properties userSettings) {
        this.calLocation = this.getDefaultCalendar();
        if (this.calLocation != null) {
            ((Hashtable)userSettings).put(CALENDAR_LOC, this.calLocation);
        }
        ((Hashtable)userSettings).put(DATE_RANGE_WINDOW_SIZE, Integer.toString(3));
        ((Hashtable)userSettings).put(PRIVACY_SHOW_TIME, Boolean.TRUE.toString());
        ((Hashtable)userSettings).put(SYNC_BEHAVIOR, SYNC_BEHAVIOR_MERGE);
    }

    protected void setProperties() {
        if (this.calLocation != null) {
            ((Hashtable)this.userProps).put(CALENDAR_LOC, this.calLocation);
        }
        ((Hashtable)this.userProps).put(DATE_RANGE_WINDOW_SIZE, Integer.toString(this.windowSize));
        ((Hashtable)this.userProps).put(PRIVACY_SHOW_TIME, new Boolean(this.privacyShowTime).toString());
        ((Hashtable)this.userProps).put(SYNC_BEHAVIOR, this.syncBehavior);
    }

    protected void setSettings() {
        String tmp = this.userProps.getProperty(CALENDAR_LOC);
        if (tmp != null) {
            this.calLocation = new String(tmp);
        }
        if ((tmp = this.userProps.getProperty(DATE_RANGE_WINDOW_SIZE)) != null) {
            this.windowSize = Integer.parseInt(tmp);
        }
        if ((tmp = this.userProps.getProperty(PRIVACY_SHOW_TIME)) != null) {
            this.privacyShowTime = new Boolean(tmp);
        }
        if ((tmp = this.userProps.getProperty(SYNC_BEHAVIOR)) != null) {
            this.syncBehavior = new String(tmp);
        }
    }
}

