/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.security;

import com.sun.wbem.cim.CIMException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Random;

public class SecurityUtil {
    private static final int RANDOM_KEYSIZE = 20;
    public static final String ADMIN = "root";
    public static final String GUEST = "guest";
    public static final String GUESTPASSWD = "guest";
    public static SecureRandom secrand = new SecureRandom(SecurityUtil.getSeed());

    public static byte[] extractHashedData(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = byArray[n2] ^ byArray2[n2];
            n += n3 << 8 * n2;
            ++n2;
        }
        if (n > byArray.length - byArray2.length || n < byArray.length - 2 * byArray2.length) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        byte[] byArray3 = new byte[n];
        n2 = byArray2.length;
        int n4 = n + n2;
        block1: while (n2 < n4) {
            int n5 = 0;
            while (n5 < byArray2.length) {
                if (n2 >= n4) continue block1;
                byArray3[n2 - byArray2.length] = (byte)(byArray[n2] ^ byArray2[n5]);
                ++n2;
                ++n5;
            }
        }
        return byArray3;
    }

    public static byte[] generateSerialized(Object[] objectArray) throws CIMException {
        byte[] byArray;
        ObjectOutputStream objectOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream(2048);
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new CIMException("Cannot initialize output stream");
        }
        int n = 0;
        while (n < objectArray.length) {
            try {
                objectOutputStream.writeObject(objectArray[n]);
            }
            catch (Exception exception) {
                throw new CIMException("Cannot write to output stream");
            }
            ++n;
        }
        try {
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new CIMException("Cannot write to byte array");
        }
        try {
            objectOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    private static synchronized byte[] getSeed() {
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        long l = System.currentTimeMillis();
        Random random = new Random(l);
        random.nextBytes(byArray);
        random.nextBytes(byArray2);
        l = System.currentTimeMillis();
        long l2 = 1L;
        long l3 = 0L;
        int n = 0;
        while (n < 20) {
            l3 = l & l2;
            byArray3[n] = l3 > 0L ? byArray[n] : byArray2[n];
            l2 <<= 1;
            ++n;
        }
        return byArray3;
    }

    public static byte[] hashData(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null || byArray == null) {
            throw new IllegalArgumentException();
        }
        if (byArray2.length < 4) {
            return null;
        }
        byte[] byArray3 = new byte[byArray2.length];
        SecureRandom secureRandom = secrand;
        synchronized (secureRandom) {
            secrand.nextBytes(byArray3);
        }
        int n = byArray.length / byArray2.length + 1;
        byte[] byArray4 = new byte[(n + 1) * byArray2.length];
        int n2 = 0;
        while (n2 < 4) {
            byArray4[n2] = (byte)(byArray2[n2] ^ (byArray.length & 255 << 8 * n2) >> 8 * n2);
            ++n2;
        }
        while (n2 < byArray2.length) {
            byArray4[n2] = byArray3[n2];
            ++n2;
        }
        SecureRandom secureRandom2 = secrand;
        synchronized (secureRandom2) {
            secrand.nextBytes(byArray3);
        }
        int n3 = 0;
        n2 = 0;
        while (n2 < n) {
            int n4 = 0;
            while (n4 < byArray2.length) {
                if (n3 >= byArray.length) break;
                byArray4[n3 + byArray2.length] = (byte)(byArray2[n4] ^ byArray[n3]);
                ++n3;
                ++n4;
            }
            ++n2;
        }
        n3 += byArray2.length;
        n2 = 0;
        while (n3 < byArray4.length) {
            byArray4[n3] = byArray3[n2];
            ++n2;
            ++n3;
        }
        return byArray4;
    }

    public static void incByteArray(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            byArray[n] = (byte)(by + 1);
            if (byArray[n] != 0) break;
            ++n;
        }
    }

    public static synchronized byte[] signDigest(byte[] byArray, PrivateKey privateKey, Signature signature) throws CIMException {
        byte[] byArray2 = null;
        try {
            signature.initSign(privateKey);
            signature.update(byArray);
            byArray2 = signature.sign();
        }
        catch (Exception exception) {
            throw new CIMException("Cannot sign");
        }
        return byArray2;
    }

    public static synchronized boolean verifyDigest(byte[] byArray, Signature signature, byte[] byArray2, PublicKey publicKey) throws CIMException {
        boolean bl = false;
        try {
            signature.initVerify(publicKey);
            signature.update(byArray);
            bl = signature.verify(byArray2);
        }
        catch (Exception exception) {
            throw new CIMException("Cannot verify");
        }
        return bl;
    }
}

