/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.query;

import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.query.DateTimeExp;
import com.sun.wbem.query.NumericValue;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.StringValueExp;
import com.sun.wbem.query.ValueExp;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.StringCharacterIterator;

public class BinaryRelQueryExp
extends QueryExp {
    private int relOp;
    private ValueExp exp1;
    private ValueExp exp2;

    public BinaryRelQueryExp() {
    }

    public BinaryRelQueryExp(int n, ValueExp valueExp, ValueExp valueExp2) {
        this.relOp = n;
        this.exp1 = valueExp;
        this.exp2 = valueExp2;
    }

    public boolean apply(CIMElement cIMElement) throws CIMException {
        return this.doApply(this.exp1.apply(cIMElement), this.exp2.apply(cIMElement));
    }

    private boolean doApply(Object object, Object object2) throws CIMException {
        Serializable serializable;
        Serializable serializable2;
        boolean bl = object instanceof NumericValue;
        if (object == null || object2 == null) {
            return false;
        }
        if (bl) {
            serializable2 = new BigDecimal(object.toString());
            serializable = new BigDecimal(object2.toString());
            switch (this.relOp) {
                case 0: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) > 0;
                }
                case 1: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) < 0;
                }
                case 2: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) >= 0;
                }
                case 3: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) <= 0;
                }
                case 4: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) == 0;
                }
                case 5: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) != 0;
                }
            }
        }
        if (object instanceof DateTimeExp || object2 instanceof DateTimeExp) {
            if (!(object instanceof DateTimeExp)) {
                try {
                    object = new DateTimeExp(((StringValueExp)object).getValue());
                }
                catch (Exception exception) {
                    throw new CIMException("CIM_ERR_FAILED", object.toString());
                }
            }
            serializable2 = ((DateTimeExp)object).getValue();
            if (!(object2 instanceof DateTimeExp)) {
                try {
                    object2 = new DateTimeExp(((StringValueExp)object2).getValue());
                }
                catch (Exception exception) {
                    throw new CIMException("CIM_ERR_FAILED", object2.toString());
                }
            }
            serializable = ((DateTimeExp)object2).getValue();
            switch (this.relOp) {
                case 0: {
                    return ((CIMDateTime)serializable2).after((CIMDateTime)serializable);
                }
                case 1: {
                    return ((CIMDateTime)serializable2).before((CIMDateTime)serializable);
                }
                case 2: {
                    return ((CIMDateTime)serializable2).after((CIMDateTime)serializable) || ((CIMDateTime)serializable2).equals(serializable);
                }
                case 3: {
                    return ((CIMDateTime)serializable2).before((CIMDateTime)serializable) || ((CIMDateTime)serializable2).equals(serializable);
                }
                case 4: {
                    return ((CIMDateTime)serializable2).equals(serializable);
                }
                case 5: {
                    return ((CIMDateTime)serializable2).equals(serializable) ^ true;
                }
                default: {
                    return false;
                }
            }
        }
        String string = ((StringValueExp)object).getValue();
        String string2 = ((StringValueExp)object2).getValue();
        switch (this.relOp) {
            case 0: {
                return string.compareTo(string2) > 0;
            }
            case 1: {
                return string.compareTo(string2) < 0;
            }
            case 2: {
                return string.compareTo(string2) >= 0;
            }
            case 3: {
                return string.compareTo(string2) <= 0;
            }
            case 4: {
                return string.compareTo(string2) == 0;
            }
            case 5: {
                return string.compareTo(string2) != 0;
            }
            case 6: {
                return this.like(string, string2);
            }
            case 7: {
                return this.like(string, string2) ^ true;
            }
        }
        return false;
    }

    public ValueExp getLeftValue() {
        return this.exp1;
    }

    public int getOperator() {
        return this.relOp;
    }

    public ValueExp getRightValue() {
        return this.exp2;
    }

    private boolean like(String string, String string2) {
        int n = -1;
        int n2 = 0;
        int n3 = -1;
        char c = '\uffff';
        int n4 = string.length();
        string2 = this.trimPercent(string2);
        int n5 = string2.length() - 1;
        int n6 = 0;
        while (n6 < n4) {
            char c2;
            if (n2 > n5) {
                return false;
            }
            char c3 = string2.charAt(n2);
            if (c3 == '%') {
                n = n2;
                if (n2 == n5) {
                    return true;
                }
                c2 = string.charAt(n6);
                if (c2 == string2.charAt(n2 + 1)) {
                    n2 += 2;
                    c = c2;
                    n3 = -1;
                }
            } else {
                c2 = string.charAt(n6);
                if (n3 == -1 && c2 == c) {
                    n3 = n6;
                }
                if (c2 != c3) {
                    if (n == -1) {
                        return false;
                    }
                    n2 = n;
                    if (n3 != -1) {
                        n6 = n3 - 1;
                        n3 = -1;
                    }
                } else {
                    ++n2;
                }
            }
            ++n6;
        }
        return n2 > n5 || n2 == n5 && string2.charAt(n5) == '%';
    }

    private String relOpString() {
        switch (this.relOp) {
            case 0: {
                return ">";
            }
            case 1: {
                return "<";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "=";
            }
            case 5: {
                return "<>";
            }
            case 6: {
                return "LIKE";
            }
            case 7: {
                return "NOT LIKE";
            }
            case 8: {
                return "ISA";
            }
            case 9: {
                return "NOT ISA";
            }
        }
        return "=";
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.exp1)) + " " + this.relOpString() + " " + this.exp2;
    }

    private String trimPercent(String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 65535;
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c != '%' || n != 37) {
                stringBuffer.append(c);
            }
            n = c;
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }
}

