/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.CIMVersion;
import com.sun.wbem.client.CIMClientAPI;
import com.sun.wbem.client.CIMClientFactory;
import com.sun.wbem.client.CIMClientRMI;
import com.sun.wbem.client.CIMEvent;
import com.sun.wbem.client.CIMListener;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.CheckSumGen;
import com.sun.wbem.security.ClientSecurityContext;
import com.sun.wbem.security.ClientSecurityFactory;
import com.sun.wbem.security.PasswordCredential;
import com.sun.wbem.security.RmiClientSecurity;
import com.sun.wbem.security.UserPrincipal;
import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CIMClient
implements CIMOMHandle {
    private String version;
    private CIMClientAPI api;
    private CIMNameSpace nameSpace;
    protected Hashtable subIdListenerMap;
    private InetAddress host;
    private ClientSecurityContext csc = null;
    private static int protocol;
    private CheckSumGen csg = new CheckSumGen();
    private ThreadLocal tl = new ThreadLocal();
    private static final int DEBUG_OFF = 0;
    private boolean listenerset = false;
    public static final int RMI = 1;
    public static final int XML = 0;
    public static final int HTTP = 0;
    public static final boolean DEEP = true;
    public static final boolean SHALLOW = false;
    public static final int WQL = 0;
    private boolean AUTHENTICATE = true;
    private ClientListener clientListener = new ClientListener();

    public CIMClient() throws CIMException {
        this(new CIMNameSpace(), new UserPrincipal("guest"), new PasswordCredential("guest"), 1, 0);
    }

    public CIMClient(CIMNameSpace cIMNameSpace) throws CIMException {
        this(cIMNameSpace, new UserPrincipal("guest"), new PasswordCredential("guest"), 1, 0);
    }

    public CIMClient(CIMNameSpace cIMNameSpace, String string, String string2) throws CIMException {
        this(cIMNameSpace, new UserPrincipal(string == null ? "guest" : string), new PasswordCredential(string2 == null ? "guest" : string2), 1, 0);
    }

    public CIMClient(CIMNameSpace cIMNameSpace, String string, String string2, int n) throws CIMException {
        this(cIMNameSpace, new UserPrincipal(string == null ? "guest" : string), new PasswordCredential(string2 == null ? "guest" : string2), n, 0);
    }

    public CIMClient(CIMNameSpace cIMNameSpace, Principal principal, Object object) throws CIMException {
        this(cIMNameSpace, principal, object, 1, 0);
    }

    public CIMClient(CIMNameSpace cIMNameSpace, Principal principal, Object object, int n) throws CIMException {
        this(cIMNameSpace, principal, object, n, 0);
    }

    CIMClient(CIMNameSpace cIMNameSpace, Principal principal, Object object, int n, int n2) throws CIMException {
        String string;
        this.setProtocol(n);
        this.version = String.valueOf(CIMVersion.major);
        if (cIMNameSpace == null) {
            cIMNameSpace = new CIMNameSpace();
        }
        if (principal == null) {
            principal = new UserPrincipal("guest");
        }
        if ((string = principal.getName()) == null || string.trim().length() == 0) {
            principal = new UserPrincipal("guest");
        }
        if (object == null) {
            object = new PasswordCredential("guest");
        }
        cIMNameSpace.setNameSpace("\\" + cIMNameSpace.getNameSpace());
        this.nameSpace = cIMNameSpace;
        this.api = CIMClientFactory.getClientAPI(this.version, this.nameSpace, n, n2, this.clientListener);
        this.csc = ClientSecurityFactory.createClientSecurity(this.nameSpace, principal, object, null, n);
        this.api.initSecurityContext(this.version, this.csc);
    }

    public void addCIMListener(CIMListener cIMListener) throws CIMException {
        if (protocol == 1 && !this.listenerset) {
            CIMClient cIMClient = this;
            synchronized (cIMClient) {
                if (!this.listenerset) {
                    ((CIMClientRMI)this.api).setListener(this.version);
                    this.listenerset = true;
                }
            }
        }
        this.clientListener.addCIMListener(cIMListener);
    }

    public Enumeration associatorNames(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4) throws CIMException {
        Vector vector = this.api.associatorNames(this.version, this.nameSpace, cIMObjectPath, string, string2, string3, string4);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string5 = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string5);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public Enumeration associators(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        Vector vector = this.api.associators(this.version, this.nameSpace, cIMObjectPath, string, string2, string3, string4, bl, bl2, stringArray);
        return vector.elements();
    }

    public synchronized void close() throws CIMException {
        String[] stringArray = new String[]{this.version, "close"};
        this.api.close(this.version);
    }

    public synchronized void createClass(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        this.api.createClass(this.version, this.nameSpace, cIMObjectPath, cIMClass);
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        return this.api.createInstance(this.version, this.nameSpace, cIMObjectPath, cIMInstance);
    }

    public synchronized void createNameSpace(CIMNameSpace cIMNameSpace) throws CIMException {
        this.api.createNameSpace(this.version, this.nameSpace, cIMNameSpace);
    }

    public synchronized void createQualifierType(CIMObjectPath cIMObjectPath, CIMQualifierType cIMQualifierType) throws CIMException {
        this.api.createQualifierType(this.version, this.nameSpace, cIMObjectPath, cIMQualifierType);
    }

    public synchronized void deleteClass(CIMObjectPath cIMObjectPath) throws CIMException {
        this.api.deleteClass(this.version, this.nameSpace, cIMObjectPath);
    }

    public synchronized void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        this.api.deleteInstance(this.version, this.nameSpace, cIMObjectPath);
    }

    public synchronized void deleteNameSpace(CIMNameSpace cIMNameSpace) throws CIMException {
        this.api.deleteNameSpace(this.version, this.nameSpace, cIMNameSpace);
    }

    public synchronized void deleteQualifierType(CIMObjectPath cIMObjectPath) throws CIMException {
        this.api.deleteQualifierType(this.version, this.nameSpace, cIMObjectPath);
    }

    public String encryptData(String string) throws CIMException {
        if (string == null) {
            return null;
        }
        RmiClientSecurity rmiClientSecurity = null;
        try {
            rmiClientSecurity = (RmiClientSecurity)this.csc;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        String string2 = rmiClientSecurity.trans51Format(string);
        return "<" + string2 + ">";
    }

    public synchronized Enumeration enumClass(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Vector vector = this.api.enumClass(this.version, this.nameSpace, cIMObjectPath, bl);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public synchronized Enumeration enumClass(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        Vector vector = this.api.enumClass(this.version, this.nameSpace, cIMObjectPath, bl, bl2);
        return vector.elements();
    }

    public synchronized Enumeration enumInstances(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Vector vector = this.api.enumInstances(this.version, this.nameSpace, cIMObjectPath, bl);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public synchronized Enumeration enumInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        Vector vector = this.api.enumInstances(this.version, this.nameSpace, cIMObjectPath, bl, bl2);
        return vector.elements();
    }

    public synchronized Enumeration enumNameSpace(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Vector vector = this.api.enumNameSpace(this.version, this.nameSpace, cIMObjectPath, bl);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public synchronized Enumeration enumQualifierTypes(CIMObjectPath cIMObjectPath) throws CIMException {
        Vector vector = this.api.enumQualifierTypes(this.version, this.nameSpace, cIMObjectPath);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public synchronized Enumeration enumerateClassNames(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Vector vector = this.api.enumerateClassNames(this.version, this.nameSpace, cIMObjectPath, bl);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws CIMException {
        Vector vector = this.api.enumerateClasses(this.version, this.nameSpace, cIMObjectPath, bl, bl2, bl3, bl4);
        return vector.elements();
    }

    public synchronized Enumeration enumerateInstanceNames(CIMObjectPath cIMObjectPath) throws CIMException {
        Vector vector = this.api.enumerateInstanceNames(this.version, this.nameSpace, cIMObjectPath);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray) throws CIMException {
        Vector vector = this.api.enumerateInstances(this.version, this.nameSpace, cIMObjectPath, bl, bl2, bl3, bl4, stringArray);
        return vector.elements();
    }

    public synchronized Enumeration execQuery(CIMObjectPath cIMObjectPath, String string, int n) throws CIMException {
        Vector vector = this.api.execQuery(this.version, this.nameSpace, cIMObjectPath, string, n);
        return vector.elements();
    }

    protected void finalize() {
    }

    public synchronized CIMClass getClass(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        return this.api.getClass(this.version, this.nameSpace, cIMObjectPath, bl);
    }

    public synchronized CIMClass getClass(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        return this.api.getClass(this.version, this.nameSpace, cIMObjectPath, bl, bl2, bl3, stringArray);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        return this.api.getInstance(this.version, this.nameSpace, cIMObjectPath, bl);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        return this.api.getInstance(this.version, this.nameSpace, cIMObjectPath, bl, bl2, bl3, stringArray);
    }

    public synchronized CIMValue getProperty(CIMObjectPath cIMObjectPath, String string) throws CIMException {
        return this.api.getProperty(this.version, this.nameSpace, cIMObjectPath, string);
    }

    private int getProtocol() {
        return protocol;
    }

    public synchronized CIMQualifierType getQualifierType(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.api.getQualifierType(this.version, this.nameSpace, cIMObjectPath);
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        return this.api.invokeMethod(this.version, this.nameSpace, cIMObjectPath, string, vector, vector2);
    }

    public Enumeration referenceNames(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        Vector vector = this.api.referenceNames(this.version, this.nameSpace, cIMObjectPath, string, string2);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string3 = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string3);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public Enumeration references(CIMObjectPath cIMObjectPath, String string, String string2, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        Vector vector = this.api.references(this.version, this.nameSpace, cIMObjectPath, string, string2, bl, bl2, stringArray);
        return vector.elements();
    }

    public void removeCIMListener(CIMListener cIMListener) throws CIMException {
        this.clientListener.removeCIMListener(cIMListener);
    }

    public synchronized void setClass(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        this.api.setClass(this.version, this.nameSpace, cIMObjectPath, cIMClass);
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.api.setInstance(this.version, this.nameSpace, cIMObjectPath, cIMInstance);
    }

    public synchronized void setProperty(CIMObjectPath cIMObjectPath, String string, CIMValue cIMValue) throws CIMException {
        this.api.setProperty(this.version, this.nameSpace, cIMObjectPath, string, cIMValue);
    }

    private void setProtocol(int n) {
        protocol = n;
    }

    public synchronized void setQualifierType(CIMObjectPath cIMObjectPath, CIMQualifierType cIMQualifierType) throws CIMException {
        this.api.setQualifierType(this.version, this.nameSpace, cIMObjectPath, cIMQualifierType);
    }

    static String stripNS(String string, String string2) {
        if ((string = string.toLowerCase()).startsWith(string2 = string2.toLowerCase())) {
            String string3 = string.substring(string2.length());
            if (string3.startsWith("\\")) {
                return string3.substring(1);
            }
            return string3;
        }
        return string;
    }

    private class ClientListener
    implements CIMListener {
        private List listenerList = new ArrayList();

        ClientListener() {
        }

        public void addCIMListener(CIMListener cIMListener) {
            if (cIMListener == null) {
                return;
            }
            if (!this.listenerList.contains(cIMListener)) {
                this.listenerList.add(cIMListener);
            }
        }

        public void indicationOccured(CIMEvent cIMEvent) {
            new IndicationDeliverer(cIMEvent).start();
        }

        public void removeCIMListener(CIMListener cIMListener) {
            this.listenerList.remove(cIMListener);
        }

        private class IndicationDeliverer
        extends Thread {
            CIMEvent e;

            IndicationDeliverer(CIMEvent cIMEvent) {
                this.e = cIMEvent;
            }

            public void run() {
                ArrayList arrayList = new ArrayList(ClientListener.this.listenerList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    CIMListener cIMListener = (CIMListener)iterator.next();
                    cIMListener.indicationOccured(this.e);
                }
            }
        }
    }
}

