/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMFlavor;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.MOFFormatter;
import com.sun.wbem.cim.XmlInstance;
import java.util.Enumeration;
import java.util.Vector;

public class CIMQualifier
extends CIMElement
implements Cloneable {
    static final long serialVersionUID = 200L;
    private CIMValue value;
    private Vector flavors = new Vector();

    public CIMQualifier() {
        super("");
    }

    public CIMQualifier(String string) {
        super(string);
        this.value = null;
        this.flavors = new Vector();
    }

    public CIMQualifier(String string, CIMQualifierType cIMQualifierType) {
        this(string);
        this.setDefaults(cIMQualifierType);
    }

    public void addFlavor(CIMFlavor cIMFlavor) {
        if (!this.hasFlavor(cIMFlavor)) {
            this.flavors.addElement(cIMFlavor);
        }
    }

    public synchronized Object clone() {
        CIMQualifier cIMQualifier = new CIMQualifier();
        cIMQualifier.name = this.name;
        cIMQualifier.identifier = this.identifier;
        cIMQualifier.value = this.value;
        cIMQualifier.flavors = (Vector)this.flavors.clone();
        return cIMQualifier;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CIMQualifier)) {
            return false;
        }
        return super.equals(object);
    }

    public Vector getFlavor() {
        return this.flavors;
    }

    public CIMValue getValue() {
        return this.value;
    }

    public boolean hasFlavor(CIMFlavor cIMFlavor) {
        if (this.flavors == null) {
            return false;
        }
        Enumeration enumeration = this.flavors.elements();
        while (enumeration.hasMoreElements()) {
            if (!((CIMFlavor)enumeration.nextElement()).equals(cIMFlavor)) continue;
            return true;
        }
        return false;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public void setDefaults(CIMQualifierType cIMQualifierType) {
        if (!this.hasValue() && cIMQualifierType.hasDefaultValue()) {
            CIMValue cIMValue = cIMQualifierType.getDefaultValue();
            this.value = cIMValue.getType() == null && cIMQualifierType.getType() != null ? new CIMValue(cIMValue.getValue(), cIMQualifierType.getType()) : cIMValue;
        }
        if (this.flavors == null || this.flavors.size() == 0) {
            this.flavors = (Vector)cIMQualifierType.getFlavor().clone();
        }
    }

    public void setValue(CIMValue cIMValue) {
        this.value = cIMValue;
    }

    public String toMOF() {
        MOFFormatter mOFFormatter = new MOFFormatter();
        return mOFFormatter.toString(this);
    }

    public String toString() {
        return this.toMOF();
    }

    public String toXml() {
        XmlInstance xmlInstance = new XmlInstance();
        return xmlInstance.toXml(this);
    }
}

