/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.HotSync;

import com.sun.pdasync.HotSync.CSyncTask;
import com.sun.pdasync.HotSync.DBListDef;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.SyncMgr.CDbList;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class CTaskMaster
implements Serializable {
    private String feedback;
    private static Locale theLocale;
    private static ResourceBundle messages;
    public static final int INSTALL_TASK_CREATOR = 0;
    public static final int TCP_TASK_CREATOR = 1;
    public static final int BACKUP_TASK_CREATOR = -1;
    public static final int APPLICATION_IDENTIFIER = 1634758764;
    public static final int DATA_IDENTIFIER = 0x44415441;
    public CDbList[] m_dbList;
    public int[] m_nDbListCount = new int[1];
    public boolean m_bValidDbList;
    public Vector m_syncTasks;
    public int m_dwCreator_ui;

    static {
        try {
            theLocale = Locale.getDefault();
            messages = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.HotSyncMessages", theLocale);
        }
        catch (MissingResourceException e) {
            Logger.doLogging((String)"CConduitJar: can't find message file");
            Logger.doLogging((String)("CConduitJar:" + e.getMessage()));
            System.exit(1);
        }
    }

    public CTaskMaster() {
        this.m_nDbListCount[0] = 0;
        this.m_bValidDbList = false;
        this.m_dbList = null;
        this.m_syncTasks = new Vector();
        this.m_dwCreator_ui = 0;
    }

    public CSyncTask FindTask(int dwCreator_ui) {
        int nCount = this.GetTaskCount();
        int n = 0;
        while (n < nCount) {
            CSyncTask pTask = this.GetTask(n);
            if (pTask != null && pTask.GetCreator() == dwCreator_ui) {
                return pTask;
            }
            ++n;
        }
        return null;
    }

    public CSyncTask GetBackupTask() {
        return this.FindTask(-1);
    }

    public int GetCreator() {
        return this.m_dwCreator_ui;
    }

    public CSyncTask GetTask(int nIndex) {
        if (nIndex >= 0 && nIndex < this.GetTaskCount()) {
            return (CSyncTask)this.m_syncTasks.elementAt(nIndex);
        }
        return null;
    }

    public int GetTaskCount() {
        return this.m_syncTasks.size();
    }

    public void addPendingToBackup() {
        int nCount = this.GetTaskCount();
        CSyncTask pBackupTask = this.getBackupTask();
        CSyncTask pInstallTask = this.getInstallTask();
        int n = 0;
        while (n < nCount) {
            CSyncTask pTask = this.getTask(n);
            if (pTask != null && pTask != pBackupTask && pTask != pInstallTask && pTask.getState() == 1) {
                this.addTaskToBackup(pTask);
            }
            ++n;
        }
    }

    public boolean addSpecialTask(int dwCreatorID) {
        CSyncTask pTask = new CSyncTask();
        if (pTask != null) {
            pTask.setCreator(dwCreatorID);
            pTask.setState(1);
            this.m_syncTasks.addElement(pTask);
            return true;
        }
        return false;
    }

    public void addTaskToBackup(CSyncTask pTask) {
        CSyncTask pBackupTask = this.getBackupTask();
        if (pBackupTask != null && pTask != pBackupTask) {
            if (pBackupTask.addBackupsFromTask(pTask)) {
                pTask.setState(2);
            } else {
                pTask.setState(3);
            }
        }
    }

    public boolean createTasks() {
        CSyncTask pTask;
        if (!this.m_bValidDbList) {
            return false;
        }
        int n = 0;
        while (n < this.m_nDbListCount[0]) {
            if (this.m_dbList[n].m_DbType_u == 1634758764) {
                pTask = new CSyncTask();
                if (pTask != null) {
                    if ((this.m_dbList[n].m_miscFlags & 0x80) == 0) {
                        pTask.setCreator(this.m_dbList[n].m_Creator_u);
                        pTask.setState(1);
                        this.m_syncTasks.addElement(pTask);
                        this.m_syncTasks.addElement(pTask);
                        this.feedback = "createTask(): Task created for database:\n" + this.m_dbList[n].dumpFormatted();
                        Logger.doDebugLogging((String)this.feedback, (int)4);
                    }
                } else {
                    return false;
                }
            }
            ++n;
        }
        pTask = new CSyncTask();
        if (pTask == null) {
            return false;
        }
        pTask.setCreator(-1);
        pTask.setState(1);
        this.m_syncTasks.addElement(pTask);
        this.feedback = String.valueOf(messages.getString("Backup task created:")) + "\n" + pTask.dumpFormatted();
        Logger.doDebugLogging((String)this.feedback, (int)4);
        pTask = new CSyncTask();
        if (pTask == null) {
            return false;
        }
        pTask.setCreator(0);
        pTask.setState(1);
        this.m_syncTasks.addElement(pTask);
        this.feedback = String.valueOf(messages.getString("Install task created:")) + "\n" + pTask.dumpFormatted();
        Logger.doDebugLogging((String)this.feedback, (int)4);
        return this.gatherDatabases();
    }

    public CSyncTask findTask(int dwCreator) {
        int nCount = this.GetTaskCount();
        int n = 0;
        while (n < nCount) {
            CSyncTask pTask = this.getTask(n);
            if (pTask != null && pTask.m_dwCreator_ui == dwCreator) {
                return pTask;
            }
            ++n;
        }
        return null;
    }

    protected boolean gatherDatabases() {
        if (!this.m_bValidDbList || this.GetTaskCount() == 0) {
            return false;
        }
        CSyncTask pBackupTask = this.getBackupTask();
        if (pBackupTask == null) {
            return false;
        }
        int n = 0;
        while (n < this.m_nDbListCount[0]) {
            if (this.m_dbList[n].m_Name.length > 0 && (this.m_dbList[n].m_miscFlags & 0x80) == 0) {
                if (this.m_dbList[n].m_DbType_u == 0x44415441) {
                    CSyncTask pTask = this.findTask(this.m_dbList[n].m_Creator_u);
                    if (pTask != null) {
                        pTask.addDatabase(this.m_dbList[n]);
                        this.feedback = "gatherDatabases(): Adding data to task list: (creator: 0x" + Integer.toHexString(pTask.getCreator()) + ")\n" + this.m_dbList[n].dumpFormatted();
                        Logger.doDebugLogging((String)this.feedback, (int)4);
                    } else if ((this.m_dbList[n].getDbFlags() & 8) != 0) {
                        pBackupTask.addDatabase(this.m_dbList[n]);
                        this.feedback = "gatherDatabases(): Adding data to backup task:\n" + this.m_dbList[n].dumpFormatted();
                        Logger.doDebugLogging((String)this.feedback, (int)4);
                    }
                } else {
                    pBackupTask.addDatabase(this.m_dbList[n]);
                    this.feedback = "gatherDatabases(): Adding application to backup task:\n" + this.m_dbList[n].dumpFormatted();
                    Logger.doDebugLogging((String)this.feedback, (int)4);
                }
            } else {
                this.feedback = "gatherDatabases(): Not added to task list:\n" + this.m_dbList[n].dumpFormatted();
                Logger.doDebugLogging((String)this.feedback, (int)4);
            }
            ++n;
        }
        return true;
    }

    public CSyncTask getBackupTask() {
        return this.findTask(-1);
    }

    public CSyncTask getInstallTask() {
        return this.findTask(0);
    }

    public CSyncTask getTask(int nIndex) {
        if (nIndex >= 0 && nIndex < this.GetTaskCount()) {
            return (CSyncTask)this.m_syncTasks.elementAt(nIndex);
        }
        return null;
    }

    public void writeDBList() {
        if (!this.m_bValidDbList) {
            return;
        }
        DBListDef dbListDef = new DBListDef();
        int i = 0;
        while (i < this.m_dbList.length) {
            if (this.m_dbList[i].m_DbType_u == 0x44415441) {
                dbListDef.addElement(new String(this.m_dbList[i].m_Name), this.m_dbList[i].m_Creator_u);
            }
            ++i;
        }
        dbListDef.save();
    }
}

